/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.agent;

import io.sf.carte.doc.agent.AuthenticationCredentials;
import io.sf.carte.doc.agent.Cookie;
import io.sf.carte.doc.agent.CookieConfig;
import io.sf.carte.doc.agent.OriginPolicy;
import io.sf.carte.doc.agent.UserAgent;
import io.sf.carte.doc.agent.UserAgentErrorHandler;
import io.sf.carte.doc.style.css.nsac.Parser;
import java.io.IOException;
import java.io.Serializable;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.StandardCharsets;
import java.security.Principal;
import java.util.Base64;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public abstract class AbstractUserAgent
implements UserAgent,
UserAgent.AgentControl,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final String HEADER_AUTHORIZATION = "Authorization";
    private static final String HEADER_AGENT = "User-agent";
    private static final String CSS4J_MAJOR_VERSION = "5";
    private static final String DEFAULT_USER_AGENT_STRING = AbstractUserAgent.userAgentString();
    private OriginPolicy originPolicy = null;
    private final EnumSet<Parser.Flag> parserFlags = EnumSet.noneOf(Parser.Flag.class);
    private UserAgentErrorHandler errorHandler = null;
    private final Map<String, Set<AuthenticationCredentials>> credentialMap = new HashMap<String, Set<AuthenticationCredentials>>();
    private String userAgentId = DEFAULT_USER_AGENT_STRING;
    private int timeout = 15000;

    protected AbstractUserAgent(EnumSet<Parser.Flag> parserFlags) {
        this.parserFlags.addAll(parserFlags);
    }

    private static String defaultUserAgent() {
        return "Mozilla/5.0 CSS4J/5";
    }

    private static String userAgentString() {
        String agentId;
        try {
            agentId = System.getProperty("http.agent");
        }
        catch (SecurityException e) {
            return AbstractUserAgent.defaultUserAgent();
        }
        if (agentId == null) {
            String osname;
            try {
                osname = System.getProperty("os.name");
            }
            catch (SecurityException e) {
                osname = null;
            }
            if (osname == null) {
                return AbstractUserAgent.defaultUserAgent();
            }
            StringBuilder buf = new StringBuilder(osname.length() + 30);
            buf.append("Mozilla/5.0 (").append(osname);
            try {
                String osarch = System.getProperty("os.arch");
                if (osarch != null) {
                    buf.append("; ").append(osarch);
                }
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
            buf.append(") CSS4J/").append(CSS4J_MAJOR_VERSION);
            agentId = buf.toString();
        }
        return agentId;
    }

    protected OriginPolicy getOriginPolicy() {
        return this.originPolicy;
    }

    public void setOriginPolicy(OriginPolicy originPolicy) {
        this.originPolicy = originPolicy;
    }

    @Override
    public UserAgent.AgentControl getAgentControl() {
        return this;
    }

    @Override
    @Deprecated(forRemoval=true)
    public CookieConfig getCookieConfig() {
        return null;
    }

    @Deprecated(forRemoval=true)
    public Set<Cookie> getCookies(String host) {
        return null;
    }

    public UserAgentErrorHandler getErrorHandler() {
        return this.errorHandler;
    }

    public void setErrorHandler(UserAgentErrorHandler handler) {
        this.errorHandler = handler;
    }

    protected EnumSet<Parser.Flag> getParserFlags() {
        return this.parserFlags;
    }

    @Override
    public String getProperty(String propertyName) {
        if (propertyName.equals("parser.starhack")) {
            return Boolean.toString(this.parserFlags.contains((Object)Parser.Flag.STARHACK));
        }
        if (propertyName.equals("parser.ievalues")) {
            return Boolean.toString(this.parserFlags.contains((Object)Parser.Flag.IEVALUES));
        }
        if (propertyName.equals("parser.ieprio")) {
            return Boolean.toString(this.parserFlags.contains((Object)Parser.Flag.IEPRIO));
        }
        if (propertyName.equals("parser.iepriochar")) {
            return Boolean.toString(this.parserFlags.contains((Object)Parser.Flag.IEPRIOCHAR));
        }
        return null;
    }

    @Override
    public boolean setProperty(String propertyName, String value) {
        if (propertyName.equals("parser.starhack")) {
            if ("true".equalsIgnoreCase(value)) {
                this.parserFlags.add(Parser.Flag.STARHACK);
            } else {
                this.parserFlags.remove((Object)Parser.Flag.STARHACK);
            }
            return true;
        }
        if (propertyName.equals("parser.ievalues")) {
            if ("true".equalsIgnoreCase(value)) {
                this.parserFlags.add(Parser.Flag.IEVALUES);
            } else {
                this.parserFlags.remove((Object)Parser.Flag.IEVALUES);
            }
            return true;
        }
        return false;
    }

    @Override
    public AuthenticationCredentials getAuthenticationCredentials(URL url, String realm) {
        Set<AuthenticationCredentials> credset = this.credentialMap.get(url.getHost());
        if (credset != null) {
            for (AuthenticationCredentials cred : credset) {
                String orealm = cred.getRealm();
                if (realm != null && !realm.equals(orealm)) continue;
                return cred;
            }
        }
        return null;
    }

    @Override
    public AuthenticationCredentials authenticationCredentials(String host, String realm) {
        if (realm == null) {
            throw new NullPointerException("Attempt to create a null realm.");
        }
        Set<AuthenticationCredentials> credset = this.credentialMap.get(host);
        if (credset == null) {
            credset = new HashSet<AuthenticationCredentials>();
        } else {
            for (AuthenticationCredentials cred : credset) {
                if (!realm.equals(cred.getRealm())) continue;
                return cred;
            }
        }
        MyAuthenticationCredentials creds = new MyAuthenticationCredentials(realm);
        credset.add(creds);
        return creds;
    }

    @Override
    public void setConnectionTimeout(int timeout) {
        this.timeout = timeout;
    }

    @Override
    public boolean isVisitedURL(URL url) {
        return false;
    }

    public void setUseragentId(String userAgentId) {
        this.userAgentId = userAgentId;
    }

    protected URLConnection openConnection(URL url, long creationDate) throws IOException {
        URLConnection con = this.createConnection(url);
        con.setConnectTimeout(this.timeout);
        con.setAllowUserInteraction(false);
        if (con instanceof HttpURLConnection) {
            HttpURLConnection hcon = (HttpURLConnection)con;
            this.setCredentials(hcon, url, null, creationDate);
            if (this.userAgentId != null) {
                hcon.setRequestProperty(HEADER_AGENT, this.userAgentId);
            }
        }
        return con;
    }

    protected URLConnection createConnection(URL url) throws IOException {
        return url.openConnection();
    }

    private void setCredentials(HttpURLConnection hcon, URL url, String realm, long creationDate) {
        AuthenticationCredentials creds = this.getAuthenticationCredentials(url, realm);
        if (creds != null && creds.getAuthType() == 1) {
            hcon.setRequestProperty(HEADER_AUTHORIZATION, AbstractUserAgent.basicToken(creds));
        }
    }

    private static String basicToken(AuthenticationCredentials creds) {
        String s;
        int i;
        StringBuilder sb = new StringBuilder(64);
        sb.append("Basic ").append(creds.getLoginPrincipal().getName()).append(':');
        if (creds.getPassword() != null) {
            sb.append(creds.getPassword());
        }
        if ((i = (s = Base64.getEncoder().encodeToString(sb.toString().getBytes(StandardCharsets.ISO_8859_1))).indexOf(61)) != -1) {
            return s.substring(0, i);
        }
        return s;
    }

    @Deprecated(forRemoval=true)
    protected void readCookies(HttpURLConnection hcon, long creationDate) {
    }

    static class MyAuthenticationCredentials
    implements AuthenticationCredentials {
        private Principal loginPrincipal = null;
        private String password = null;
        private final String realm;
        private byte authtype = 1;

        MyAuthenticationCredentials(String realm) {
            this.realm = realm;
        }

        @Override
        public Principal getLoginPrincipal() {
            return this.loginPrincipal;
        }

        @Override
        public void setLoginPrincipal(Principal loginPrincipal) {
            this.loginPrincipal = loginPrincipal;
        }

        @Override
        public String getPassword() {
            return this.password;
        }

        @Override
        public void setPassword(String password) {
            this.password = password;
        }

        @Override
        public String getRealm() {
            return this.realm;
        }

        @Override
        public void setAuthType(byte authtype) {
            this.authtype = authtype;
        }

        @Override
        public byte getAuthType() {
            return this.authtype;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.authtype;
            result = 31 * result + (this.loginPrincipal == null ? 0 : this.loginPrincipal.hashCode());
            result = 31 * result + (this.password == null ? 0 : this.password.hashCode());
            result = 31 * result + (this.realm == null ? 0 : this.realm.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            MyAuthenticationCredentials other = (MyAuthenticationCredentials)obj;
            if (this.authtype != other.authtype) {
                return false;
            }
            if (this.loginPrincipal == null ? other.loginPrincipal != null : !this.loginPrincipal.equals(other.loginPrincipal)) {
                return false;
            }
            if (this.password == null ? other.password != null : !this.password.equals(other.password)) {
                return false;
            }
            if (this.realm == null) {
                return other.realm == null;
            }
            return this.realm.equals(other.realm);
        }

        public String toString() {
            return "[loginPrincipal=" + this.loginPrincipal + ", password=" + this.password + ", realm=" + this.realm + "]";
        }
    }
}

