/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css;

import io.sf.carte.doc.style.css.CSSCanvas;
import io.sf.carte.doc.style.css.CSSElement;
import io.sf.carte.doc.style.css.CSSMediaException;
import io.sf.carte.doc.style.css.CSSNode;
import io.sf.carte.doc.style.css.CSSPropertyDefinition;
import io.sf.carte.doc.style.css.CSSRule;
import io.sf.carte.doc.style.css.CSSStyleSheetList;
import io.sf.carte.doc.style.css.DocumentCSSStyleSheet;
import io.sf.carte.doc.style.css.ErrorHandler;
import io.sf.carte.doc.style.css.StyleDatabase;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import org.w3c.dom.DOMException;
import org.w3c.dom.DOMStringList;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.stylesheets.DocumentStyle;

public interface CSSDocument
extends Document,
DocumentStyle,
CSSNode {
    @Override
    public CSSElement createElement(String var1) throws DOMException;

    @Override
    public CSSElement createElementNS(String var1, String var2) throws DOMException;

    default public String getCompatMode() {
        DocumentType doctype = this.getDoctype();
        if (doctype != null) {
            return "CSS1Compat";
        }
        return "BackCompat";
    }

    public ComplianceMode getComplianceMode();

    @Override
    public CSSElement getDocumentElement();

    @Override
    public CSSElement getElementById(String var1);

    @Override
    public CSSStyleSheetList<? extends CSSRule> getStyleSheets();

    public DOMStringList getStyleSheetSets();

    public String getSelectedStyleSheetSet();

    public void setSelectedStyleSheetSet(String var1);

    public String getLastStyleSheetSet();

    public void enableStyleSheetsForSet(String var1);

    public void registerProperty(CSSPropertyDefinition var1);

    public DocumentCSSStyleSheet getStyleSheet();

    public StyleDatabase getStyleDatabase();

    public void setTargetMedium(String var1) throws CSSMediaException;

    public String getTargetMedium();

    public CSSCanvas getCanvas();

    public void rebuildCascade();

    public String getReferrerPolicy();

    public boolean isSafeOrigin(URL var1);

    public boolean isAuthorizedOrigin(URL var1);

    default public URL getBaseURL() {
        URL baseURL = null;
        String buri = this.getBaseURI();
        if (buri != null) {
            try {
                URI uri = new URI(buri);
                baseURL = uri.toURL();
            }
            catch (Exception e) {
                this.getErrorHandler().nodeError(this, "Cannot convert URI to absolute: " + buri, e);
            }
        }
        return baseURL;
    }

    default public URL getURL(String uri) throws MalformedURLException {
        URL url;
        URI u;
        block6: {
            if (uri == null || uri.isEmpty()) {
                throw new MalformedURLException("Empty URI");
            }
            try {
                u = new URI(uri);
                if (u.isAbsolute()) break block6;
                url = this.getBaseURL();
                if (url != null) {
                    URI bu = url.toURI();
                    u = bu.resolve(u);
                    break block6;
                }
                throw new MalformedURLException("Cannot convert URI " + uri + " to absolute.");
            }
            catch (Exception e) {
                throw new MalformedURLException(e.getMessage());
            }
        }
        try {
            url = u.toURL();
        }
        catch (Exception e) {
            throw new MalformedURLException("Cannot convert URI " + uri + " to absolute.");
        }
        return url;
    }

    public URLConnection openConnection(URL var1) throws IOException;

    public boolean isVisitedURI(String var1);

    public ErrorHandler getErrorHandler();

    public boolean hasStyleIssues();

    public static enum ComplianceMode {
        QUIRKS,
        STRICT;

    }
}

