/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.impl;

import io.sf.carte.doc.style.css.CSSValueSyntax;
import io.sf.carte.doc.style.css.nsac.LexicalUnit;
import java.net.URL;
import java.util.Locale;

public class CSSUtil {
    public static boolean isInvalidCSSContentType(URL url, String conType) {
        if (conType == null) {
            String proto = url.getProtocol();
            return "https".equals(proto) || "http".equals(proto);
        }
        int sepidx = conType.indexOf(59);
        if (sepidx != -1) {
            conType = conType.substring(0, sepidx);
        }
        if ("text/css".equals(conType = conType.toLowerCase(Locale.ROOT))) {
            return false;
        }
        String proto = url.getProtocol();
        return !"jar".equals(proto) && !"file".equals(proto) && ("https".equals(proto) || "http".equals(proto) || !"content/unknown".equals(conType) && !"unknown/unknown".equals(conType) && !"application/x-unknown-content-type".equals(conType));
    }

    public static boolean isUnimplementedImageFunction(String lcfName) {
        return lcfName.equals("paint") || lcfName.equals("image") || lcfName.equals("cross-fade");
    }

    public static CSSValueSyntax.Match matchEnv(CSSValueSyntax rootSyntax, CSSValueSyntax syntax, String name, LexicalUnit fallback) {
        CSSValueSyntax.Match match;
        CSSValueSyntax.Category cat = syntax.getCategory();
        if (cat == CSSValueSyntax.Category.universal) {
            return CSSValueSyntax.Match.TRUE;
        }
        if (name.contains("width") || name.contains("height") || name.contains("-x") || name.contains("-y") || name.contains("top") || name.contains("right") || name.contains("bottom") || name.contains("left")) {
            if (cat == CSSValueSyntax.Category.length || cat == CSSValueSyntax.Category.lengthPercentage) {
                return CSSValueSyntax.Match.TRUE;
            }
            match = CSSValueSyntax.Match.FALSE;
        } else {
            match = CSSValueSyntax.Match.PENDING;
        }
        return fallback == null ? match : fallback.matches(rootSyntax);
    }
}

