/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.om;

import io.sf.carte.doc.style.css.CSSValueSyntax;
import io.sf.carte.doc.style.css.StyleDeclarationErrorHandler;
import io.sf.carte.doc.style.css.nsac.LexicalUnit;
import io.sf.carte.doc.style.css.om.BaseCSSDeclarationRule;
import io.sf.carte.doc.style.css.om.BaseCSSStyleDeclaration;
import io.sf.carte.doc.style.css.om.ShorthandSetter;
import io.sf.carte.doc.style.css.parser.SyntaxParser;
import io.sf.carte.doc.style.css.property.IdentifierValue;
import io.sf.carte.doc.style.css.property.StyleValue;
import io.sf.carte.doc.style.css.property.ValueList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

class AnimationShorthandSetter
extends ShorthandSetter {
    private final CSSValueSyntax syntaxEasing = SyntaxParser.createSimpleSyntax("easing-function");
    private final CSSValueSyntax syntaxNumber = SyntaxParser.createSimpleSyntax("number");
    private final CSSValueSyntax syntaxTime = SyntaxParser.createSimpleSyntax("time");
    private StringBuilder layerBuffer = null;
    private StringBuilder miniLayerBuffer = null;
    private int layerCount = 0;
    private final ValueList lstDuration = ValueList.createCSValueList();
    private final ValueList lstTimingFunction = ValueList.createCSValueList();
    private final ValueList lstDelay = ValueList.createCSValueList();
    private final ValueList lstIterationCount = ValueList.createCSValueList();
    private final ValueList lstDirection = ValueList.createCSValueList();
    private final ValueList lstFillMode = ValueList.createCSValueList();
    private final ValueList lstPlayState = ValueList.createCSValueList();
    private final ValueList lstTimeline = ValueList.createCSValueList();
    private final ValueList lstName = ValueList.createCSValueList();

    AnimationShorthandSetter(BaseCSSStyleDeclaration style) {
        super(style, "animation");
    }

    @Override
    public void init(LexicalUnit shorthandValue, boolean important) {
        this.currentValue = shorthandValue;
        this.setPriority(important);
        this.countLayers(shorthandValue);
    }

    void countLayers(LexicalUnit shorthandValue) {
        this.layerCount = 0;
        int valueCount = 0;
        for (LexicalUnit value = shorthandValue; value != null; value = value.getNextLexicalUnit()) {
            if (value.getLexicalUnitType() == LexicalUnit.LexicalType.OPERATOR_COMMA) {
                if (valueCount <= 0) continue;
                ++this.layerCount;
                valueCount = 0;
                continue;
            }
            ++valueCount;
        }
        if (valueCount > 0) {
            ++this.layerCount;
        }
    }

    @Override
    StringBuilder getValueItemBuffer() {
        return this.layerBuffer;
    }

    @Override
    StringBuilder getValueItemBufferMini() {
        return this.miniLayerBuffer;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    @Override
    public short assignSubproperties() {
        void var2_4;
        IdentifierValue normalIdent = new IdentifierValue("normal");
        normalIdent.setSubproperty(true);
        IdentifierValue identifierValue = normalIdent;
        this.layerBuffer = new StringBuilder(64);
        this.miniLayerBuffer = new StringBuilder(64);
        String[] subparray = this.getShorthandSubproperties();
        int i = 0;
        block5: while (i < this.layerCount && this.currentValue != null) {
            boolean validLayer = false;
            HashSet<String> subp = new HashSet<String>(subparray.length);
            Collections.addAll(subp, subparray);
            block6: while (this.currentValue != null) {
                if (this.currentValue.getLexicalUnitType() == LexicalUnit.LexicalType.OPERATOR_COMMA) {
                    if (!validLayer) break;
                    this.appendToValueBuffer(this.layerBuffer, this.miniLayerBuffer);
                    this.layerBuffer.setLength(0);
                    this.miniLayerBuffer.setLength(0);
                    if (++i != this.layerCount) {
                        this.layerBuffer.append(',');
                        this.miniLayerBuffer.append(',');
                    }
                    this.currentValue = this.currentValue.getNextLexicalUnit();
                    break;
                }
                LexicalUnit.LexicalType lutype = this.currentValue.getLexicalUnitType();
                if (lutype == LexicalUnit.LexicalType.INHERIT || lutype == LexicalUnit.LexicalType.INITIAL || lutype == LexicalUnit.LexicalType.UNSET || lutype == LexicalUnit.LexicalType.REVERT) {
                    StyleValue keyword = this.valueFactory.createCSSValueItem(this.currentValue, true).getCSSValue();
                    if (this.layerCount != 1 || this.currentValue.getPreviousLexicalUnit() != null || this.currentValue.getNextLexicalUnit() != null) {
                        BaseCSSDeclarationRule prule = this.styleDeclaration.getParentRule();
                        if (prule != null) {
                            StyleDeclarationErrorHandler eh = prule.getStyleDeclarationErrorHandler();
                            eh.shorthandSyntaxError(this.getShorthandName(), "Keyword found mixed with other values.");
                        }
                        return 2;
                    }
                    this.addSingleValueLayer(keyword);
                    this.appendValueItemString(keyword);
                    StyleValue styleValue = keyword;
                    break block5;
                }
                switch (this.assignLayerValue(subp)) {
                    case 0: {
                        validLayer = true;
                        break;
                    }
                    case 1: {
                        this.reportUnknownValue(subp, this.currentValue);
                        validLayer = false;
                        break block6;
                    }
                    case 2: {
                        this.flush();
                        return 1;
                    }
                }
            }
            if (!validLayer) {
                this.layerBuffer.setLength(0);
                this.miniLayerBuffer.setLength(0);
                StringBuilder msgbuf = new StringBuilder(64);
                msgbuf.append("Invalid layer found: ").append(i);
                if (this.currentValue != null) {
                    msgbuf.append(' ').append(this.currentValue.toString());
                }
                this.reportDeclarationError("animation", msgbuf.toString());
                return 2;
            }
            if (subp.isEmpty()) continue;
            this.resetUnsetProperties(subp);
        }
        this.appendToValueBuffer(this.layerBuffer, this.miniLayerBuffer);
        this.setListSubpropertyValue("animation-duration", this.lstDuration);
        this.setListSubpropertyValue("animation-timing-function", this.lstTimingFunction);
        this.setListSubpropertyValue("animation-delay", this.lstDelay);
        this.setListSubpropertyValue("animation-iteration-count", this.lstIterationCount);
        this.setListSubpropertyValue("animation-direction", this.lstDirection);
        this.setListSubpropertyValue("animation-fill-mode", this.lstFillMode);
        this.setListSubpropertyValue("animation-play-state", this.lstPlayState);
        this.setListSubpropertyValue("animation-timeline", this.lstTimeline);
        this.setListSubpropertyValue("animation-name", this.lstName);
        this.setSubpropertyValue("animation-range-start", (StyleValue)var2_4);
        this.setSubpropertyValue("animation-range-end", (StyleValue)var2_4);
        this.flush();
        return 0;
    }

    private void addSingleValueLayer(StyleValue keyword) {
        this.lstDuration.add(keyword);
        this.lstTimingFunction.add(keyword);
        this.lstDelay.add(keyword);
        this.lstIterationCount.add(keyword);
        this.lstDirection.add(keyword);
        this.lstFillMode.add(keyword);
        this.lstPlayState.add(keyword);
        this.lstTimeline.add(keyword);
        this.lstName.add(keyword);
    }

    /*
     * Enabled aggressive block sorting
     */
    private short assignLayerValue(Set<String> subp) {
        LexicalUnit.LexicalType type = this.currentValue.getLexicalUnitType();
        if (type == LexicalUnit.LexicalType.IDENT) {
            if (subp.contains("animation-timing-function") && this.testIdentifiers("transition-timing-function")) {
                this.lstTimingFunction.add(this.createCSSValue("animation-timing-function", this.currentValue));
                this.nextCurrentValue();
                subp.remove("animation-timing-function");
                return 0;
            }
            if (subp.contains("animation-iteration-count") && this.testIdentifiers("animation-iteration-count")) {
                this.lstIterationCount.add(this.createCSSValue("animation-iteration-count", this.currentValue));
                this.nextCurrentValue();
                subp.remove("animation-iteration-count");
                return 0;
            }
            if (subp.contains("animation-direction") && this.testIdentifiers("animation-direction")) {
                this.lstDirection.add(this.createCSSValue("animation-direction", this.currentValue));
                this.nextCurrentValue();
                subp.remove("animation-direction");
                return 0;
            }
            if (subp.contains("animation-fill-mode") && this.testIdentifiers("animation-fill-mode")) {
                this.lstFillMode.add(this.createCSSValue("animation-fill-mode", this.currentValue));
                this.nextCurrentValue();
                subp.remove("animation-fill-mode");
                return 0;
            }
            if (subp.contains("animation-play-state") && this.testIdentifiers("animation-play-state")) {
                this.lstPlayState.add(this.createCSSValue("animation-play-state", this.currentValue));
                this.nextCurrentValue();
                subp.remove("animation-play-state");
                return 0;
            }
            if ("none".equalsIgnoreCase(this.currentValue.getStringValue())) {
                this.currentValue = this.currentValue.getNextLexicalUnit();
                return 0;
            }
            if (subp.contains("animation-name") && !this.testIdentifiers("animation-timeline")) {
                this.lstName.add(this.createCSSValue("animation-name", this.currentValue));
                this.nextCurrentValue();
                subp.remove("animation-name");
                return 0;
            }
            if (subp.contains("animation-timeline")) {
                this.lstTimeline.add(this.createCSSValue("animation-timeline", this.currentValue));
                this.nextCurrentValue();
                subp.remove("animation-timeline");
                return 0;
            }
            if (subp.contains("animation-duration") && "auto".equalsIgnoreCase(this.currentValue.getStringValue())) {
                this.lstDuration.add(this.createCSSValue("animation-duration", this.currentValue));
                this.nextCurrentValue();
                subp.remove("animation-duration");
                return 0;
            }
            if (!this.isPrefixedIdentValue()) return 1;
            this.setPrefixedValue(this.currentValue);
            return 2;
        }
        if (type == LexicalUnit.LexicalType.INTEGER) {
            int ivalue = this.currentValue.getIntegerValue();
            if (ivalue >= 0) return this.setIterationCountValue(subp);
            return 1;
        }
        if (type == LexicalUnit.LexicalType.REAL) {
            float fvalue = this.currentValue.getFloatValue();
            if (!(fvalue < 0.0f)) return this.setIterationCountValue(subp);
            return 1;
        }
        if (this.currentValue.shallowMatch(this.syntaxNumber) == CSSValueSyntax.Match.TRUE) {
            return this.setIterationCountValue(subp);
        }
        if (type == LexicalUnit.LexicalType.FUNCTION) {
            if (!subp.contains("animation-timeline")) return 1;
            if (!"scroll".equals(this.currentValue.getFunctionName()) && !"view".equals(this.currentValue.getFunctionName())) {
                return 1;
            }
            this.lstTimeline.add(this.createCSSValue("animation-timeline", this.currentValue));
            subp.remove("animation-timeline");
            this.nextCurrentValue();
            return 0;
        }
        if (this.currentValue.shallowMatch(this.syntaxTime) == CSSValueSyntax.Match.TRUE) {
            ValueList list;
            String property = "animation-duration";
            if (!subp.contains(property)) {
                property = "animation-delay";
                if (!subp.contains(property)) {
                    return 1;
                }
                list = this.lstDelay;
            } else {
                list = this.lstDuration;
            }
            list.add(this.createCSSValue(property, this.currentValue));
            subp.remove(property);
            this.nextCurrentValue();
            return 0;
        }
        if (this.currentValue.shallowMatch(this.syntaxEasing) == CSSValueSyntax.Match.TRUE) {
            if (!subp.contains("animation-timing-function")) {
                return 1;
            }
            this.lstTimingFunction.add(this.createCSSValue("animation-timing-function", this.currentValue));
            subp.remove("animation-timing-function");
            this.nextCurrentValue();
            return 0;
        }
        if (type != LexicalUnit.LexicalType.STRING) {
            if (type != LexicalUnit.LexicalType.PREFIXED_FUNCTION) return 1;
            this.setPrefixedValue(this.currentValue);
            return 2;
        }
        if (!subp.contains("animation-name")) {
            return 1;
        }
        this.lstName.add(this.createCSSValue("animation-name", this.currentValue));
        this.nextCurrentValue();
        subp.remove("animation-name");
        return 0;
    }

    private short setIterationCountValue(Set<String> subp) {
        if (!subp.contains("animation-iteration-count")) {
            return 1;
        }
        this.lstIterationCount.add(this.createCSSValue("animation-iteration-count", this.currentValue));
        subp.remove("animation-iteration-count");
        this.nextCurrentValue();
        return 0;
    }

    private void reportUnknownValue(Set<String> subp, LexicalUnit unknownValue) {
        BaseCSSDeclarationRule prule = this.styleDeclaration.getParentRule();
        if (prule != null) {
            StyleDeclarationErrorHandler eh = prule.getStyleDeclarationErrorHandler();
            if (unknownValue.getLexicalUnitType() == LexicalUnit.LexicalType.IDENT) {
                eh.unknownIdentifier("animation", unknownValue.getStringValue());
            } else {
                eh.unassignedShorthandValues("animation", subp.toArray(new String[0]), new LexicalUnit[]{unknownValue});
            }
        }
    }

    private void resetUnsetProperties(Set<String> subp) {
        for (String pname : subp) {
            StyleValue cssVal = this.defaultPropertyValue(pname);
            if ("animation-duration".equals(pname)) {
                this.lstDuration.add(cssVal);
                continue;
            }
            if ("animation-timing-function".equals(pname)) {
                this.lstTimingFunction.add(cssVal);
                continue;
            }
            if ("animation-delay".equals(pname)) {
                this.lstDelay.add(cssVal);
                continue;
            }
            if ("animation-iteration-count".equals(pname)) {
                this.lstIterationCount.add(cssVal);
                continue;
            }
            if ("animation-direction".equals(pname)) {
                this.lstDirection.add(cssVal);
                continue;
            }
            if ("animation-fill-mode".equals(pname)) {
                this.lstFillMode.add(cssVal);
                continue;
            }
            if ("animation-play-state".equals(pname)) {
                this.lstPlayState.add(cssVal);
                continue;
            }
            if ("animation-timeline".equals(pname)) {
                this.lstTimeline.add(cssVal);
                continue;
            }
            if (!"animation-name".equals(pname)) continue;
            this.lstName.add(cssVal);
        }
    }

    @Override
    protected void nextCurrentValue() {
        this.appendValueItemString();
        this.currentValue = this.currentValue.getNextLexicalUnit();
    }
}

