/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.om;

import io.sf.carte.doc.style.css.CSSValueSyntax;
import io.sf.carte.doc.style.css.nsac.LexicalUnit;
import io.sf.carte.doc.style.css.om.BaseCSSStyleDeclaration;
import io.sf.carte.doc.style.css.om.ShorthandSetter;
import io.sf.carte.doc.style.css.parser.SyntaxParser;
import io.sf.carte.doc.style.css.property.IdentifierValue;
import io.sf.carte.doc.style.css.property.NumberValue;
import io.sf.carte.doc.style.css.property.StyleValue;
import io.sf.carte.doc.style.css.property.TypedValue;
import io.sf.carte.doc.style.css.property.ValueFactory;

class FlexShorthandSetter
extends ShorthandSetter {
    FlexShorthandSetter(BaseCSSStyleDeclaration style) {
        super(style, "flex");
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public short assignSubproperties() {
        byte kwscan = this.scanForCssWideKeywords(this.currentValue);
        if (kwscan == 1) {
            return 0;
        }
        if (kwscan == 2) {
            return 2;
        }
        this.setPropertyToDefault("flex-grow");
        this.setPropertyToDefault("flex-shrink");
        this.setPropertyToDefault("flex-basis");
        boolean flexGrowUnset = true;
        boolean flexBasisUnset = true;
        int count = 0;
        while (true) {
            block20: {
                block22: {
                    String ident;
                    block23: {
                        LexicalUnit.LexicalType lut;
                        block21: {
                            if (this.currentValue == null) {
                                this.flush();
                                return 0;
                            }
                            if (count == 2) {
                                return 2;
                            }
                            lut = this.currentValue.getLexicalUnitType();
                            if (flexGrowUnset) {
                                if (lut == LexicalUnit.LexicalType.INTEGER) {
                                    int intValue = this.currentValue.getIntegerValue();
                                    if (intValue < 0) {
                                        return 2;
                                    }
                                    this.setFlexGrow(intValue);
                                    flexGrowUnset = false;
                                    ++count;
                                    byte ret = this.checkFlexShrink();
                                    if (ret != -1) continue;
                                    return 2;
                                }
                                if (lut == LexicalUnit.LexicalType.REAL) {
                                    float floatValue = this.currentValue.getFloatValue();
                                    if (floatValue < 0.0f) {
                                        return 2;
                                    }
                                    this.setFlexGrow(floatValue);
                                    flexGrowUnset = false;
                                    ++count;
                                    byte ret = this.checkFlexShrink();
                                    if (ret != -1) continue;
                                    return 2;
                                }
                                if (this.currentValue.shallowMatch(SyntaxParser.createSimpleSyntax("number")) == CSSValueSyntax.Match.TRUE) {
                                    this.setSubpropertyValue("flex-grow", this.createCSSValue("flex-grow", this.currentValue));
                                    flexGrowUnset = false;
                                    ++count;
                                }
                            }
                            if (!flexBasisUnset || !ValueFactory.isLengthPercentageSACUnit(this.currentValue)) break block21;
                            TypedValue value = (TypedValue)this.createCSSValue("flex-basis", this.currentValue);
                            if (value.isNumberZero()) {
                                NumberValue number = new NumberValue();
                                number.setSubproperty(true);
                                number.setIntegerValue(0);
                                value = number;
                            }
                            this.setSubpropertyValue("flex-basis", value);
                            ++count;
                            flexBasisUnset = false;
                            break block20;
                        }
                        if (lut != LexicalUnit.LexicalType.IDENT) break block22;
                        ident = this.currentValue.getStringValue();
                        if (!"none".equalsIgnoreCase(ident)) break block23;
                        if (flexGrowUnset) {
                            this.setFlexGrow(0);
                            this.setFlexShrink(0);
                        }
                        this.setFlexBasisToAuto();
                        count += 2;
                        flexBasisUnset = false;
                        break block20;
                    }
                    if ("auto".equalsIgnoreCase(ident)) {
                        if (flexGrowUnset) {
                            this.setFlexGrow(1);
                            this.setFlexShrink(1);
                        }
                        this.setFlexBasisToAuto();
                        count += 2;
                        flexBasisUnset = false;
                        break block20;
                    } else if ("content".equalsIgnoreCase(ident)) {
                        this.setSubpropertyValue("flex-basis", this.createCSSValue("flex-basis", this.currentValue));
                        ++count;
                        flexBasisUnset = false;
                        break block20;
                    } else {
                        if (this.isPrefixedIdentValue()) {
                            this.setPrefixedValue(this.currentValue);
                            this.flush();
                            return 1;
                        }
                        return 2;
                    }
                }
                if (this.currentValue.getLexicalUnitType() == LexicalUnit.LexicalType.PREFIXED_FUNCTION) {
                    this.setPrefixedValue(this.currentValue);
                    this.flush();
                    return 1;
                }
                return 2;
            }
            this.nextCurrentValue();
        }
    }

    private void setFlexGrow(int grow) {
        NumberValue number = new NumberValue();
        number.setIntegerValue(grow);
        number.setSubproperty(true);
        this.setSubpropertyValue("flex-grow", number);
    }

    private void setFlexGrow(float grow) {
        NumberValue number = new NumberValue();
        number.setFloatValue((short)0, grow);
        number.setSubproperty(true);
        this.setSubpropertyValue("flex-grow", number);
    }

    private byte checkFlexShrink() {
        this.nextCurrentValue();
        if (this.currentValue != null) {
            LexicalUnit.LexicalType lut = this.currentValue.getLexicalUnitType();
            if (lut == LexicalUnit.LexicalType.INTEGER) {
                int intValue = this.currentValue.getIntegerValue();
                if (intValue >= 0) {
                    this.setFlexShrink(intValue);
                    this.nextCurrentValue();
                    return 1;
                }
                return -1;
            }
            if (lut == LexicalUnit.LexicalType.REAL) {
                float floatValue = this.currentValue.getFloatValue();
                if (floatValue >= 0.0f) {
                    this.setFlexShrink(floatValue);
                    this.nextCurrentValue();
                    return 1;
                }
                return -1;
            }
        }
        return 0;
    }

    private void setFlexShrink(int shrink) {
        NumberValue number = new NumberValue();
        number.setIntegerValue(shrink);
        number.setSubproperty(true);
        this.setSubpropertyValue("flex-shrink", number);
    }

    private void setFlexShrink(float shrink) {
        NumberValue number = new NumberValue();
        number.setFloatValue((short)0, shrink);
        number.setSubproperty(true);
        this.setSubpropertyValue("flex-shrink", number);
    }

    private void setFlexBasisToAuto() {
        IdentifierValue ident = new IdentifierValue("auto");
        ident.setSubproperty(true);
        this.setSubpropertyValue("flex-basis", ident);
    }

    @Override
    protected void appendValueItemString() {
        StyleValue cssValue;
        if (this.currentValue != null && (cssValue = this.valueFactory.createCSSValueItem(this.currentValue, true).getCSSValue()) != null) {
            String miniCssText;
            String cssText;
            NumberValue number;
            if (this.currentValue.getNextLexicalUnit() == null && cssValue instanceof NumberValue && (number = (NumberValue)cssValue).isNumberZero()) {
                miniCssText = cssText = "0" + number.getDimensionUnitText();
            } else {
                cssText = cssValue.getCssText();
                miniCssText = cssValue.getMinifiedCssText(this.getShorthandName());
            }
            StringBuilder buf = this.getValueItemBuffer();
            StringBuilder minibuf = this.getValueItemBufferMini();
            int len = buf.length();
            if (len != 0) {
                minibuf.append(' ');
                buf.append(' ');
            }
            buf.append(cssText);
            minibuf.append(miniCssText);
        }
    }
}

