/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.parser;

import io.sf.carte.doc.style.css.CSSMathFunctionValue;
import io.sf.carte.doc.style.css.CSSUnit;
import io.sf.carte.doc.style.css.CSSValueSyntax;
import io.sf.carte.doc.style.css.TransformFunctions;
import io.sf.carte.doc.style.css.nsac.LexicalUnit;
import io.sf.carte.doc.style.css.parser.AngleFunctionUnitImpl;
import io.sf.carte.doc.style.css.parser.AttrUnitImpl;
import io.sf.carte.doc.style.css.parser.BasicShapeUnitImpl;
import io.sf.carte.doc.style.css.parser.CSSParser;
import io.sf.carte.doc.style.css.parser.ColorUnitImpl;
import io.sf.carte.doc.style.css.parser.CounterUnitImpl;
import io.sf.carte.doc.style.css.parser.EasingFunctionUnitImpl;
import io.sf.carte.doc.style.css.parser.ElementReferenceUnitImpl;
import io.sf.carte.doc.style.css.parser.EnvUnitImpl;
import io.sf.carte.doc.style.css.parser.ExpressionUnitImpl;
import io.sf.carte.doc.style.css.parser.ImageFunctionUnitImpl;
import io.sf.carte.doc.style.css.parser.LexicalUnitImpl;
import io.sf.carte.doc.style.css.parser.MultiArgScalingFunctionUnitImpl;
import io.sf.carte.doc.style.css.parser.PowFunctionUnitImpl;
import io.sf.carte.doc.style.css.parser.RGBColorUnitImpl;
import io.sf.carte.doc.style.css.parser.RoundFunctionUnitImpl;
import io.sf.carte.doc.style.css.parser.ScalingFunctionUnitImpl;
import io.sf.carte.doc.style.css.parser.SqrtFunctionUnitImpl;
import io.sf.carte.doc.style.css.parser.SyntaxParser;
import io.sf.carte.doc.style.css.parser.TransformFunctionUnitImpl;
import io.sf.carte.doc.style.css.parser.UnitlessFunctionUnitImpl;
import io.sf.carte.doc.style.css.parser.VarFunctionUnitImpl;
import java.util.HashMap;
import java.util.Map;

abstract class FunctionFactories {
    private final Map<String, CSSParser.LexicalUnitFactory> factories = this.createFactoryMap();

    FunctionFactories() {
    }

    private Map<String, CSSParser.LexicalUnitFactory> createFactoryMap() {
        HashMap<String, CSSParser.LexicalUnitFactory> factories = new HashMap<String, CSSParser.LexicalUnitFactory>(86);
        factories.put("calc", new CSSParser.LexicalUnitFactory(){

            @Override
            public LexicalUnitImpl createUnit() {
                return new ExpressionUnitImpl(LexicalUnit.LexicalType.CALC);
            }
        });
        factories.put("attr", new CSSParser.LexicalUnitFactory(){

            @Override
            public LexicalUnitImpl createUnit() {
                return new AttrUnitImpl();
            }
        });
        factories.put("type", new CSSParser.LexicalUnitFactory(){

            @Override
            public LexicalUnitImpl createUnit() {
                return new LexicalUnitImpl(LexicalUnit.LexicalType.TYPE_FUNCTION);
            }
        });
        factories.put("var", new CSSParser.LexicalUnitFactory(){

            @Override
            public LexicalUnitImpl createUnit() {
                return new VarFunctionUnitImpl();
            }

            @Override
            public boolean validate(int index, LexicalUnitImpl currentlu) {
                String s = currentlu.parameters.getStringValue();
                if (s == null) {
                    return false;
                }
                int len = s.length();
                if (len < 3 || s.charAt(0) != '-' || s.charAt(1) != '-') {
                    FunctionFactories.this.error(index - len, "var() function must reference a custom property.");
                    return false;
                }
                LexicalUnit.LexicalType lastType = CSSParser.findLastValue(currentlu.parameters).getLexicalUnitType();
                if (lastType == LexicalUnit.LexicalType.OPERATOR_COMMA) {
                    FunctionFactories.this.addEmptyLexicalUnit();
                }
                return true;
            }
        });
        factories.put("env", new CSSParser.LexicalUnitFactory(){

            @Override
            public LexicalUnitImpl createUnit() {
                return new EnvUnitImpl();
            }
        });
        factories.put("url", new CSSParser.LexicalUnitFactory(){

            @Override
            public LexicalUnitImpl createUnit() {
                return new LexicalUnitImpl(LexicalUnit.LexicalType.URI);
            }
        });
        factories.put("matrix", new CSSParser.LexicalUnitFactory(){

            @Override
            public LexicalUnitImpl createUnit() {
                return new TransformFunctionUnitImpl(TransformFunctions.MATRIX);
            }
        });
        factories.put("perspective", new CSSParser.LexicalUnitFactory(){

            @Override
            public LexicalUnitImpl createUnit() {
                return new TransformFunctionUnitImpl(TransformFunctions.PERSPECTIVE);
            }
        });
        factories.put("translate", new CSSParser.LexicalUnitFactory(){

            @Override
            public LexicalUnitImpl createUnit() {
                return new TransformFunctionUnitImpl(TransformFunctions.TRANSLATE);
            }
        });
        factories.put("translate3d", new CSSParser.LexicalUnitFactory(){

            @Override
            public LexicalUnitImpl createUnit() {
                return new TransformFunctionUnitImpl(TransformFunctions.TRANSLATE_3D);
            }
        });
        CSSParser.LexicalUnitFactory translatex = new CSSParser.LexicalUnitFactory(){

            @Override
            public LexicalUnitImpl createUnit() {
                return new TransformFunctionUnitImpl(TransformFunctions.TRANSLATE_X);
            }

            @Override
            public String canonicalName(String lcName) {
                return "translateX";
            }
        };
        factories.put("translatex", translatex);
        factories.put("translateX", translatex);
        CSSParser.LexicalUnitFactory translatey = new CSSParser.LexicalUnitFactory(){

            @Override
            public LexicalUnitImpl createUnit() {
                return new TransformFunctionUnitImpl(TransformFunctions.TRANSLATE_Y);
            }

            @Override
            public String canonicalName(String lcName) {
                return "translateY";
            }
        };
        factories.put("translatey", translatey);
        factories.put("translateY", translatey);
        CSSParser.LexicalUnitFactory translatez = new CSSParser.LexicalUnitFactory(){

            @Override
            public LexicalUnitImpl createUnit() {
                return new TransformFunctionUnitImpl(TransformFunctions.TRANSLATE_Z);
            }

            @Override
            public String canonicalName(String lcName) {
                return "translateZ";
            }
        };
        factories.put("translatez", translatez);
        factories.put("translateZ", translatez);
        factories.put("scale", new CSSParser.LexicalUnitFactory(){

            @Override
            public LexicalUnitImpl createUnit() {
                return new TransformFunctionUnitImpl(TransformFunctions.SCALE);
            }
        });
        factories.put("scale3d", new CSSParser.LexicalUnitFactory(){

            @Override
            public LexicalUnitImpl createUnit() {
                return new TransformFunctionUnitImpl(TransformFunctions.SCALE_3D);
            }
        });
        CSSParser.LexicalUnitFactory scalex = new CSSParser.LexicalUnitFactory(){

            @Override
            public LexicalUnitImpl createUnit() {
                return new TransformFunctionUnitImpl(TransformFunctions.SCALE_X);
            }

            @Override
            public String canonicalName(String lcName) {
                return "scaleX";
            }
        };
        factories.put("scalex", scalex);
        factories.put("scaleX", scalex);
        CSSParser.LexicalUnitFactory scaley = new CSSParser.LexicalUnitFactory(){

            @Override
            public LexicalUnitImpl createUnit() {
                return new TransformFunctionUnitImpl(TransformFunctions.SCALE_Y);
            }

            @Override
            public String canonicalName(String lcName) {
                return "scaleY";
            }
        };
        factories.put("scaley", scaley);
        factories.put("scaleY", scaley);
        CSSParser.LexicalUnitFactory scalez = new CSSParser.LexicalUnitFactory(){

            @Override
            public LexicalUnitImpl createUnit() {
                return new TransformFunctionUnitImpl(TransformFunctions.SCALE_Z);
            }

            @Override
            public String canonicalName(String lcName) {
                return "scaleZ";
            }
        };
        factories.put("scalez", scalez);
        factories.put("scaleZ", scalez);
        factories.put("rotate", new CSSParser.LexicalUnitFactory(){

            @Override
            public LexicalUnitImpl createUnit() {
                return new TransformFunctionUnitImpl(TransformFunctions.ROTATE);
            }
        });
        factories.put("rotate3d", new CSSParser.LexicalUnitFactory(){

            @Override
            public LexicalUnitImpl createUnit() {
                return new TransformFunctionUnitImpl(TransformFunctions.ROTATE_3D);
            }
        });
        CSSParser.LexicalUnitFactory rotatex = new CSSParser.LexicalUnitFactory(){

            @Override
            public LexicalUnitImpl createUnit() {
                return new TransformFunctionUnitImpl(TransformFunctions.ROTATE_X);
            }

            @Override
            public String canonicalName(String lcName) {
                return "rotateX";
            }
        };
        factories.put("rotatex", rotatex);
        factories.put("rotateX", rotatex);
        CSSParser.LexicalUnitFactory rotatey = new CSSParser.LexicalUnitFactory(){

            @Override
            public LexicalUnitImpl createUnit() {
                return new TransformFunctionUnitImpl(TransformFunctions.ROTATE_Y);
            }

            @Override
            public String canonicalName(String lcName) {
                return "rotateY";
            }
        };
        factories.put("rotatey", rotatey);
        factories.put("rotateY", rotatey);
        CSSParser.LexicalUnitFactory rotatez = new CSSParser.LexicalUnitFactory(){

            @Override
            public LexicalUnitImpl createUnit() {
                return new TransformFunctionUnitImpl(TransformFunctions.ROTATE_Z);
            }

            @Override
            public String canonicalName(String lcName) {
                return "rotateZ";
            }
        };
        factories.put("rotatez", rotatez);
        factories.put("rotateZ", rotatez);
        factories.put("skew", new CSSParser.LexicalUnitFactory(){

            @Override
            public LexicalUnitImpl createUnit() {
                return new TransformFunctionUnitImpl(TransformFunctions.SKEW);
            }
        });
        CSSParser.LexicalUnitFactory skewx = new CSSParser.LexicalUnitFactory(){

            @Override
            public LexicalUnitImpl createUnit() {
                return new TransformFunctionUnitImpl(TransformFunctions.SKEW_X);
            }

            @Override
            public String canonicalName(String lcName) {
                return "skewX";
            }
        };
        factories.put("skewx", skewx);
        factories.put("skewX", skewx);
        CSSParser.LexicalUnitFactory skewy = new CSSParser.LexicalUnitFactory(){

            @Override
            public LexicalUnitImpl createUnit() {
                return new TransformFunctionUnitImpl(TransformFunctions.SKEW_Y);
            }

            @Override
            public String canonicalName(String lcName) {
                return "skewY";
            }
        };
        factories.put("skewy", skewy);
        factories.put("skewY", skewy);
        factories.put("src", new CSSParser.LexicalUnitFactory(){

            @Override
            public LexicalUnitImpl createUnit() {
                return new LexicalUnitImpl(LexicalUnit.LexicalType.SRC);
            }
        });
        factories.put("image-set", new CSSParser.LexicalUnitFactory(){

            @Override
            public LexicalUnitImpl createUnit() {
                return new ImageFunctionUnitImpl(LexicalUnit.LexicalType.IMAGE_SET);
            }
        });
        factories.put("element", new CSSParser.LexicalUnitFactory(){

            @Override
            public LexicalUnitImpl createUnit() {
                return new ElementReferenceUnitImpl();
            }
        });
        factories.put("circle", new CSSParser.LexicalUnitFactory(){

            @Override
            public LexicalUnitImpl createUnit() {
                return new BasicShapeUnitImpl(LexicalUnit.LexicalType.CIRCLE_FUNCTION);
            }
        });
        factories.put("ellipse", new CSSParser.LexicalUnitFactory(){

            @Override
            public LexicalUnitImpl createUnit() {
                return new BasicShapeUnitImpl(LexicalUnit.LexicalType.ELLIPSE_FUNCTION);
            }
        });
        factories.put("inset", new CSSParser.LexicalUnitFactory(){

            @Override
            public LexicalUnitImpl createUnit() {
                return new BasicShapeUnitImpl(LexicalUnit.LexicalType.INSET_FUNCTION);
            }
        });
        factories.put("path", new CSSParser.LexicalUnitFactory(){

            @Override
            public LexicalUnitImpl createUnit() {
                return new BasicShapeUnitImpl(LexicalUnit.LexicalType.PATH_FUNCTION);
            }
        });
        factories.put("polygon", new CSSParser.LexicalUnitFactory(){

            @Override
            public LexicalUnitImpl createUnit() {
                return new BasicShapeUnitImpl(LexicalUnit.LexicalType.POLYGON_FUNCTION);
            }
        });
        factories.put("rect", new CSSParser.LexicalUnitFactory(){

            @Override
            public LexicalUnitImpl createUnit() {
                return new BasicShapeUnitImpl(LexicalUnit.LexicalType.RECT_FUNCTION);
            }
        });
        factories.put("shape", new CSSParser.LexicalUnitFactory(){

            @Override
            public LexicalUnitImpl createUnit() {
                return new BasicShapeUnitImpl(LexicalUnit.LexicalType.SHAPE_FUNCTION);
            }
        });
        factories.put("xywh", new CSSParser.LexicalUnitFactory(){

            @Override
            public LexicalUnitImpl createUnit() {
                return new BasicShapeUnitImpl(LexicalUnit.LexicalType.XYWH_FUNCTION);
            }
        });
        factories.put("counter", new CSSParser.LexicalUnitFactory(){

            @Override
            public LexicalUnitImpl createUnit() {
                return new CounterUnitImpl(LexicalUnit.LexicalType.COUNTER_FUNCTION);
            }
        });
        factories.put("counters", new CSSParser.LexicalUnitFactory(){

            @Override
            public LexicalUnitImpl createUnit() {
                return new CounterUnitImpl(LexicalUnit.LexicalType.COUNTERS_FUNCTION);
            }
        });
        factories.put("cubic-bezier", new CSSParser.LexicalUnitFactory(){

            @Override
            public LexicalUnitImpl createUnit() {
                return new EasingFunctionUnitImpl(LexicalUnit.LexicalType.CUBIC_BEZIER_FUNCTION);
            }
        });
        factories.put("linear", new CSSParser.LexicalUnitFactory(){

            @Override
            public LexicalUnitImpl createUnit() {
                return new EasingFunctionUnitImpl(LexicalUnit.LexicalType.LINEAR_FUNCTION);
            }
        });
        factories.put("steps", new CSSParser.LexicalUnitFactory(){

            @Override
            public LexicalUnitImpl createUnit() {
                return new EasingFunctionUnitImpl(LexicalUnit.LexicalType.STEPS_FUNCTION);
            }
        });
        CSSParser.LexicalUnitFactory rgb = new CSSParser.LexicalUnitFactory(){

            @Override
            public LexicalUnitImpl createUnit() {
                return new RGBColorUnitImpl();
            }

            @Override
            public boolean validate(int index, LexicalUnitImpl lu) {
                return FunctionFactories.this.isValidRGBColor(index, lu);
            }
        };
        factories.put("rgb", rgb);
        factories.put("rgba", rgb);
        CSSParser.LexicalUnitFactory hsl = new CSSParser.LexicalUnitFactory(){

            @Override
            public LexicalUnitImpl createUnit() {
                return new ColorUnitImpl(LexicalUnit.LexicalType.HSLCOLOR);
            }

            @Override
            public boolean validate(int index, LexicalUnitImpl lu) {
                return FunctionFactories.this.isValidHSLColor(index, lu);
            }
        };
        factories.put("hsl", hsl);
        factories.put("hsla", hsl);
        factories.put("lab", new CSSParser.LexicalUnitFactory(){

            @Override
            public LexicalUnitImpl createUnit() {
                return new ColorUnitImpl(LexicalUnit.LexicalType.LABCOLOR);
            }

            @Override
            public boolean validate(int index, LexicalUnitImpl currentlu) {
                return FunctionFactories.this.isValidLABColor(index, currentlu, 100, 100.0f);
            }
        });
        factories.put("lch", new CSSParser.LexicalUnitFactory(){

            @Override
            public LexicalUnitImpl createUnit() {
                return new ColorUnitImpl(LexicalUnit.LexicalType.LCHCOLOR);
            }

            @Override
            public boolean validate(int index, LexicalUnitImpl currentlu) {
                return FunctionFactories.this.isValidLCHColor(index, currentlu, 100, 100.0f);
            }
        });
        factories.put("oklab", new CSSParser.LexicalUnitFactory(){

            @Override
            public LexicalUnitImpl createUnit() {
                return new ColorUnitImpl(LexicalUnit.LexicalType.OKLABCOLOR);
            }

            @Override
            public boolean validate(int index, LexicalUnitImpl currentlu) {
                return FunctionFactories.this.isValidLABColor(index, currentlu, 1, 1.0f);
            }
        });
        factories.put("oklch", new CSSParser.LexicalUnitFactory(){

            @Override
            public LexicalUnitImpl createUnit() {
                return new ColorUnitImpl(LexicalUnit.LexicalType.OKLCHCOLOR);
            }

            @Override
            public boolean validate(int index, LexicalUnitImpl currentlu) {
                return FunctionFactories.this.isValidLCHColor(index, currentlu, 1, 1.0f);
            }
        });
        factories.put("hwb", new CSSParser.LexicalUnitFactory(){

            @Override
            public LexicalUnitImpl createUnit() {
                return new ColorUnitImpl(LexicalUnit.LexicalType.HWBCOLOR);
            }

            @Override
            public boolean validate(int index, LexicalUnitImpl currentlu) {
                return FunctionFactories.this.isValidHWBColor(index, currentlu);
            }
        });
        factories.put("color", new CSSParser.LexicalUnitFactory(){

            @Override
            public LexicalUnitImpl createUnit() {
                return new ColorUnitImpl(LexicalUnit.LexicalType.COLOR_FUNCTION);
            }

            @Override
            public boolean validate(int index, LexicalUnitImpl currentlu) {
                return FunctionFactories.this.isValidColorFunction(index, currentlu);
            }
        });
        factories.put("color-mix", new CSSParser.LexicalUnitFactory(){

            @Override
            public LexicalUnitImpl createUnit() {
                return new ColorUnitImpl(LexicalUnit.LexicalType.COLOR_MIX);
            }

            @Override
            public boolean validate(int index, LexicalUnitImpl currentlu) {
                return FunctionFactories.this.isValidColorMixFunction(index, currentlu);
            }
        });
        factories.put("abs", new CSSParser.LexicalUnitFactory(){

            @Override
            public LexicalUnitImpl createUnit() {
                return new ScalingFunctionUnitImpl(CSSMathFunctionValue.MathFunction.ABS);
            }
        });
        factories.put("clamp", new CSSParser.LexicalUnitFactory(){

            @Override
            public LexicalUnitImpl createUnit() {
                return new MultiArgScalingFunctionUnitImpl(CSSMathFunctionValue.MathFunction.CLAMP);
            }
        });
        factories.put("max", new CSSParser.LexicalUnitFactory(){

            @Override
            public LexicalUnitImpl createUnit() {
                return new MultiArgScalingFunctionUnitImpl(CSSMathFunctionValue.MathFunction.MAX);
            }
        });
        factories.put("min", new CSSParser.LexicalUnitFactory(){

            @Override
            public LexicalUnitImpl createUnit() {
                return new MultiArgScalingFunctionUnitImpl(CSSMathFunctionValue.MathFunction.MIN);
            }
        });
        factories.put("round", new CSSParser.LexicalUnitFactory(){

            @Override
            public LexicalUnitImpl createUnit() {
                return new RoundFunctionUnitImpl(CSSMathFunctionValue.MathFunction.ROUND);
            }
        });
        factories.put("mod", new CSSParser.LexicalUnitFactory(){

            @Override
            public LexicalUnitImpl createUnit() {
                return new MultiArgScalingFunctionUnitImpl(CSSMathFunctionValue.MathFunction.MOD);
            }
        });
        factories.put("rem", new CSSParser.LexicalUnitFactory(){

            @Override
            public LexicalUnitImpl createUnit() {
                return new MultiArgScalingFunctionUnitImpl(CSSMathFunctionValue.MathFunction.REM);
            }
        });
        factories.put("hypot", new CSSParser.LexicalUnitFactory(){

            @Override
            public LexicalUnitImpl createUnit() {
                return new MultiArgScalingFunctionUnitImpl(CSSMathFunctionValue.MathFunction.HYPOT);
            }
        });
        factories.put("hypot2", new CSSParser.LexicalUnitFactory(){

            @Override
            public LexicalUnitImpl createUnit() {
                return new MultiArgScalingFunctionUnitImpl(CSSMathFunctionValue.MathFunction.HYPOT2);
            }
        });
        factories.put("log", new CSSParser.LexicalUnitFactory(){

            @Override
            public LexicalUnitImpl createUnit() {
                return new UnitlessFunctionUnitImpl(CSSMathFunctionValue.MathFunction.LOG);
            }
        });
        factories.put("exp", new CSSParser.LexicalUnitFactory(){

            @Override
            public LexicalUnitImpl createUnit() {
                return new UnitlessFunctionUnitImpl(CSSMathFunctionValue.MathFunction.EXP);
            }
        });
        factories.put("sqrt", new CSSParser.LexicalUnitFactory(){

            @Override
            public LexicalUnitImpl createUnit() {
                return new SqrtFunctionUnitImpl(CSSMathFunctionValue.MathFunction.SQRT);
            }
        });
        factories.put("pow", new CSSParser.LexicalUnitFactory(){

            @Override
            public LexicalUnitImpl createUnit() {
                return new PowFunctionUnitImpl(CSSMathFunctionValue.MathFunction.POW);
            }
        });
        factories.put("sign", new CSSParser.LexicalUnitFactory(){

            @Override
            public LexicalUnitImpl createUnit() {
                return new UnitlessFunctionUnitImpl(CSSMathFunctionValue.MathFunction.SIGN);
            }
        });
        factories.put("sin", new CSSParser.LexicalUnitFactory(){

            @Override
            public LexicalUnitImpl createUnit() {
                return new UnitlessFunctionUnitImpl(CSSMathFunctionValue.MathFunction.SIN);
            }
        });
        factories.put("cos", new CSSParser.LexicalUnitFactory(){

            @Override
            public LexicalUnitImpl createUnit() {
                return new UnitlessFunctionUnitImpl(CSSMathFunctionValue.MathFunction.COS);
            }
        });
        factories.put("tan", new CSSParser.LexicalUnitFactory(){

            @Override
            public LexicalUnitImpl createUnit() {
                return new UnitlessFunctionUnitImpl(CSSMathFunctionValue.MathFunction.TAN);
            }
        });
        factories.put("asin", new CSSParser.LexicalUnitFactory(){

            @Override
            public LexicalUnitImpl createUnit() {
                return new AngleFunctionUnitImpl(CSSMathFunctionValue.MathFunction.ASIN);
            }
        });
        factories.put("acos", new CSSParser.LexicalUnitFactory(){

            @Override
            public LexicalUnitImpl createUnit() {
                return new AngleFunctionUnitImpl(CSSMathFunctionValue.MathFunction.ACOS);
            }
        });
        factories.put("atan", new CSSParser.LexicalUnitFactory(){

            @Override
            public LexicalUnitImpl createUnit() {
                return new AngleFunctionUnitImpl(CSSMathFunctionValue.MathFunction.ATAN);
            }
        });
        factories.put("atan2", new CSSParser.LexicalUnitFactory(){

            @Override
            public LexicalUnitImpl createUnit() {
                return new AngleFunctionUnitImpl(CSSMathFunctionValue.MathFunction.ATAN2);
            }
        });
        return factories;
    }

    private boolean isValidRGBColor(int index, LexicalUnitImpl currentlu) {
        LexicalUnitImpl lu = currentlu.parameters;
        int valCount = 0;
        LexicalUnit.LexicalType lastType = LexicalUnit.LexicalType.UNKNOWN;
        boolean hasCommas = false;
        boolean hasNoCommas = false;
        boolean hasVar = false;
        do {
            LexicalUnit.LexicalType type;
            if ((type = lu.getLexicalUnitType()) == LexicalUnit.LexicalType.OPERATOR_COMMA) {
                if (lastType == LexicalUnit.LexicalType.OPERATOR_COMMA || lastType == LexicalUnit.LexicalType.UNKNOWN || hasNoCommas) {
                    return false;
                }
                hasCommas = true;
            } else if (FunctionFactories.isComponentType(type)) {
                if (type == LexicalUnit.LexicalType.VAR) {
                    hasVar = true;
                }
                if (type == LexicalUnit.LexicalType.INTEGER) {
                    int value = lu.getIntegerValue();
                    if (value < 0) {
                        lu.intValue = 0;
                        this.warn(index, "Color component has value under 0.");
                    } else if (valCount == 3 && value > 1) {
                        lu.intValue = 1;
                        this.warn(index, "Color alpha has value over 1.");
                    }
                    if (value > 255) {
                        this.warn(index, "Color component has value over 255.");
                    }
                } else if (type == LexicalUnit.LexicalType.REAL) {
                    float value = lu.getFloatValue();
                    if (value < 0.0f) {
                        lu.floatValue = 0.0f;
                        this.warn(index, "Color component has value under 0.");
                    }
                    if (valCount == 3) {
                        if (value > 1.0f) {
                            lu.floatValue = 1.0f;
                            this.warn(index, "Color alpha has value over 1.");
                        }
                    } else if (lastType != LexicalUnit.LexicalType.OPERATOR_SLASH) {
                        type = LexicalUnit.LexicalType.INTEGER;
                    }
                    if (value > 255.0f) {
                        this.warn(index, "Color component has value over 255.");
                    }
                } else if (type == LexicalUnit.LexicalType.PERCENTAGE) {
                    float value = lu.getFloatValue();
                    if (value < 0.0f) {
                        lu.floatValue = 0.0f;
                        this.warn(index, "Color component has percentage under 0%.");
                    } else if (value > 100.0f) {
                        lu.floatValue = 100.0f;
                        this.warn(index, "Color component has percentage over 100%.");
                    }
                } else if (type == LexicalUnit.LexicalType.IDENT) {
                    if (!"none".equalsIgnoreCase(lu.getStringValue())) {
                        return false;
                    }
                    type = LexicalUnit.LexicalType.PERCENTAGE;
                }
                if (hasCommas) {
                    if (lastType != LexicalUnit.LexicalType.OPERATOR_COMMA) {
                        return false;
                    }
                } else if (lastType != type) {
                    if (valCount == 3 && lastType != LexicalUnit.LexicalType.OPERATOR_SLASH) {
                        return false;
                    }
                } else {
                    hasNoCommas = true;
                }
                valCount = (short)(valCount + 1);
            } else if (type == LexicalUnit.LexicalType.OPERATOR_SLASH) {
                if (hasVar && valCount < 3) {
                    valCount = 3;
                }
                if (valCount == 4 || valCount < 3 || !FunctionFactories.isComponentType(lastType) || hasCommas || lu.nextLexicalUnit == null) {
                    return false;
                }
                hasNoCommas = true;
            } else {
                return false;
            }
            lastType = type;
        } while ((lu = lu.nextLexicalUnit) != null);
        return valCount == 3 || valCount == 4 || valCount < 3 && hasVar;
    }

    private boolean isValidHSLColor(int index, LexicalUnitImpl currentlu) {
        LexicalUnitImpl lu = currentlu.parameters;
        int slaCount = 0;
        LexicalUnit.LexicalType lastType = LexicalUnit.LexicalType.UNKNOWN;
        boolean hasCommas = false;
        boolean hasNoCommas = false;
        boolean hasVar = false;
        do {
            LexicalUnit.LexicalType type;
            if ((type = lu.getLexicalUnitType()) == LexicalUnit.LexicalType.PERCENTAGE || (type == LexicalUnit.LexicalType.MATH_FUNCTION || type == LexicalUnit.LexicalType.FUNCTION || type == LexicalUnit.LexicalType.ATTR) && FunctionFactories.isPercentageUnit(lu)) {
                if (lastType == LexicalUnit.LexicalType.UNKNOWN) {
                    return false;
                }
                if (hasCommas) {
                    if (lastType != LexicalUnit.LexicalType.OPERATOR_COMMA) {
                        return false;
                    }
                } else {
                    boolean bl = hasNoCommas = hasNoCommas || lastType == LexicalUnit.LexicalType.REAL || lastType == LexicalUnit.LexicalType.PERCENTAGE || lastType == LexicalUnit.LexicalType.INTEGER || lastType == LexicalUnit.LexicalType.EXT1;
                }
                if (type == LexicalUnit.LexicalType.PERCENTAGE) {
                    float value = lu.getFloatValue();
                    if (value < 0.0f) {
                        lu.floatValue = 0.0f;
                        this.warn(index, "Color component has value under 0%.");
                    } else if (value > 100.0f) {
                        lu.floatValue = 100.0f;
                        this.warn(index, "Color component has value over 100%.");
                    }
                } else {
                    type = LexicalUnit.LexicalType.PERCENTAGE;
                }
                slaCount = (short)(slaCount + 1);
            } else if (type == LexicalUnit.LexicalType.REAL) {
                if (lastType != LexicalUnit.LexicalType.UNKNOWN) {
                    slaCount = (short)(slaCount + 1);
                    float value = lu.getFloatValue();
                    if (value < 0.0f) {
                        lu.floatValue = 0.0f;
                        this.warn(index, "Color component has value under 0.");
                    } else if (lastType == LexicalUnit.LexicalType.OPERATOR_SLASH) {
                        if (value > 1.0f) {
                            lu.floatValue = 1.0f;
                            this.warn(index, "Color alpha has value over 1.");
                        }
                    } else if (value > 100.0f) {
                        lu.floatValue = 100.0f;
                        this.warn(index, "Color component has value over 100%.");
                    }
                    if (hasCommas) {
                        if (lastType != LexicalUnit.LexicalType.OPERATOR_COMMA) {
                            return false;
                        }
                    } else {
                        hasNoCommas = hasNoCommas || lastType == LexicalUnit.LexicalType.REAL || lastType == LexicalUnit.LexicalType.PERCENTAGE || lastType == LexicalUnit.LexicalType.INTEGER || lastType == LexicalUnit.LexicalType.EXT1;
                    }
                }
            } else if (type == LexicalUnit.LexicalType.OPERATOR_COMMA) {
                if (lastType == LexicalUnit.LexicalType.OPERATOR_COMMA || lastType == LexicalUnit.LexicalType.UNKNOWN || hasNoCommas) {
                    return false;
                }
                hasCommas = true;
            } else if (type == LexicalUnit.LexicalType.INTEGER) {
                if (lastType != LexicalUnit.LexicalType.UNKNOWN) {
                    int value = lu.getIntegerValue();
                    if (value < 0) {
                        lu.intValue = 0;
                        this.warn(index, "Color component has value under 0%.");
                    } else if (value > 100) {
                        lu.intValue = 100;
                        this.warn(index, "Color component has value over 100%.");
                    }
                    if (value > 1 && lastType == LexicalUnit.LexicalType.OPERATOR_SLASH) {
                        lu.intValue = 1;
                    }
                    slaCount = (short)(slaCount + 1);
                    type = LexicalUnit.LexicalType.PERCENTAGE;
                    if (hasCommas) {
                        if (lastType != LexicalUnit.LexicalType.OPERATOR_COMMA) {
                            return false;
                        }
                    } else {
                        hasNoCommas = hasNoCommas || lastType == LexicalUnit.LexicalType.REAL || lastType == LexicalUnit.LexicalType.PERCENTAGE || lastType == LexicalUnit.LexicalType.INTEGER || lastType == LexicalUnit.LexicalType.EXT1;
                    }
                }
            } else if (FunctionFactories.isAngleUnit(lu)) {
                if (lastType != LexicalUnit.LexicalType.UNKNOWN) {
                    return false;
                }
                type = LexicalUnit.LexicalType.EXT1;
            } else if (type == LexicalUnit.LexicalType.OPERATOR_SLASH) {
                if (slaCount != 2 && !hasVar || hasVar && slaCount > 2 || lastType != LexicalUnit.LexicalType.PERCENTAGE && lastType != LexicalUnit.LexicalType.REAL && lastType != LexicalUnit.LexicalType.VAR || hasCommas || lu.nextLexicalUnit == null) {
                    return false;
                }
            } else if (type == LexicalUnit.LexicalType.CALC || type == LexicalUnit.LexicalType.MATH_FUNCTION || type == LexicalUnit.LexicalType.FUNCTION || type == LexicalUnit.LexicalType.ATTR) {
                if (lastType == LexicalUnit.LexicalType.UNKNOWN) {
                    type = LexicalUnit.LexicalType.INTEGER;
                } else if (lastType == LexicalUnit.LexicalType.OPERATOR_SLASH) {
                    type = LexicalUnit.LexicalType.REAL;
                    slaCount = (short)(slaCount + 1);
                } else {
                    if (hasCommas) {
                        if (lastType != LexicalUnit.LexicalType.OPERATOR_COMMA) {
                            return false;
                        }
                    } else {
                        hasNoCommas = hasNoCommas || lastType == LexicalUnit.LexicalType.REAL || lastType == LexicalUnit.LexicalType.PERCENTAGE || lastType == LexicalUnit.LexicalType.INTEGER || lastType == LexicalUnit.LexicalType.EXT1;
                    }
                    slaCount = (short)(slaCount + 1);
                    type = LexicalUnit.LexicalType.PERCENTAGE;
                }
            } else if (type == LexicalUnit.LexicalType.VAR) {
                hasVar = true;
            } else if (type == LexicalUnit.LexicalType.IDENT) {
                if (!"none".equalsIgnoreCase(lu.getStringValue())) {
                    return false;
                }
                slaCount = (short)(slaCount + 1);
                type = LexicalUnit.LexicalType.PERCENTAGE;
            } else {
                return false;
            }
            lastType = type;
        } while ((lu = lu.nextLexicalUnit) != null);
        return slaCount == 2 || slaCount == 3 || hasVar && slaCount < 2;
    }

    private boolean isValidHWBColor(int index, LexicalUnitImpl currentlu) {
        LexicalUnitImpl lu = currentlu.parameters;
        int pcntCount = 0;
        LexicalUnit.LexicalType lastType = LexicalUnit.LexicalType.UNKNOWN;
        boolean hasVar = false;
        do {
            float value;
            LexicalUnit.LexicalType type;
            if ((type = lu.getLexicalUnitType()) == LexicalUnit.LexicalType.PERCENTAGE) {
                if (lastType == LexicalUnit.LexicalType.UNKNOWN) {
                    return false;
                }
                pcntCount = (short)(pcntCount + 1);
                value = lu.getFloatValue();
                if (value < 0.0f) {
                    lu.floatValue = 0.0f;
                    this.warn(index, "Color component has value under 0%.");
                } else if (value > 100.0f) {
                    lu.floatValue = 100.0f;
                    this.warn(index, "Color component has value over 100%.");
                }
            } else if (type == LexicalUnit.LexicalType.INTEGER) {
                if (lastType != LexicalUnit.LexicalType.UNKNOWN) {
                    if (lastType != LexicalUnit.LexicalType.OPERATOR_SLASH || pcntCount < 2 && !hasVar) {
                        return false;
                    }
                    int value2 = lu.getIntegerValue();
                    if (value2 < 0) {
                        lu.intValue = 0;
                        this.warn(index, "Color alpha has value under 0.");
                    } else if (value2 > 1) {
                        lu.intValue = 1;
                        this.warn(index, "Color alpha has value over 1.");
                    }
                }
            } else if (FunctionFactories.isAngleUnit(lu)) {
                if (lastType != LexicalUnit.LexicalType.UNKNOWN) {
                    return false;
                }
                type = LexicalUnit.LexicalType.EXT1;
            } else if (type == LexicalUnit.LexicalType.OPERATOR_SLASH) {
                if (pcntCount != 2 && !hasVar || hasVar && pcntCount > 2 || lastType != LexicalUnit.LexicalType.PERCENTAGE && lastType != LexicalUnit.LexicalType.VAR || lu.nextLexicalUnit == null) {
                    return false;
                }
            } else if (type == LexicalUnit.LexicalType.REAL) {
                if (lastType != LexicalUnit.LexicalType.UNKNOWN) {
                    if (lastType != LexicalUnit.LexicalType.OPERATOR_SLASH || pcntCount != 2 && !hasVar || hasVar && pcntCount > 2) {
                        return false;
                    }
                    pcntCount = 3;
                    value = lu.getFloatValue();
                    if (value < 0.0f) {
                        lu.floatValue = 0.0f;
                        this.warn(index, "Color alpha has value under 0.");
                    } else if (value > 1.0f) {
                        lu.floatValue = 1.0f;
                        this.warn(index, "Color alpha has value over 1.");
                    }
                }
            } else if (type == LexicalUnit.LexicalType.CALC || type == LexicalUnit.LexicalType.MATH_FUNCTION || type == LexicalUnit.LexicalType.FUNCTION || type == LexicalUnit.LexicalType.ATTR) {
                if (lastType == LexicalUnit.LexicalType.UNKNOWN) {
                    type = LexicalUnit.LexicalType.INTEGER;
                } else if (lastType == LexicalUnit.LexicalType.OPERATOR_SLASH) {
                    type = LexicalUnit.LexicalType.REAL;
                    pcntCount = 3;
                } else {
                    pcntCount = (short)(pcntCount + 1);
                    type = LexicalUnit.LexicalType.PERCENTAGE;
                }
            } else if (type == LexicalUnit.LexicalType.VAR) {
                hasVar = true;
            } else if (type == LexicalUnit.LexicalType.IDENT) {
                if (!"none".equalsIgnoreCase(lu.getStringValue())) {
                    return false;
                }
                pcntCount = (short)(pcntCount + 1);
                type = LexicalUnit.LexicalType.PERCENTAGE;
            } else {
                return false;
            }
            lastType = type;
        } while ((lu = lu.nextLexicalUnit) != null);
        return pcntCount >= 2 || hasVar && pcntCount <= 1;
    }

    private boolean isValidLABColor(int index, LexicalUnitImpl currentlu, int iUpperLightness, float fUpperLightness) {
        LexicalUnitImpl lu = currentlu.parameters;
        boolean hasVar = false;
        if (lu == null) {
            return false;
        }
        LexicalUnit.LexicalType type = lu.getLexicalUnitType();
        if (type == LexicalUnit.LexicalType.PERCENTAGE) {
            float fL = lu.getFloatValue();
            if (fL < 0.0f) {
                lu.floatValue = 0.0f;
                this.warn(index, "Color lightness has percentage under 0%.");
            } else if (fL > 100.0f) {
                lu.floatValue = 100.0f;
                this.warn(index, "Color lightness has percentage over 100%.");
            }
        } else if (type == LexicalUnit.LexicalType.REAL) {
            float fL = lu.getFloatValue();
            if (fL < 0.0f) {
                lu.floatValue = 0.0f;
                this.warn(index, "Color lightness has value under 0.");
            } else if (fL > fUpperLightness) {
                lu.floatValue = fUpperLightness;
                this.warn(index, "Color lightness has value over " + fUpperLightness);
            }
        } else if (type == LexicalUnit.LexicalType.INTEGER) {
            int iL = lu.getIntegerValue();
            if (iL < 0) {
                lu.intValue = 0;
                this.warn(index, "Color lightness has value under 0.");
            } else if (iL > iUpperLightness) {
                lu.intValue = iUpperLightness;
                this.warn(index, "Color lightness has value over " + iUpperLightness);
            }
        } else if (type == LexicalUnit.LexicalType.VAR) {
            hasVar = true;
        } else if (!(type == LexicalUnit.LexicalType.CALC || type == LexicalUnit.LexicalType.MATH_FUNCTION || type == LexicalUnit.LexicalType.FUNCTION || type == LexicalUnit.LexicalType.ATTR || type == LexicalUnit.LexicalType.IDENT && "none".equalsIgnoreCase(lu.getStringValue()))) {
            return false;
        }
        lu = lu.nextLexicalUnit;
        if (lu == null) {
            return hasVar;
        }
        int numericValueCount = 1;
        block7: do {
            type = lu.getLexicalUnitType();
            switch (type) {
                case IDENT: {
                    if (!"none".equalsIgnoreCase(lu.getStringValue())) {
                        return false;
                    }
                }
                case REAL: 
                case INTEGER: 
                case CALC: 
                case MATH_FUNCTION: 
                case FUNCTION: 
                case ATTR: {
                    if (++numericValueCount <= 3) continue block7;
                    if (!hasVar || numericValueCount > 4) {
                        return false;
                    }
                    return this.isValidAlpha(index, lu);
                }
                case OPERATOR_SLASH: {
                    lu = lu.nextLexicalUnit;
                    if (lu == null || numericValueCount > 3 || numericValueCount < 3 && !hasVar) {
                        return false;
                    }
                    return this.isValidAlpha(index, lu);
                }
                case PERCENTAGE: {
                    if (++numericValueCount > 3) {
                        if (!hasVar || numericValueCount > 4) {
                            return false;
                        }
                        return this.isValidAlpha(index, lu);
                    }
                    if (hasVar) continue block7;
                    float fval = lu.getFloatValue();
                    if (fval < -100.0f) {
                        lu.floatValue = -100.0f;
                        this.warn(index, "Color component has percentage under -100%.");
                        break;
                    }
                    if (!(fval > 100.0f)) continue block7;
                    lu.floatValue = 100.0f;
                    this.warn(index, "Color component has percentage over 100%.");
                    break;
                }
                case VAR: {
                    hasVar = true;
                    break;
                }
                default: {
                    return false;
                }
            }
        } while ((lu = lu.nextLexicalUnit) != null);
        return numericValueCount == 3 || numericValueCount == 4 || hasVar && numericValueCount < 3;
    }

    private boolean isValidLCHColor(int index, LexicalUnitImpl currentlu, int iUpperLightness, float fUpperLightness) {
        LexicalUnitImpl lu = currentlu.parameters;
        boolean hasVar = false;
        if (lu == null) {
            return false;
        }
        LexicalUnit.LexicalType type = lu.getLexicalUnitType();
        if (type == LexicalUnit.LexicalType.PERCENTAGE) {
            float fL = lu.getFloatValue();
            if (fL < 0.0f) {
                lu.floatValue = 0.0f;
                this.warn(index, "Color lightness has percentage under 0%.");
            } else if (fL > 100.0f) {
                lu.floatValue = 100.0f;
                this.warn(index, "Color lightness has percentage over 100%.");
            }
        } else if (type == LexicalUnit.LexicalType.REAL) {
            float fL = lu.getFloatValue();
            if (fL < 0.0f) {
                lu.floatValue = 0.0f;
                this.warn(index, "Color lightness has value under 0.");
            } else if (fL > fUpperLightness) {
                lu.floatValue = fUpperLightness;
                this.warn(index, "Color lightness has value over " + fUpperLightness);
            }
        } else if (type == LexicalUnit.LexicalType.INTEGER) {
            int iL = lu.getIntegerValue();
            if (iL < 0) {
                lu.intValue = 0;
                this.warn(index, "Color lightness has value under 0.");
            } else if (iL > iUpperLightness) {
                lu.intValue = iUpperLightness;
                this.warn(index, "Color lightness has value over " + iUpperLightness);
            }
        } else if (type == LexicalUnit.LexicalType.VAR) {
            hasVar = true;
        } else if (!(type == LexicalUnit.LexicalType.CALC || type == LexicalUnit.LexicalType.MATH_FUNCTION || type == LexicalUnit.LexicalType.FUNCTION || type == LexicalUnit.LexicalType.ATTR || type == LexicalUnit.LexicalType.IDENT && "none".equalsIgnoreCase(lu.getStringValue()))) {
            return false;
        }
        lu = lu.nextLexicalUnit;
        if (lu == null) {
            return hasVar;
        }
        type = lu.getLexicalUnitType();
        if (type == LexicalUnit.LexicalType.PERCENTAGE) {
            float fC = lu.getFloatValue();
            if (fC < 0.0f) {
                lu.floatValue = 0.0f;
                this.warn(index, "Color chroma has percentage under 0.");
            } else if (fC > 100.0f) {
                lu.floatValue = 100.0f;
                this.warn(index, "Color chroma has percentage over 100.");
            }
        } else if (type == LexicalUnit.LexicalType.REAL) {
            float fC;
            if (!hasVar && (fC = lu.getFloatValue()) < 0.0f) {
                lu.floatValue = 0.0f;
                this.warn(index, "Color component has value under 0.");
            }
        } else if (type == LexicalUnit.LexicalType.INTEGER) {
            int iC;
            if (!hasVar && (iC = lu.getIntegerValue()) < 0) {
                lu.intValue = 0;
                this.warn(index, "Color component has value under 0.");
            }
        } else if (!(type == LexicalUnit.LexicalType.CALC || type == LexicalUnit.LexicalType.MATH_FUNCTION || type == LexicalUnit.LexicalType.FUNCTION || type == LexicalUnit.LexicalType.ATTR || type == LexicalUnit.LexicalType.IDENT && "none".equalsIgnoreCase(lu.getStringValue()))) {
            if (type == LexicalUnit.LexicalType.VAR) {
                hasVar = true;
            } else if (hasVar) {
                if (!CSSUnit.isAngleUnitType(lu.getCssUnit())) {
                    if (type == LexicalUnit.LexicalType.OPERATOR_SLASH && (lu = lu.nextLexicalUnit) == null) {
                        return false;
                    }
                    return this.isValidAlpha(index, lu);
                }
            } else {
                return false;
            }
        }
        lu = lu.nextLexicalUnit;
        if (lu == null) {
            return hasVar;
        }
        type = lu.getLexicalUnitType();
        if (!(type == LexicalUnit.LexicalType.REAL || type == LexicalUnit.LexicalType.INTEGER || FunctionFactories.isAngleUnit(lu) || type == LexicalUnit.LexicalType.CALC || type == LexicalUnit.LexicalType.MATH_FUNCTION || type == LexicalUnit.LexicalType.FUNCTION || type == LexicalUnit.LexicalType.ATTR || type == LexicalUnit.LexicalType.IDENT && "none".equalsIgnoreCase(lu.getStringValue()))) {
            if (type == LexicalUnit.LexicalType.VAR) {
                hasVar = true;
            } else {
                if (hasVar) {
                    if (type == LexicalUnit.LexicalType.OPERATOR_SLASH && (lu = lu.nextLexicalUnit) == null) {
                        return false;
                    }
                    return this.isValidAlpha(index, lu);
                }
                return false;
            }
        }
        if ((lu = lu.nextLexicalUnit) != null) {
            type = lu.getLexicalUnitType();
            if (type == LexicalUnit.LexicalType.OPERATOR_SLASH) {
                lu = lu.nextLexicalUnit;
                if (lu == null) {
                    return false;
                }
            } else {
                if (type == LexicalUnit.LexicalType.VAR) {
                    lu = lu.nextLexicalUnit;
                    while (lu != null) {
                        if (lu.getLexicalUnitType() != LexicalUnit.LexicalType.VAR) {
                            return this.isValidAlpha(index, lu);
                        }
                        lu = lu.nextLexicalUnit;
                    }
                    return true;
                }
                if (!hasVar) {
                    return false;
                }
            }
            return this.isValidAlpha(index, lu);
        }
        return true;
    }

    private boolean isValidColorFunction(int index, LexicalUnitImpl currentlu) {
        LexicalUnitImpl lu = currentlu.parameters;
        if (lu == null) {
            return false;
        }
        boolean hasVar = false;
        LexicalUnit.LexicalType type = lu.getLexicalUnitType();
        if (type != LexicalUnit.LexicalType.IDENT) {
            if (type == LexicalUnit.LexicalType.VAR) {
                hasVar = true;
            } else {
                return false;
            }
        }
        if ((lu = lu.nextLexicalUnit) == null) {
            return hasVar;
        }
        boolean foundNumericValue = false;
        do {
            type = lu.getLexicalUnitType();
            switch (type) {
                case IDENT: {
                    if (!"none".equalsIgnoreCase(lu.getStringValue())) {
                        return false;
                    }
                }
                case REAL: 
                case INTEGER: 
                case CALC: 
                case PERCENTAGE: 
                case VAR: {
                    foundNumericValue = true;
                    break;
                }
                case OPERATOR_SLASH: {
                    if (!foundNumericValue && !hasVar) {
                        return false;
                    }
                    lu = lu.nextLexicalUnit;
                    if (lu == null) {
                        return false;
                    }
                    return this.isValidAlpha(index, lu);
                }
                case MATH_FUNCTION: 
                case FUNCTION: 
                case ATTR: {
                    CSSValueSyntax syn = new SyntaxParser().parseSyntax("<number> | <percentage>");
                    foundNumericValue = lu.shallowMatch(syn) != CSSValueSyntax.Match.FALSE;
                    break;
                }
                default: {
                    return false;
                }
            }
        } while ((lu = lu.nextLexicalUnit) != null);
        return true;
    }

    private boolean isValidColorMixFunction(int index, LexicalUnitImpl currentlu) {
        boolean lastTypeIsComma;
        LexicalUnit lu = currentlu.parameters;
        if (lu == null) {
            return false;
        }
        boolean hasVar = false;
        LexicalUnit.LexicalType type = lu.getLexicalUnitType();
        if (type != LexicalUnit.LexicalType.IDENT) {
            if (type == LexicalUnit.LexicalType.VAR) {
                hasVar = true;
            } else if (type != LexicalUnit.LexicalType.ATTR) {
                return false;
            }
        } else if (!"in".equalsIgnoreCase(lu.getStringValue())) {
            return false;
        }
        lu = lu.getNextLexicalUnit();
        if (lu == null) {
            return hasVar;
        }
        type = lu.getLexicalUnitType();
        if (type != LexicalUnit.LexicalType.IDENT) {
            if (type == LexicalUnit.LexicalType.VAR) {
                hasVar = true;
            } else if (type != LexicalUnit.LexicalType.ATTR) {
                return hasVar;
            }
        }
        if ((lu = lu.getNextLexicalUnit()) == null) {
            return hasVar;
        }
        type = lu.getLexicalUnitType();
        boolean bl = lastTypeIsComma = type == LexicalUnit.LexicalType.OPERATOR_COMMA;
        if (!lastTypeIsComma) {
            if (type == LexicalUnit.LexicalType.IDENT || type == LexicalUnit.LexicalType.ATTR) {
                if ((lu = lu.getNextLexicalUnit()) == null) {
                    return hasVar;
                }
                type = lu.getLexicalUnitType();
                if (type == LexicalUnit.LexicalType.IDENT) {
                    if (!hasVar && !"hue".equalsIgnoreCase(lu.getStringValue())) {
                        return false;
                    }
                    if ((lu = lu.getNextLexicalUnit()) == null) {
                        return hasVar;
                    }
                    type = lu.getLexicalUnitType();
                }
                lastTypeIsComma = type == LexicalUnit.LexicalType.OPERATOR_COMMA;
            } else if (type == LexicalUnit.LexicalType.VAR) {
                hasVar = true;
            } else if (!hasVar) {
                return false;
            }
        }
        if (lastTypeIsComma) {
            lu = lu.getNextLexicalUnit();
        }
        if (lu == null) {
            return !lastTypeIsComma && hasVar;
        }
        CSSValueSyntax synColor = new SyntaxParser().parseSyntax("<color>");
        LexicalUnit.LexicalType uType = lu.getLexicalUnitType();
        if (uType == LexicalUnit.LexicalType.PERCENTAGE || uType == LexicalUnit.LexicalType.CALC || uType == LexicalUnit.LexicalType.MATH_FUNCTION || uType == LexicalUnit.LexicalType.FUNCTION) {
            if ((lu = lu.getNextLexicalUnit()) == null || FunctionFactories.cannotBeColor(lu, synColor)) {
                return false;
            }
            lu = lu.getNextLexicalUnit();
        } else if (uType == LexicalUnit.LexicalType.VAR) {
            hasVar = true;
            lu = lu.getNextLexicalUnit();
        } else {
            if (FunctionFactories.cannotBeColor(lu, synColor)) {
                return false;
            }
            if ((lu = lu.getNextLexicalUnit()) == null) {
                return hasVar;
            }
            uType = lu.getLexicalUnitType();
            if (uType != LexicalUnit.LexicalType.OPERATOR_COMMA) {
                switch (uType) {
                    case VAR: {
                        hasVar = true;
                    }
                    case CALC: 
                    case MATH_FUNCTION: 
                    case FUNCTION: 
                    case ATTR: 
                    case PERCENTAGE: {
                        lu = lu.getNextLexicalUnit();
                        break;
                    }
                    default: {
                        return false;
                    }
                }
            }
        }
        if (lu == null) {
            return hasVar;
        }
        uType = lu.getLexicalUnitType();
        if (uType != LexicalUnit.LexicalType.OPERATOR_COMMA) {
            return hasVar && (!FunctionFactories.cannotBeColor(lu, synColor) || uType == LexicalUnit.LexicalType.PERCENTAGE || uType == LexicalUnit.LexicalType.CALC || uType == LexicalUnit.LexicalType.MATH_FUNCTION || uType == LexicalUnit.LexicalType.FUNCTION || uType == LexicalUnit.LexicalType.VAR);
        }
        uType = (lu = lu.getNextLexicalUnit()).getLexicalUnitType();
        if (uType == LexicalUnit.LexicalType.PERCENTAGE || uType == LexicalUnit.LexicalType.CALC || uType == LexicalUnit.LexicalType.MATH_FUNCTION || uType == LexicalUnit.LexicalType.FUNCTION) {
            if ((lu = lu.getNextLexicalUnit()) == null || FunctionFactories.cannotBeColor(lu, synColor)) {
                return false;
            }
            lu = lu.getNextLexicalUnit();
        } else if (uType == LexicalUnit.LexicalType.VAR) {
            hasVar = true;
            lu = lu.getNextLexicalUnit();
        } else {
            if (FunctionFactories.cannotBeColor(lu, synColor)) {
                return false;
            }
            if ((lu = lu.getNextLexicalUnit()) == null) {
                return true;
            }
            uType = lu.getLexicalUnitType();
            if (uType == LexicalUnit.LexicalType.PERCENTAGE || uType == LexicalUnit.LexicalType.CALC || uType == LexicalUnit.LexicalType.MATH_FUNCTION || uType == LexicalUnit.LexicalType.FUNCTION || uType == LexicalUnit.LexicalType.VAR || uType == LexicalUnit.LexicalType.ATTR) {
                lu = lu.getNextLexicalUnit();
            } else {
                return false;
            }
        }
        while (lu != null) {
            if (lu.getLexicalUnitType() != LexicalUnit.LexicalType.VAR) {
                return false;
            }
            lu = lu.getNextLexicalUnit();
        }
        return true;
    }

    private boolean isValidAlpha(int index, LexicalUnitImpl lu) {
        LexicalUnit.LexicalType type = lu.getLexicalUnitType();
        switch (type) {
            case INTEGER: {
                int iAlpha = lu.getIntegerValue();
                if (iAlpha < 0) {
                    lu.intValue = 0;
                    this.warn(index, "Color alpha has value under 0.");
                    break;
                }
                if (iAlpha <= 1) break;
                lu.intValue = 1;
                this.warn(index, "Color alpha has value over 1.");
                break;
            }
            case REAL: {
                float fAlpha = lu.getFloatValue();
                if (fAlpha < 0.0f) {
                    lu.floatValue = 0.0f;
                    this.warn(index, "Color alpha has value under 0.");
                    break;
                }
                if (!(fAlpha > 1.0f)) break;
                lu.floatValue = 1.0f;
                this.warn(index, "Color alpha has value over 1.");
                break;
            }
            case PERCENTAGE: {
                float fAlpha = lu.getFloatValue();
                if (fAlpha < 0.0f) {
                    lu.floatValue = 0.0f;
                    this.warn(index, "Color alpha has value under 0%.");
                    break;
                }
                if (!(fAlpha > 100.0f)) break;
                lu.floatValue = 100.0f;
                this.warn(index, "Color alpha has value over 100%.");
                break;
            }
            case IDENT: {
                if ("none".equalsIgnoreCase(lu.getStringValue())) break;
                return false;
            }
            case CALC: 
            case MATH_FUNCTION: 
            case FUNCTION: 
            case ATTR: 
            case VAR: {
                break;
            }
            default: {
                return false;
            }
        }
        lu = lu.nextLexicalUnit;
        while (lu != null) {
            if (lu.getLexicalUnitType() != LexicalUnit.LexicalType.VAR) {
                return false;
            }
            lu = lu.nextLexicalUnit;
        }
        return true;
    }

    private static boolean isComponentType(LexicalUnit.LexicalType type) {
        return type == LexicalUnit.LexicalType.INTEGER || type == LexicalUnit.LexicalType.PERCENTAGE || type == LexicalUnit.LexicalType.REAL || type == LexicalUnit.LexicalType.VAR || type == LexicalUnit.LexicalType.CALC || type == LexicalUnit.LexicalType.IDENT || type == LexicalUnit.LexicalType.MATH_FUNCTION || type == LexicalUnit.LexicalType.FUNCTION || type == LexicalUnit.LexicalType.ATTR;
    }

    private static boolean isAngleUnit(LexicalUnit lu) {
        short unit = lu.getCssUnit();
        if (!CSSUnit.isAngleUnitType(unit)) {
            if (lu.getLexicalUnitType() == LexicalUnit.LexicalType.VAR) {
                return false;
            }
            return lu.shallowMatch(SyntaxParser.createSimpleSyntax("angle")) == CSSValueSyntax.Match.TRUE;
        }
        return true;
    }

    private static boolean isPercentageUnit(LexicalUnit unit) {
        return unit.shallowMatch(SyntaxParser.createSimpleSyntax("percentage")) == CSSValueSyntax.Match.TRUE;
    }

    private static boolean cannotBeColor(LexicalUnit lu, CSSValueSyntax syn) {
        return lu.shallowMatch(syn) == CSSValueSyntax.Match.FALSE;
    }

    protected abstract void addEmptyLexicalUnit();

    protected abstract void warn(int var1, String var2);

    protected abstract void error(int var1, String var2);

    public CSSParser.LexicalUnitFactory getFactory(String lcFunctionName) {
        return this.factories.get(lcFunctionName);
    }
}

