/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.property;

import io.sf.carte.doc.style.css.CSSExpression;
import io.sf.carte.doc.style.css.CSSExpressionValue;
import io.sf.carte.doc.style.css.CSSOperandExpression;
import io.sf.carte.doc.style.css.CSSTypedValue;
import io.sf.carte.doc.style.css.CSSValue;
import io.sf.carte.doc.style.css.CSSValueSyntax;
import io.sf.carte.doc.style.css.nsac.LexicalUnit;
import io.sf.carte.doc.style.css.property.DimensionalEvaluator;
import io.sf.carte.doc.style.css.property.ExpressionFactory;
import io.sf.carte.doc.style.css.property.PrimitiveValue;
import io.sf.carte.doc.style.css.property.TypedValue;
import io.sf.carte.util.SimpleWriter;
import java.io.IOException;
import org.w3c.dom.DOMException;

public class ExpressionValue
extends TypedValue
implements CSSExpressionValue {
    private static final long serialVersionUID = 1L;
    private CSSExpression expression = null;
    private boolean roundResult = false;

    public ExpressionValue() {
        super(CSSValue.Type.EXPRESSION);
    }

    protected ExpressionValue(ExpressionValue copied) {
        super(copied);
        this.expression = copied.expression.clone();
        this.roundResult = copied.roundResult;
    }

    @Override
    ExpressionLexicalSetter newLexicalSetter() {
        return new ExpressionLexicalSetter();
    }

    @Override
    public CSSExpression getExpression() {
        return this.expression;
    }

    ExpressionFactory createExpressionFactory(LexicalUnit nextLexicalUnit) {
        return new ExpressionFactory(nextLexicalUnit);
    }

    @Override
    public String getStringValue() throws DOMException {
        return "";
    }

    @Override
    public float getFloatValue(short unitType) throws DOMException {
        throw new DOMException(15, "Please use an evaluator and compute result.");
    }

    @Override
    public String getCssText() {
        String s = this.expression.getCssText();
        if (this.isStandAloneExpression()) {
            return s;
        }
        StringBuilder buf = new StringBuilder(s.length() + 2);
        buf.append('(').append(s).append(')');
        return buf.toString();
    }

    @Override
    public String getMinifiedCssText(String propertyName) {
        String s = this.expression.getMinifiedCssText();
        if (this.isStandAloneExpression()) {
            return s;
        }
        StringBuilder buf = new StringBuilder(s.length() + 2);
        buf.append('(').append(s).append(')');
        return buf.toString();
    }

    private boolean isStandAloneExpression() {
        return this.expression.getPartType() != CSSExpression.AlgebraicPart.OPERAND || ((CSSOperandExpression)this.expression).getOperand().getPrimitiveType() != CSSValue.Type.IDENT || ExpressionValue.isNumericConstant(((CSSTypedValue)((CSSOperandExpression)this.expression).getOperand()).getStringValue());
    }

    private static boolean isNumericConstant(String s) {
        return "pi".equalsIgnoreCase(s) || "e".equalsIgnoreCase(s);
    }

    @Override
    public void writeCssText(SimpleWriter wri) throws IOException {
        if (this.expression.getPartType() != CSSExpression.AlgebraicPart.OPERAND) {
            this.expression.writeCssText(wri);
        } else {
            wri.write('(');
            this.expression.writeCssText(wri);
            wri.write(')');
        }
    }

    @Override
    public void setCssText(String cssText) throws DOMException {
        throw new DOMException(7, "The value of this property cannot be modified.");
    }

    @Override
    public void setExpectInteger() {
        this.roundResult = true;
    }

    @Override
    public boolean isExpectingInteger() {
        return this.roundResult;
    }

    @Override
    public short computeUnitType() {
        short unit;
        DimensionalEvaluator eval = new DimensionalEvaluator();
        try {
            unit = eval.computeUnitType(this.getExpression());
        }
        catch (DOMException e) {
            unit = 255;
        }
        return unit;
    }

    @Override
    public CSSValueSyntax.Match matches(CSSValueSyntax syntax) {
        if (syntax == null) {
            return CSSValueSyntax.Match.FALSE;
        }
        return this.dimensionalAnalysis(syntax, true);
    }

    @Override
    CSSValueSyntax.Match matchesComponent(CSSValueSyntax syntax) {
        return this.dimensionalAnalysis(syntax, false);
    }

    private CSSValueSyntax.Match dimensionalAnalysis(CSSValueSyntax syntax, boolean followComponents) {
        CSSValueSyntax.Category result;
        DimensionalEvaluator eval = new DimensionalEvaluator();
        try {
            result = eval.dimensionalAnalysis(this.getExpression());
        }
        catch (DOMException e) {
            if (eval.hasUnknownFunction() && syntax.getCategory() == CSSValueSyntax.Category.universal) {
                return CSSValueSyntax.Match.TRUE;
            }
            return CSSValueSyntax.Match.FALSE;
        }
        if (syntax.getCategory() == CSSValueSyntax.Category.universal) {
            return CSSValueSyntax.Match.TRUE;
        }
        boolean lengthPercentageL = false;
        boolean lengthPercentageP = false;
        do {
            CSSValueSyntax.Category cat;
            if ((cat = syntax.getCategory()) == result) {
                return CSSValueSyntax.Match.TRUE;
            }
            if (cat == CSSValueSyntax.Category.lengthPercentage && (result == CSSValueSyntax.Category.length || result == CSSValueSyntax.Category.percentage) || cat == CSSValueSyntax.Category.integer && result == CSSValueSyntax.Category.number) {
                return CSSValueSyntax.Match.TRUE;
            }
            if (result != CSSValueSyntax.Category.lengthPercentage) continue;
            if (cat == CSSValueSyntax.Category.length) {
                if (lengthPercentageP) {
                    return CSSValueSyntax.Match.TRUE;
                }
                lengthPercentageL = true;
                continue;
            }
            if (cat != CSSValueSyntax.Category.percentage) continue;
            if (lengthPercentageL) {
                return CSSValueSyntax.Match.TRUE;
            }
            lengthPercentageP = true;
        } while (followComponents && (syntax = syntax.getNext()) != null);
        return CSSValueSyntax.Match.FALSE;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.expression == null ? 0 : this.expression.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ExpressionValue other = (ExpressionValue)obj;
        if (this.expression == null) {
            return other.expression == null;
        }
        return this.expression.equals(other.expression);
    }

    @Override
    public ExpressionValue clone() {
        return new ExpressionValue(this);
    }

    class ExpressionLexicalSetter
    extends PrimitiveValue.LexicalSetter {
        ExpressionLexicalSetter() {
            super(ExpressionValue.this);
        }

        @Override
        void setLexicalUnit(LexicalUnit lunit) throws DOMException {
            this.nextLexicalUnit = lunit.getNextLexicalUnit();
            this.setLexicalUnitFromSubValues(lunit.getParameters());
        }

        void setLexicalUnitFromSubValues(LexicalUnit lunit) throws DOMException {
            ExpressionFactory ef = ExpressionValue.this.createExpressionFactory(this.nextLexicalUnit);
            ExpressionValue.this.expression = ef.createExpression(lunit);
            if (ExpressionValue.this.expression == null) {
                throw new DOMException(12, "Void expression");
            }
            this.nextLexicalUnit = ef.getNextLexicalUnit();
        }
    }
}

