/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.property;

import io.sf.carte.doc.style.css.CSSValue;
import io.sf.carte.doc.style.css.CSSValueSyntax;
import io.sf.carte.doc.style.css.nsac.CSSException;
import io.sf.carte.doc.style.css.nsac.LexicalUnit;
import io.sf.carte.doc.style.css.parser.CSSParser;
import io.sf.carte.doc.style.css.parser.ParseHelper;
import io.sf.carte.doc.style.css.property.CSSLexicalProcessingException;
import io.sf.carte.doc.style.css.property.PrimitiveValue;
import io.sf.carte.doc.style.css.property.StringValue;
import java.io.IOException;
import java.io.StringReader;
import java.net.URI;
import java.net.URL;
import org.w3c.dom.DOMException;

public class URIValue
extends StringValue {
    private static final long serialVersionUID = 1L;

    public URIValue(short flags) {
        super(CSSValue.Type.URI, flags);
    }

    protected URIValue(URIValue copied) {
        super(copied);
    }

    @Override
    PrimitiveValue.LexicalSetter newLexicalSetter() {
        return new URILexicalSetter();
    }

    @Override
    public void setCssText(String cssText) throws DOMException {
        LexicalUnit lunit;
        this.checkModifiableProperty();
        if (cssText.indexOf(40) == -1 && cssText.indexOf(41) == -1) {
            cssText = "url(" + cssText + ")";
        }
        PrimitiveValue.LexicalSetter setter = this.newLexicalSetter();
        CSSParser parser = new CSSParser();
        try {
            lunit = parser.parsePropertyValue(new StringReader(cssText));
        }
        catch (CSSException e) {
            DOMException ex = new DOMException(12, "Error parsing text: " + e.getMessage());
            ex.initCause(e);
            throw ex;
        }
        catch (IOException e) {
            lunit = null;
        }
        if (lunit == null || lunit.getLexicalUnitType() != LexicalUnit.LexicalType.URI) {
            throw new DOMException(13, "Not a URI value.");
        }
        setter.setLexicalUnit(lunit);
    }

    @Override
    boolean usesDoubleQuote(String text) {
        int i = text.lastIndexOf(41);
        while (i > 0) {
            char c;
            if ((c = text.charAt(--i)) == ' ') continue;
            return c == '\"';
        }
        return false;
    }

    @Override
    protected void setUnescapedCssText(String css) {
        int idx = (css = ParseHelper.escapeBackslash(css).toString()).indexOf(39);
        if (idx != -1) {
            int len = css.length();
            StringBuilder buf = new StringBuilder(len + 8);
            buf.append(css.subSequence(0, idx));
            for (int i = idx; i < len; ++i) {
                char c = css.charAt(i);
                if (c == this.quote) {
                    buf.append('\\');
                }
                buf.append(c);
            }
            css = buf.toString();
        }
        this.setPlainCssText("url(" + this.quote + css + this.quote + ')');
    }

    @Override
    public String getMinifiedCssText(String propertyName) {
        String text;
        String sv = this.getStringValue();
        if (sv != null) {
            String quoted = ParseHelper.quote(sv, this.quote);
            StringBuilder buf = new StringBuilder(quoted.length() + 5);
            buf.append("url(").append(quoted).append(')');
            text = buf.toString();
        } else {
            text = "url()";
        }
        return text;
    }

    public URL getURLValue() {
        URL url = null;
        String sv = this.getStringValue();
        try {
            URI uri = new URI(sv);
            if (uri.isAbsolute()) {
                url = uri.toURL();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return url;
    }

    @Override
    CSSValueSyntax.Match matchesComponent(CSSValueSyntax syntax) {
        switch (syntax.getCategory()) {
            case url: 
            case image: 
            case universal: {
                return CSSValueSyntax.Match.TRUE;
            }
        }
        return CSSValueSyntax.Match.FALSE;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = this.getCssValueType().hashCode();
        result = 31 * result + this.getPrimitiveType().hashCode();
        String sv = this.getStringValue();
        return 31 * result + (sv == null ? 0 : sv.hashCode());
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof URIValue)) {
            return false;
        }
        URIValue other = (URIValue)obj;
        String sv = this.getStringValue();
        if (sv == null) {
            return other.getStringValue() == null;
        }
        return sv.equals(other.getStringValue());
    }

    public boolean isEquivalent(URIValue other) {
        if (this.getMinifiedCssText(null).equals(other.getMinifiedCssText(null))) {
            return true;
        }
        String sv = this.getStringValue();
        if (sv == null) {
            return other.getStringValue() == null;
        }
        return sv.equals(other.getStringValue());
    }

    @Override
    public URIValue clone() {
        return new URIValue(this);
    }

    class URILexicalSetter
    extends StringValue.MyLexicalSetter {
        URILexicalSetter() {
        }

        @Override
        void setLexicalUnit(LexicalUnit lunit) {
            if (lunit.getParameters() != null) {
                throw new CSSLexicalProcessingException("var() found.");
            }
            super.setLexicalUnit(lunit);
        }
    }
}

