/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.parser;

import io.sf.carte.doc.style.css.CSSValueSyntax;
import io.sf.carte.doc.style.css.parser.ParseHelper;
import java.util.Objects;

class SyntaxComponent
implements CSSValueSyntax {
    private CSSValueSyntax.Category cat;
    private String name;
    private CSSValueSyntax.Multiplier multiplier = CSSValueSyntax.Multiplier.NONE;
    private SyntaxComponent next = null;

    SyntaxComponent(String name, CSSValueSyntax.Category cat) {
        this.name = name;
        this.cat = cat;
    }

    SyntaxComponent() {
    }

    @Override
    public CSSValueSyntax.Category getCategory() {
        return this.cat;
    }

    void setCategory(CSSValueSyntax.Category cat) {
        this.cat = cat;
    }

    @Override
    public String getName() {
        return this.name;
    }

    void setName(String name) {
        this.name = name;
    }

    @Override
    public CSSValueSyntax.Multiplier getMultiplier() {
        return this.multiplier;
    }

    void setMultiplier(CSSValueSyntax.Multiplier multiplier) {
        this.multiplier = multiplier;
    }

    @Override
    public SyntaxComponent getNext() {
        return this.next;
    }

    void setNext(SyntaxComponent next) {
        this.next = next;
    }

    @Override
    public CSSValueSyntax shallowClone() {
        if (this.next == null) {
            return this;
        }
        SyntaxComponent comp = new SyntaxComponent(this.name, this.cat);
        comp.setMultiplier(this.getMultiplier());
        return comp;
    }

    @Override
    public String toString() {
        return this.toString(false);
    }

    @Override
    public String toMinifiedString() {
        return this.toString(true);
    }

    private String toString(boolean mini) {
        if (this.cat == CSSValueSyntax.Category.IDENT && this.next == null && this.multiplier == CSSValueSyntax.Multiplier.NONE) {
            return ParseHelper.escape(this.name, true, true);
        }
        StringBuilder buf = new StringBuilder(32);
        SyntaxComponent.appendToBuffer(this, buf, mini);
        return buf.toString();
    }

    private static void appendToBuffer(SyntaxComponent syntax, StringBuilder buf, boolean mini) {
        if (syntax.cat == CSSValueSyntax.Category.universal) {
            buf.append('*');
        } else if (syntax.cat == CSSValueSyntax.Category.IDENT) {
            buf.append(ParseHelper.escape(syntax.name, true, true));
        } else {
            buf.append('<').append(syntax.name).append('>');
        }
        switch (syntax.getMultiplier()) {
            case NUMBER: {
                buf.append('#');
                break;
            }
            case PLUS: {
                buf.append('+');
            }
        }
        if (syntax.next != null) {
            if (mini) {
                buf.append('|');
            } else {
                buf.append(" | ");
            }
            SyntaxComponent.appendToBuffer(syntax.next, buf, mini);
        }
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.cat, this.multiplier, this.name, this.next});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SyntaxComponent other = (SyntaxComponent)obj;
        return this.cat == other.cat && this.multiplier == other.multiplier && Objects.equals(this.name, other.name) && Objects.equals(this.next, other.next);
    }
}

