/*

   See the NOTICE file distributed with this work for additional
   information regarding copyright ownership.

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.

 */
package io.sf.carte.echosvg.anim.dom;

import org.w3c.dom.Node;
import org.w3c.dom.svg.SVGAnimatedEnumeration;
import org.w3c.dom.svg.SVGAnimatedString;
import org.w3c.dom.svg.SVGFEBlendElement;

import io.sf.carte.echosvg.dom.AbstractDocument;
import io.sf.carte.echosvg.util.DoublyIndexedTable;
import io.sf.carte.echosvg.util.SVGTypes;

/**
 * This class implements {@link SVGFEBlendElement}.
 *
 * @author <a href="mailto:stephane@hillion.org">Stephane Hillion</a>
 * @author For later modifications, see Git history.
 * @version $Id$
 */
public class SVGOMFEBlendElement extends SVGOMFilterPrimitiveStandardAttributes implements SVGFEBlendElement {

	private static final long serialVersionUID = 1L;

	/**
	 * Table mapping XML attribute names to TraitInformation objects.
	 */
	protected static DoublyIndexedTable<String, String> xmlTraitInformation;
	static {
		DoublyIndexedTable<String, String> t = new DoublyIndexedTable<>(
				SVGOMFilterPrimitiveStandardAttributes.xmlTraitInformation);
		t.put(null, SVG_IN_ATTRIBUTE, new TraitInformation(true, SVGTypes.TYPE_CDATA));
		t.put(null, SVG_SURFACE_SCALE_ATTRIBUTE, new TraitInformation(true, SVGTypes.TYPE_NUMBER));
		t.put(null, SVG_DIFFUSE_CONSTANT_ATTRIBUTE, new TraitInformation(true, SVGTypes.TYPE_NUMBER));
		t.put(null, SVG_KERNEL_UNIT_LENGTH_ATTRIBUTE, new TraitInformation(true, SVGTypes.TYPE_NUMBER_OPTIONAL_NUMBER));
		xmlTraitInformation = t;
	}

	/**
	 * The 'mode' attribute values.
	 */
	protected static final String[] MODE_VALUES = { "", SVG_NORMAL_VALUE, SVG_MULTIPLY_VALUE, SVG_SCREEN_VALUE,
			SVG_DARKEN_VALUE, SVG_LIGHTEN_VALUE };

	/**
	 * The 'in' attribute value.
	 */
	protected SVGOMAnimatedString in;

	/**
	 * The 'in2' attribute value.
	 */
	protected SVGOMAnimatedString in2;

	/**
	 * The 'mode' attribute value.
	 */
	protected SVGOMAnimatedEnumeration mode;

	/**
	 * Creates a new SVGOMFEBlendElement object.
	 */
	protected SVGOMFEBlendElement() {
	}

	/**
	 * Creates a new SVGOMFEBlendElement object.
	 * 
	 * @param prefix The namespace prefix.
	 * @param owner  The owner document.
	 */
	public SVGOMFEBlendElement(String prefix, AbstractDocument owner) {
		super(prefix, owner);
		initializeLiveAttributes();
	}

	/**
	 * Initializes all live attributes for this element.
	 */
	@Override
	protected void initializeAllLiveAttributes() {
		super.initializeAllLiveAttributes();
		initializeLiveAttributes();
	}

	/**
	 * Initializes the live attribute values of this element.
	 */
	private void initializeLiveAttributes() {
		in = createLiveAnimatedString(null, SVG_IN_ATTRIBUTE);
		in2 = createLiveAnimatedString(null, SVG_IN2_ATTRIBUTE);
		mode = createLiveAnimatedEnumeration(null, SVG_MODE_ATTRIBUTE, MODE_VALUES, (short) 1);
	}

	/**
	 * <b>DOM</b>: Implements {@link Node#getLocalName()}.
	 */
	@Override
	public String getLocalName() {
		return SVG_FE_BLEND_TAG;
	}

	/**
	 * <b>DOM</b>: Implements {@link SVGFEBlendElement#getIn1()}.
	 */
	@Override
	public SVGAnimatedString getIn1() {
		return in;
	}

	/**
	 * <b>DOM</b>: Implements {@link SVGFEBlendElement#getIn2()}.
	 */
	@Override
	public SVGAnimatedString getIn2() {
		return in2;
	}

	/**
	 * <b>DOM</b>: Implements {@link SVGFEBlendElement#getMode()}.
	 */
	@Override
	public SVGAnimatedEnumeration getMode() {
		return mode;
	}

	/**
	 * Returns a new uninitialized instance of this object's class.
	 */
	@Override
	protected Node newNode() {
		return new SVGOMFEBlendElement();
	}

	/**
	 * Returns the table of TraitInformation objects for this element.
	 */
	@Override
	protected DoublyIndexedTable<String, String> getTraitInformationTable() {
		return xmlTraitInformation;
	}

}
