/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.echosvg.anim.dom;

import io.sf.carte.echosvg.anim.dom.AbstractElement;
import io.sf.carte.echosvg.anim.dom.AbstractSVGAnimatedValue;
import io.sf.carte.echosvg.anim.dom.AbstractSVGLengthList;
import io.sf.carte.echosvg.anim.dom.AnimationTarget;
import io.sf.carte.echosvg.anim.dom.SVGOMElement;
import io.sf.carte.echosvg.anim.values.AnimatableLengthListValue;
import io.sf.carte.echosvg.anim.values.AnimatableValue;
import io.sf.carte.echosvg.dom.svg.AbstractSVGList;
import io.sf.carte.echosvg.dom.svg.ListBuilder;
import io.sf.carte.echosvg.dom.svg.ListHandler;
import io.sf.carte.echosvg.dom.svg.LiveAttributeException;
import io.sf.carte.echosvg.dom.svg.SVGItem;
import io.sf.carte.echosvg.parser.ParseException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;
import org.w3c.dom.svg.SVGAnimatedLengthList;
import org.w3c.dom.svg.SVGException;
import org.w3c.dom.svg.SVGLength;
import org.w3c.dom.svg.SVGLengthList;

public class SVGOMAnimatedLengthList
extends AbstractSVGAnimatedValue
implements SVGAnimatedLengthList {
    protected BaseSVGLengthList baseVal;
    protected AnimSVGLengthList animVal;
    protected boolean changing;
    protected String defaultValue;
    protected boolean emptyAllowed;
    protected short direction;

    public SVGOMAnimatedLengthList(AbstractElement elt, String ns, String ln, String defaultValue, boolean emptyAllowed, short direction) {
        super(elt, ns, ln);
        this.defaultValue = defaultValue;
        this.emptyAllowed = emptyAllowed;
        this.direction = direction;
    }

    public SVGLengthList getBaseVal() {
        if (this.baseVal == null) {
            this.baseVal = new BaseSVGLengthList();
        }
        return this.baseVal;
    }

    public SVGLengthList getAnimVal() {
        if (this.animVal == null) {
            this.animVal = new AnimSVGLengthList();
        }
        return this.animVal;
    }

    public void check() {
        if (!this.hasAnimVal) {
            if (this.baseVal == null) {
                this.baseVal = new BaseSVGLengthList();
            }
            this.baseVal.revalidate();
            if (this.baseVal.missing) {
                throw new LiveAttributeException((Element)((Object)this.element), this.localName, 0, null);
            }
            if (this.baseVal.malformed) {
                throw new LiveAttributeException((Element)((Object)this.element), this.localName, 1, this.baseVal.getValueAsString());
            }
        }
    }

    @Override
    public AnimatableValue getUnderlyingValue(AnimationTarget target) {
        SVGLengthList ll = this.getBaseVal();
        int n = ll.getNumberOfItems();
        short[] types = new short[n];
        float[] values = new float[n];
        for (int i = 0; i < n; ++i) {
            SVGLength l = ll.getItem(i);
            types[i] = l.getUnitType();
            values[i] = l.getValueInSpecifiedUnits();
        }
        return new AnimatableLengthListValue(target, types, values, target.getPercentageInterpretation(this.getNamespaceURI(), this.getLocalName(), false));
    }

    @Override
    protected void updateAnimatedValue(AnimatableValue val) {
        if (val == null) {
            this.hasAnimVal = false;
        } else {
            this.hasAnimVal = true;
            AnimatableLengthListValue animLengths = (AnimatableLengthListValue)val;
            if (this.animVal == null) {
                this.animVal = new AnimSVGLengthList();
            }
            this.animVal.setAnimatedValue(animLengths.getLengthTypes(), animLengths.getLengthValues());
        }
        this.fireAnimatedAttributeListeners();
    }

    public void attrAdded(Attr node, String newv) {
        if (!this.changing && this.baseVal != null) {
            this.baseVal.invalidate();
        }
        this.fireBaseAttributeListeners();
        if (!this.hasAnimVal) {
            this.fireAnimatedAttributeListeners();
        }
    }

    public void attrModified(Attr node, String oldv, String newv) {
        if (!this.changing && this.baseVal != null) {
            this.baseVal.invalidate();
        }
        this.fireBaseAttributeListeners();
        if (!this.hasAnimVal) {
            this.fireAnimatedAttributeListeners();
        }
    }

    public void attrRemoved(Attr node, String oldv) {
        if (!this.changing && this.baseVal != null) {
            this.baseVal.invalidate();
        }
        this.fireBaseAttributeListeners();
        if (!this.hasAnimVal) {
            this.fireAnimatedAttributeListeners();
        }
    }

    public class BaseSVGLengthList
    extends AbstractSVGLengthList {
        protected boolean missing;
        protected boolean malformed;

        public BaseSVGLengthList() {
            super(SVGOMAnimatedLengthList.this.direction);
        }

        protected DOMException createDOMException(short type, String key, Object[] args) {
            return SVGOMAnimatedLengthList.this.element.createDOMException(type, key, args);
        }

        @Override
        protected SVGException createSVGException(short type, String key, Object[] args) {
            return ((SVGOMElement)SVGOMAnimatedLengthList.this.element).createSVGException(type, key, args);
        }

        @Override
        protected Element getElement() {
            return SVGOMAnimatedLengthList.this.element;
        }

        protected String getValueAsString() {
            Attr attr = SVGOMAnimatedLengthList.this.element.getAttributeNodeNS(SVGOMAnimatedLengthList.this.namespaceURI, SVGOMAnimatedLengthList.this.localName);
            if (attr == null) {
                return SVGOMAnimatedLengthList.this.defaultValue;
            }
            return attr.getValue();
        }

        protected void setAttributeValue(String value) {
            try {
                SVGOMAnimatedLengthList.this.changing = true;
                SVGOMAnimatedLengthList.this.element.setAttributeNS(SVGOMAnimatedLengthList.this.namespaceURI, SVGOMAnimatedLengthList.this.localName, value);
            }
            finally {
                SVGOMAnimatedLengthList.this.changing = false;
            }
        }

        protected void resetAttribute() {
            super.resetAttribute();
            this.missing = false;
            this.malformed = false;
        }

        protected void resetAttribute(SVGItem item) {
            super.resetAttribute(item);
            this.missing = false;
            this.malformed = false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void revalidate() {
            boolean isEmpty;
            if (this.valid) {
                return;
            }
            this.valid = true;
            this.missing = false;
            this.malformed = false;
            String s = this.getValueAsString();
            boolean bl = isEmpty = s != null && (s = s.trim()).isEmpty();
            if (s == null || isEmpty && !SVGOMAnimatedLengthList.this.emptyAllowed) {
                this.missing = true;
                this.clear(this.itemList);
                this.itemList = new ArrayList(1);
                return;
            }
            if (isEmpty) {
                this.itemList = new ArrayList(1);
            } else {
                ListBuilder builder = new ListBuilder((AbstractSVGList)this);
                try {
                    this.doParse(s, (ListHandler)builder);
                }
                catch (ParseException e) {
                    this.malformed = true;
                }
                finally {
                    this.clear(this.itemList);
                    List parsedList = builder.getList();
                    this.itemList = parsedList != null ? parsedList : new ArrayList(1);
                }
            }
        }

        @Override
        public void copyTo(AbstractSVGList list) {
            super.copyTo(list);
            BaseSVGLengthList other = (BaseSVGLengthList)list;
            other.malformed = this.malformed;
            other.missing = this.missing;
        }
    }

    protected class AnimSVGLengthList
    extends AbstractSVGLengthList {
        public AnimSVGLengthList() {
            super(SVGOMAnimatedLengthList.this.direction);
            this.itemList = new ArrayList(1);
        }

        protected DOMException createDOMException(short type, String key, Object[] args) {
            return SVGOMAnimatedLengthList.this.element.createDOMException(type, key, args);
        }

        @Override
        protected SVGException createSVGException(short type, String key, Object[] args) {
            return ((SVGOMElement)SVGOMAnimatedLengthList.this.element).createSVGException(type, key, args);
        }

        @Override
        protected Element getElement() {
            return SVGOMAnimatedLengthList.this.element;
        }

        public int getNumberOfItems() {
            if (SVGOMAnimatedLengthList.this.hasAnimVal) {
                return super.getNumberOfItems();
            }
            return SVGOMAnimatedLengthList.this.getBaseVal().getNumberOfItems();
        }

        @Override
        public SVGLength getItem(int index) throws DOMException {
            if (SVGOMAnimatedLengthList.this.hasAnimVal) {
                return super.getItem(index);
            }
            return SVGOMAnimatedLengthList.this.getBaseVal().getItem(index);
        }

        protected String getValueAsString() {
            if (this.itemList.size() == 0) {
                return "";
            }
            StringBuilder sb = new StringBuilder(this.itemList.size() * 8);
            Iterator i = this.itemList.iterator();
            if (i.hasNext()) {
                sb.append(((SVGItem)i.next()).getValueAsString());
            }
            while (i.hasNext()) {
                sb.append(this.getItemSeparator());
                sb.append(((SVGItem)i.next()).getValueAsString());
            }
            return sb.toString();
        }

        protected void setAttributeValue(String value) {
        }

        public void clear() throws DOMException {
            throw SVGOMAnimatedLengthList.this.element.createDOMException((short)7, "readonly.length.list", null);
        }

        @Override
        public SVGLength initialize(SVGLength newItem) throws DOMException, SVGException {
            throw SVGOMAnimatedLengthList.this.element.createDOMException((short)7, "readonly.length.list", null);
        }

        @Override
        public SVGLength insertItemBefore(SVGLength newItem, int index) throws DOMException, SVGException {
            throw SVGOMAnimatedLengthList.this.element.createDOMException((short)7, "readonly.length.list", null);
        }

        @Override
        public SVGLength replaceItem(SVGLength newItem, int index) throws DOMException, SVGException {
            throw SVGOMAnimatedLengthList.this.element.createDOMException((short)7, "readonly.length.list", null);
        }

        @Override
        public SVGLength removeItem(int index) throws DOMException {
            throw SVGOMAnimatedLengthList.this.element.createDOMException((short)7, "readonly.length.list", null);
        }

        @Override
        public SVGLength appendItem(SVGLength newItem) throws DOMException {
            throw SVGOMAnimatedLengthList.this.element.createDOMException((short)7, "readonly.length.list", null);
        }

        protected void setAnimatedValue(short[] types, float[] values) {
            int i;
            int size = this.itemList.size();
            for (i = 0; i < size && i < types.length; ++i) {
                AbstractSVGLengthList.SVGLengthItem l = (AbstractSVGLengthList.SVGLengthItem)this.itemList.get(i);
                l.unitType = types[i];
                l.value = values[i];
                l.direction = this.direction;
            }
            while (i < types.length) {
                this.appendItemImpl(new AbstractSVGLengthList.SVGLengthItem(types[i], values[i], this.direction));
                ++i;
            }
            while (size > types.length) {
                this.removeItemImpl(--size);
            }
        }

        protected void resetAttribute() {
        }

        protected void resetAttribute(SVGItem item) {
        }

        protected void revalidate() {
            this.valid = true;
        }
    }
}

