/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.echosvg.anim.dom;

import io.sf.carte.doc.style.css.CSSExpressionValue;
import io.sf.carte.doc.style.css.CSSTypedValue;
import io.sf.carte.doc.style.css.CSSValue;
import io.sf.carte.doc.style.css.property.Evaluator;
import io.sf.carte.doc.style.css.property.StyleValue;
import io.sf.carte.doc.style.css.property.ValueFactory;
import io.sf.carte.doc.style.css.property.ValueList;
import io.sf.carte.echosvg.anim.dom.AbstractElement;
import io.sf.carte.echosvg.anim.dom.AbstractSVGAnimatedValue;
import io.sf.carte.echosvg.anim.dom.AnimationTarget;
import io.sf.carte.echosvg.anim.values.AnimatableRectValue;
import io.sf.carte.echosvg.anim.values.AnimatableValue;
import io.sf.carte.echosvg.dom.svg.LiveAttributeException;
import io.sf.carte.echosvg.dom.svg.SVGOMRect;
import io.sf.carte.echosvg.parser.DefaultNumberListHandler;
import io.sf.carte.echosvg.parser.NumberListHandler;
import io.sf.carte.echosvg.parser.NumberListParser;
import io.sf.carte.echosvg.parser.ParseException;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;
import org.w3c.dom.svg.SVGAnimatedRect;
import org.w3c.dom.svg.SVGRect;

public class SVGOMAnimatedRect
extends AbstractSVGAnimatedValue
implements SVGAnimatedRect {
    protected BaseSVGRect baseVal;
    protected AnimSVGRect animVal;
    protected boolean changing;
    protected String defaultValue;

    public SVGOMAnimatedRect(AbstractElement elt, String ns, String ln, String def) {
        super(elt, ns, ln);
        this.defaultValue = def;
    }

    public SVGRect getBaseVal() {
        if (this.baseVal == null) {
            this.baseVal = new BaseSVGRect();
        }
        return this.baseVal;
    }

    public SVGRect getAnimVal() {
        if (this.animVal == null) {
            this.animVal = new AnimSVGRect();
        }
        return this.animVal;
    }

    @Override
    protected void updateAnimatedValue(AnimatableValue val) {
        if (val == null) {
            this.hasAnimVal = false;
        } else {
            this.hasAnimVal = true;
            AnimatableRectValue animRect = (AnimatableRectValue)val;
            if (this.animVal == null) {
                this.animVal = new AnimSVGRect();
            }
            this.animVal.setAnimatedValue(animRect.getX(), animRect.getY(), animRect.getWidth(), animRect.getHeight());
        }
        this.fireAnimatedAttributeListeners();
    }

    @Override
    public AnimatableValue getUnderlyingValue(AnimationTarget target) {
        this.getBaseVal();
        float[] rect = this.baseVal.toArray();
        return new AnimatableRectValue(target, rect[0], rect[1], rect[2], rect[3]);
    }

    public void attrAdded(Attr node, String newv) {
        if (!this.changing && this.baseVal != null) {
            this.baseVal.invalidate();
        }
        this.fireBaseAttributeListeners();
        if (!this.hasAnimVal) {
            this.fireAnimatedAttributeListeners();
        }
    }

    public void attrModified(Attr node, String oldv, String newv) {
        if (!this.changing && this.baseVal != null) {
            this.baseVal.invalidate();
        }
        this.fireBaseAttributeListeners();
        if (!this.hasAnimVal) {
            this.fireAnimatedAttributeListeners();
        }
    }

    public void attrRemoved(Attr node, String oldv) {
        if (!this.changing && this.baseVal != null) {
            this.baseVal.invalidate();
        }
        this.fireBaseAttributeListeners();
        if (!this.hasAnimVal) {
            this.fireAnimatedAttributeListeners();
        }
    }

    protected class BaseSVGRect
    extends SVGOMRect {
        protected boolean valid;

        protected BaseSVGRect() {
        }

        public void invalidate() {
            this.valid = false;
        }

        protected void reset() {
            try {
                SVGOMAnimatedRect.this.changing = true;
                SVGOMAnimatedRect.this.element.setAttributeNS(SVGOMAnimatedRect.this.namespaceURI, SVGOMAnimatedRect.this.localName, Float.toString(this.x) + ' ' + this.y + ' ' + this.w + ' ' + this.h);
            }
            finally {
                SVGOMAnimatedRect.this.changing = false;
            }
        }

        protected void revalidate() throws LiveAttributeException {
            if (this.valid) {
                return;
            }
            Attr attr = SVGOMAnimatedRect.this.element.getAttributeNodeNS(SVGOMAnimatedRect.this.namespaceURI, SVGOMAnimatedRect.this.localName);
            final String s = attr == null ? SVGOMAnimatedRect.this.defaultValue : attr.getValue();
            final float[] numbers = new float[4];
            NumberListParser p = new NumberListParser();
            p.setNumberListHandler((NumberListHandler)new DefaultNumberListHandler(){
                protected int count;

                public void endNumberList() {
                    if (this.count != 4) {
                        throw new LiveAttributeException((Element)((Object)SVGOMAnimatedRect.this.element), SVGOMAnimatedRect.this.localName, 1, s);
                    }
                }

                public void numberValue(float v) throws ParseException {
                    if (this.count < 4) {
                        numbers[this.count] = v;
                    }
                    if (v < 0.0f && (this.count == 2 || this.count == 3)) {
                        throw new LiveAttributeException((Element)((Object)SVGOMAnimatedRect.this.element), SVGOMAnimatedRect.this.localName, 1, s);
                    }
                    ++this.count;
                }

                public void calcValue(int line, int column) throws ParseException {
                    throw new CalcParseException("Cannot handle calc().", line, column);
                }
            });
            try {
                p.parse(s);
            }
            catch (CalcParseException cpe) {
                ValueFactory factory = new ValueFactory();
                try {
                    StyleValue value = factory.parseProperty(s);
                    if (!this.computeRectangle(value, numbers)) {
                        throw new LiveAttributeException((Element)((Object)SVGOMAnimatedRect.this.element), SVGOMAnimatedRect.this.localName, 1, s);
                    }
                }
                catch (Exception e) {
                    LiveAttributeException ex = new LiveAttributeException((Element)((Object)SVGOMAnimatedRect.this.element), SVGOMAnimatedRect.this.localName, 1, s);
                    ex.initCause((Throwable)e);
                    throw ex;
                }
            }
            this.x = numbers[0];
            this.y = numbers[1];
            this.w = numbers[2];
            this.h = numbers[3];
            this.valid = true;
        }

        private boolean computeRectangle(StyleValue value, float[] numbers) throws DOMException {
            if (value.getCssValueType() != CSSValue.CssType.LIST) {
                return false;
            }
            ValueList list = (ValueList)value;
            if (list.getLength() != 4) {
                return false;
            }
            for (int i = 0; i < 4; ++i) {
                StyleValue item = list.item(i);
                if (item.getCssValueType() != CSSValue.CssType.TYPED) {
                    return false;
                }
                CSSTypedValue typed = (CSSTypedValue)item;
                switch (item.getPrimitiveType()) {
                    case NUMERIC: {
                        if (typed.getUnitType() == 0) break;
                        return false;
                    }
                    case EXPRESSION: {
                        Evaluator eval = new Evaluator(0);
                        typed = eval.evaluateExpression((CSSExpressionValue)typed);
                        if (typed.getUnitType() == 0) break;
                        return false;
                    }
                    default: {
                        return false;
                    }
                }
                numbers[i] = typed.getFloatValue((short)0);
            }
            return true;
        }

        public float getX() {
            this.revalidate();
            return this.x;
        }

        public void setX(float x) throws DOMException {
            this.x = x;
            this.reset();
        }

        public float getY() {
            this.revalidate();
            return this.y;
        }

        public void setY(float y) throws DOMException {
            this.y = y;
            this.reset();
        }

        public float getWidth() {
            this.revalidate();
            return this.w;
        }

        public void setWidth(float width) throws DOMException {
            this.w = width;
            this.reset();
        }

        public float getHeight() {
            this.revalidate();
            return this.h;
        }

        public void setHeight(float height) throws DOMException {
            this.h = height;
            this.reset();
        }

        public float[] toArray() throws LiveAttributeException {
            this.revalidate();
            return super.toArray();
        }
    }

    protected class AnimSVGRect
    extends SVGOMRect {
        protected AnimSVGRect() {
        }

        public float getX() {
            if (SVGOMAnimatedRect.this.hasAnimVal) {
                return super.getX();
            }
            return SVGOMAnimatedRect.this.getBaseVal().getX();
        }

        public float getY() {
            if (SVGOMAnimatedRect.this.hasAnimVal) {
                return super.getY();
            }
            return SVGOMAnimatedRect.this.getBaseVal().getY();
        }

        public float getWidth() {
            if (SVGOMAnimatedRect.this.hasAnimVal) {
                return super.getWidth();
            }
            return SVGOMAnimatedRect.this.getBaseVal().getWidth();
        }

        public float getHeight() {
            if (SVGOMAnimatedRect.this.hasAnimVal) {
                return super.getHeight();
            }
            return SVGOMAnimatedRect.this.getBaseVal().getHeight();
        }

        public void setX(float value) throws DOMException {
            throw SVGOMAnimatedRect.this.element.createDOMException((short)7, "readonly.length", null);
        }

        public void setY(float value) throws DOMException {
            throw SVGOMAnimatedRect.this.element.createDOMException((short)7, "readonly.length", null);
        }

        public void setWidth(float value) throws DOMException {
            throw SVGOMAnimatedRect.this.element.createDOMException((short)7, "readonly.length", null);
        }

        public void setHeight(float value) throws DOMException {
            throw SVGOMAnimatedRect.this.element.createDOMException((short)7, "readonly.length", null);
        }

        protected void setAnimatedValue(float x, float y, float w, float h) {
            this.x = x;
            this.y = y;
            this.w = w;
            this.h = h;
        }

        public float[] toArray() throws LiveAttributeException {
            if (SVGOMAnimatedRect.this.hasAnimVal) {
                return super.toArray();
            }
            return ((SVGOMRect)SVGOMAnimatedRect.this.getBaseVal()).toArray();
        }
    }

    static class CalcParseException
    extends ParseException {
        private static final long serialVersionUID = 1L;

        public CalcParseException(String message, int line, int column) {
            super(message, line, column);
        }
    }
}

