/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.echosvg.anim.timing;

import io.sf.carte.echosvg.anim.timing.AccesskeyTimingSpecifier;
import io.sf.carte.echosvg.anim.timing.EventbaseTimingSpecifier;
import io.sf.carte.echosvg.anim.timing.IndefiniteTimingSpecifier;
import io.sf.carte.echosvg.anim.timing.MediaMarkerTimingSpecifier;
import io.sf.carte.echosvg.anim.timing.OffsetTimingSpecifier;
import io.sf.carte.echosvg.anim.timing.RepeatTimingSpecifier;
import io.sf.carte.echosvg.anim.timing.SyncbaseTimingSpecifier;
import io.sf.carte.echosvg.anim.timing.TimedElement;
import io.sf.carte.echosvg.anim.timing.TimingSpecifier;
import io.sf.carte.echosvg.anim.timing.WallclockTimingSpecifier;
import io.sf.carte.echosvg.parser.DefaultTimingSpecifierListHandler;
import io.sf.carte.echosvg.parser.TimingSpecifierListHandler;
import io.sf.carte.echosvg.parser.TimingSpecifierListParser;
import java.util.Calendar;
import java.util.LinkedList;

public class TimingSpecifierListProducer
extends DefaultTimingSpecifierListHandler {
    protected LinkedList<TimingSpecifier> timingSpecifiers = new LinkedList();
    protected TimedElement owner;
    protected boolean isBegin;

    public TimingSpecifierListProducer(TimedElement owner, boolean isBegin) {
        this.owner = owner;
        this.isBegin = isBegin;
    }

    public TimingSpecifier[] getTimingSpecifiers() {
        return this.timingSpecifiers.toArray(new TimingSpecifier[this.timingSpecifiers.size()]);
    }

    public static TimingSpecifier[] parseTimingSpecifierList(TimedElement owner, boolean isBegin, String spec, boolean useSVG11AccessKeys, boolean useSVG12AccessKeys) {
        TimingSpecifierListParser p = new TimingSpecifierListParser(useSVG11AccessKeys, useSVG12AccessKeys);
        TimingSpecifierListProducer pp = new TimingSpecifierListProducer(owner, isBegin);
        p.setTimingSpecifierListHandler((TimingSpecifierListHandler)pp);
        p.parse(spec);
        TimingSpecifier[] specs = pp.getTimingSpecifiers();
        return specs;
    }

    public void offset(float offset) {
        OffsetTimingSpecifier ts = new OffsetTimingSpecifier(this.owner, this.isBegin, offset);
        this.timingSpecifiers.add(ts);
    }

    public void syncbase(float offset, String syncbaseID, String timeSymbol) {
        SyncbaseTimingSpecifier ts = new SyncbaseTimingSpecifier(this.owner, this.isBegin, offset, syncbaseID, timeSymbol.charAt(0) == 'b');
        this.timingSpecifiers.add(ts);
    }

    public void eventbase(float offset, String eventbaseID, String eventType) {
        EventbaseTimingSpecifier ts = new EventbaseTimingSpecifier(this.owner, this.isBegin, offset, eventbaseID, eventType);
        this.timingSpecifiers.add(ts);
    }

    public void repeat(float offset, String syncbaseID) {
        RepeatTimingSpecifier ts = new RepeatTimingSpecifier(this.owner, this.isBegin, offset, syncbaseID);
        this.timingSpecifiers.add(ts);
    }

    public void repeat(float offset, String syncbaseID, int repeatIteration) {
        RepeatTimingSpecifier ts = new RepeatTimingSpecifier(this.owner, this.isBegin, offset, syncbaseID, repeatIteration);
        this.timingSpecifiers.add(ts);
    }

    public void accesskey(float offset, char key) {
        AccesskeyTimingSpecifier ts = new AccesskeyTimingSpecifier(this.owner, this.isBegin, offset, key);
        this.timingSpecifiers.add(ts);
    }

    public void accessKeySVG12(float offset, String keyName) {
        AccesskeyTimingSpecifier ts = new AccesskeyTimingSpecifier(this.owner, this.isBegin, offset, keyName);
        this.timingSpecifiers.add(ts);
    }

    public void mediaMarker(String syncbaseID, String markerName) {
        MediaMarkerTimingSpecifier ts = new MediaMarkerTimingSpecifier(this.owner, this.isBegin, syncbaseID, markerName);
        this.timingSpecifiers.add(ts);
    }

    public void wallclock(Calendar time) {
        WallclockTimingSpecifier ts = new WallclockTimingSpecifier(this.owner, this.isBegin, time);
        this.timingSpecifiers.add(ts);
    }

    public void indefinite() {
        IndefiniteTimingSpecifier ts = new IndefiniteTimingSpecifier(this.owner, this.isBegin);
        this.timingSpecifiers.add(ts);
    }
}

