/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.echosvg.anim.dom;

import io.sf.carte.echosvg.anim.dom.AbstractSVGLength;
import io.sf.carte.echosvg.anim.dom.SVGOMElement;
import io.sf.carte.echosvg.dom.svg.AbstractSVGList;
import io.sf.carte.echosvg.dom.svg.ListHandler;
import io.sf.carte.echosvg.dom.svg.SVGItem;
import io.sf.carte.echosvg.parser.DefaultLengthHandler;
import io.sf.carte.echosvg.parser.LengthListHandler;
import io.sf.carte.echosvg.parser.LengthListParser;
import io.sf.carte.echosvg.parser.ParseException;
import org.w3c.dom.DOMException;
import org.w3c.dom.svg.SVGException;
import org.w3c.dom.svg.SVGLength;
import org.w3c.dom.svg.SVGLengthList;

public abstract class AbstractSVGLengthList
extends AbstractSVGList
implements SVGLengthList {
    protected short direction;
    public static final String SVG_LENGTH_LIST_SEPARATOR = " ";

    protected String getItemSeparator() {
        return SVG_LENGTH_LIST_SEPARATOR;
    }

    protected AbstractSVGLengthList(short direction) {
        this.direction = direction;
    }

    public SVGLength initialize(SVGLength newItem) throws DOMException, SVGException {
        return (SVGLength)this.initializeImpl(newItem);
    }

    public SVGLength getItem(int index) throws DOMException {
        return (SVGLength)this.getItemImpl(index);
    }

    public SVGLength insertItemBefore(SVGLength newItem, int index) throws DOMException, SVGException {
        return (SVGLength)this.insertItemBeforeImpl(newItem, index);
    }

    public SVGLength replaceItem(SVGLength newItem, int index) throws DOMException, SVGException {
        return (SVGLength)this.replaceItemImpl(newItem, index);
    }

    public SVGLength removeItem(int index) throws DOMException {
        return (SVGLength)this.removeItemImpl(index);
    }

    public SVGLength appendItem(SVGLength newItem) throws DOMException, SVGException {
        return (SVGLength)this.appendItemImpl(newItem);
    }

    protected SVGItem createSVGItem(Object newItem) {
        SVGLength l = (SVGLength)newItem;
        return new SVGLengthItem(l.getCSSUnitType(), l.getValueInSpecifiedUnits(), this.direction);
    }

    protected void doParse(String value, ListHandler handler) throws ParseException {
        LengthListBuilder builder = new LengthListBuilder(handler);
        LengthListParser lengthListParser = new LengthListParser((LengthListHandler)builder);
        lengthListParser.parse(value);
    }

    protected void checkItemType(Object newItem) throws SVGException {
        assert (newItem instanceof SVGLength) : this.getErrorMessage("expected.length", null);
    }

    public void copyTo(AbstractSVGList list) {
        super.copyTo(list);
        AbstractSVGLengthList other = (AbstractSVGLengthList)list;
        other.direction = this.direction;
    }

    protected class SVGLengthItem
    extends AbstractSVGLength
    implements SVGItem {
        protected AbstractSVGList parentList;

        public SVGLengthItem(short type, float value, short direction) {
            super(direction);
            this.unitType = type;
            this.value = value;
        }

        @Override
        protected SVGOMElement getAssociatedElement() {
            return (SVGOMElement)AbstractSVGLengthList.this.getElement();
        }

        public void setParent(AbstractSVGList list) {
            this.parentList = list;
        }

        public AbstractSVGList getParent() {
            return this.parentList;
        }

        @Override
        protected void reset() {
            if (this.parentList != null) {
                this.parentList.itemChanged();
            }
        }
    }

    protected class LengthListBuilder
    extends DefaultLengthHandler
    implements LengthListHandler {
        protected ListHandler listHandler;
        protected float currentValue;
        protected short currentType;

        public LengthListBuilder(ListHandler listHandler) {
            this.listHandler = listHandler;
        }

        public void startLengthList() throws ParseException {
            this.listHandler.startList();
        }

        public void startLength() throws ParseException {
            this.currentType = 0;
            this.currentValue = 0.0f;
        }

        public void lengthValue(float v) throws ParseException {
            this.currentValue = v;
        }

        protected void setUnit(short unit) {
            this.currentType = unit;
        }

        public void endLength() throws ParseException {
            this.listHandler.item((SVGItem)new SVGLengthItem(this.currentType, this.currentValue, AbstractSVGLengthList.this.direction));
        }

        public void endLengthList() throws ParseException {
            this.listHandler.endList();
        }
    }
}

