/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.echosvg.ext.awt.image.spi;

import io.sf.carte.echosvg.ext.awt.image.spi.ImageWriter;
import java.util.HashMap;
import java.util.Map;
import java.util.ServiceLoader;

public final class ImageWriterRegistry {
    private static final ImageWriterRegistry instance = new ImageWriterRegistry();
    private final Map<String, ImageWriter> imageWriterMap = new HashMap<String, ImageWriter>(10);

    private ImageWriterRegistry() {
        this.setup();
    }

    public static ImageWriterRegistry getInstance() {
        return instance;
    }

    private void setup() {
        ServiceLoader<ImageWriter> loader = ServiceLoader.load(ImageWriter.class);
        for (ImageWriter writer : loader) {
            this.register(writer);
        }
    }

    public void register(ImageWriter writer) {
        this.imageWriterMap.put(writer.getMIMEType(), writer);
    }

    public ImageWriter getWriterFor(String mime) {
        return this.imageWriterMap.get(mime);
    }
}

