/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.echosvg.bridge;

import io.sf.carte.echosvg.anim.dom.AnimatedLiveAttributeValue;
import io.sf.carte.echosvg.anim.dom.SVGOMAnimatedPoints;
import io.sf.carte.echosvg.anim.dom.SVGOMPolygonElement;
import io.sf.carte.echosvg.bridge.Bridge;
import io.sf.carte.echosvg.bridge.BridgeContext;
import io.sf.carte.echosvg.bridge.BridgeException;
import io.sf.carte.echosvg.bridge.CSSUtilities;
import io.sf.carte.echosvg.bridge.SVGDecoratedShapeElementBridge;
import io.sf.carte.echosvg.dom.svg.LiveAttributeException;
import io.sf.carte.echosvg.gvt.ShapeNode;
import io.sf.carte.echosvg.parser.AWTPolygonProducer;
import org.w3c.dom.Element;
import org.w3c.dom.svg.SVGPoint;
import org.w3c.dom.svg.SVGPointList;

public class SVGPolygonElementBridge
extends SVGDecoratedShapeElementBridge {
    @Override
    public String getLocalName() {
        return "polygon";
    }

    @Override
    public Bridge getInstance() {
        return new SVGPolygonElementBridge();
    }

    @Override
    protected void buildShape(BridgeContext ctx, Element e, ShapeNode shapeNode) {
        SVGOMPolygonElement pe = (SVGOMPolygonElement)e;
        SVGOMAnimatedPoints _points = pe.getSVGOMAnimatedPoints();
        short check = _points.check();
        if (check >= 0) {
            if (check == 0) {
                shapeNode.setShape(EMPTY_SHAPE);
                shapeNode.setVisible(false);
                return;
            }
            LiveAttributeException lex = new LiveAttributeException(e, e.getLocalName(), check, _points.getPoints().toString());
            BridgeException be = new BridgeException(ctx, lex);
            SVGPolygonElementBridge.displayErrorOrThrow(ctx, be);
        }
        try {
            SVGPointList pl = _points.getAnimatedPoints();
            int size = pl.getNumberOfItems();
            if (size == 0) {
                shapeNode.setShape(EMPTY_SHAPE);
                shapeNode.setVisible(false);
            } else {
                AWTPolygonProducer app = new AWTPolygonProducer();
                app.setWindingRule(CSSUtilities.convertFillRule(e));
                app.startPoints();
                for (int i = 0; i < size; ++i) {
                    SVGPoint p = pl.getItem(i);
                    app.point(p.getX(), p.getY());
                }
                app.endPoints();
                shapeNode.setVisible(CSSUtilities.convertVisibility(e));
                shapeNode.setShape(app.getShape());
            }
        }
        catch (LiveAttributeException ex) {
            throw new BridgeException(ctx, ex);
        }
    }

    @Override
    public void handleAnimatedAttributeChanged(AnimatedLiveAttributeValue alav) {
        String ln;
        if (alav.getNamespaceURI() == null && (ln = alav.getLocalName()).equals("points")) {
            this.buildShape(this.ctx, this.e, (ShapeNode)this.node);
            this.handleGeometryChanged();
            return;
        }
        super.handleAnimatedAttributeChanged(alav);
    }

    @Override
    protected void handleCSSPropertyChanged(int property) {
        switch (property) {
            case 17: {
                this.buildShape(this.ctx, this.e, (ShapeNode)this.node);
                this.handleGeometryChanged();
                break;
            }
            default: {
                super.handleCSSPropertyChanged(property);
            }
        }
    }
}

