/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.echosvg.bridge;

import io.sf.carte.doc.style.css.CSSExpressionValue;
import io.sf.carte.doc.style.css.CSSTypedValue;
import io.sf.carte.doc.style.css.CSSValue;
import io.sf.carte.doc.style.css.property.Evaluator;
import io.sf.carte.doc.style.css.property.StyleValue;
import io.sf.carte.doc.style.css.property.ValueFactory;
import io.sf.carte.doc.style.css.property.ValueList;
import io.sf.carte.echosvg.anim.dom.SVGOMAnimatedRect;
import io.sf.carte.echosvg.bridge.AbstractSVGBridge;
import io.sf.carte.echosvg.bridge.BridgeContext;
import io.sf.carte.echosvg.bridge.BridgeException;
import io.sf.carte.echosvg.bridge.ErrorConstants;
import io.sf.carte.echosvg.dom.svg.LiveAttributeException;
import io.sf.carte.echosvg.dom.svg.SVGOMRect;
import io.sf.carte.echosvg.dom.util.DOMUtilities;
import io.sf.carte.echosvg.parser.AWTTransformProducer;
import io.sf.carte.echosvg.parser.FragmentIdentifierHandler;
import io.sf.carte.echosvg.parser.FragmentIdentifierParser;
import io.sf.carte.echosvg.parser.ParseException;
import io.sf.carte.echosvg.parser.PreserveAspectRatioHandler;
import io.sf.carte.echosvg.parser.PreserveAspectRatioParser;
import io.sf.carte.echosvg.util.SVGConstants;
import java.awt.geom.AffineTransform;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.svg.SVGAnimatedPreserveAspectRatio;
import org.w3c.dom.svg.SVGAnimatedRect;
import org.w3c.dom.svg.SVGPreserveAspectRatio;

public abstract class ViewBox
implements SVGConstants,
ErrorConstants {
    protected ViewBox() {
    }

    public static AffineTransform getViewTransform(String ref, Element e, float w, float h, BridgeContext ctx) {
        boolean meet;
        short align;
        float[] vb;
        if (ref == null || ref.length() == 0) {
            return ViewBox.getPreserveAspectRatioTransform(e, w, h, ctx);
        }
        ViewHandler vh = new ViewHandler();
        FragmentIdentifierParser p = new FragmentIdentifierParser();
        p.setFragmentIdentifierHandler((FragmentIdentifierHandler)vh);
        p.parse(ref);
        Element viewElement = e;
        if (vh.hasId) {
            Document document = e.getOwnerDocument();
            viewElement = document.getElementById(vh.id);
        }
        if (viewElement == null) {
            throw new BridgeException(ctx, e, "uri.malformed", new Object[]{ref});
        }
        Element ancestorSVG = ViewBox.getClosestAncestorSVGElement(e);
        if (!viewElement.getNamespaceURI().equals("http://www.w3.org/2000/svg") || !viewElement.getLocalName().equals("view")) {
            viewElement = ancestorSVG;
        }
        if (vh.hasViewBox) {
            vb = vh.viewBox;
        } else {
            Element elt = DOMUtilities.isAttributeSpecifiedNS((Element)viewElement, null, (String)"viewBox") ? viewElement : ancestorSVG;
            String viewBoxStr = elt.getAttributeNS(null, "viewBox").trim();
            vb = ViewBox.parseViewBoxAttribute(elt, viewBoxStr, ctx);
        }
        if (vh.hasPreserveAspectRatio) {
            align = vh.align;
            meet = vh.meet;
        } else {
            Element elt = DOMUtilities.isAttributeSpecifiedNS((Element)viewElement, null, (String)"preserveAspectRatio") ? viewElement : ancestorSVG;
            String aspectRatio = elt.getAttributeNS(null, "preserveAspectRatio");
            PreserveAspectRatioParser pp = new PreserveAspectRatioParser();
            ViewHandler ph = new ViewHandler();
            pp.setPreserveAspectRatioHandler((PreserveAspectRatioHandler)ph);
            try {
                pp.parse(aspectRatio);
            }
            catch (ParseException pEx) {
                throw new BridgeException(ctx, elt, (Exception)((Object)pEx), "attribute.malformed", new Object[]{"preserveAspectRatio", aspectRatio, pEx});
            }
            align = ph.align;
            meet = ph.meet;
        }
        AffineTransform transform = ViewBox.getPreserveAspectRatioTransform(vb, align, meet, w, h);
        if (vh.hasTransform && transform != null) {
            transform.concatenate(vh.getAffineTransform());
        }
        return transform;
    }

    private static Element getClosestAncestorSVGElement(Element e) {
        for (Node n = e; n != null && n.getNodeType() == 1; n = n.getParentNode()) {
            Element tmp = n;
            if (!tmp.getNamespaceURI().equals("http://www.w3.org/2000/svg") || !tmp.getLocalName().equals("svg")) continue;
            return tmp;
        }
        return null;
    }

    @Deprecated
    public static AffineTransform getPreserveAspectRatioTransform(Element e, float w, float h) {
        return ViewBox.getPreserveAspectRatioTransform(e, w, h, null);
    }

    public static AffineTransform getPreserveAspectRatioTransform(Element e, float w, float h, BridgeContext ctx) throws BridgeException {
        String viewBox = e.getAttributeNS(null, "viewBox");
        String aspectRatio = e.getAttributeNS(null, "preserveAspectRatio");
        return ViewBox.getPreserveAspectRatioTransform(e, viewBox, aspectRatio, w, h, ctx);
    }

    public static AffineTransform getPreserveAspectRatioTransform(Element e, String viewBox, String aspectRatio, float w, float h, BridgeContext ctx) throws BridgeException {
        float[] vb;
        if (viewBox.length() == 0) {
            return new AffineTransform();
        }
        try {
            vb = ViewBox.parseViewBoxAttribute(e, viewBox, ctx);
        }
        catch (BridgeException be) {
            AbstractSVGBridge.displayErrorOrThrow(ctx, be);
            return new AffineTransform();
        }
        PreserveAspectRatioParser p = new PreserveAspectRatioParser();
        ViewHandler ph = new ViewHandler();
        p.setPreserveAspectRatioHandler((PreserveAspectRatioHandler)ph);
        try {
            p.parse(aspectRatio);
        }
        catch (ParseException pEx) {
            BridgeException be = new BridgeException(ctx, e, (Exception)((Object)pEx), "attribute.malformed", new Object[]{"preserveAspectRatio", aspectRatio, pEx});
            AbstractSVGBridge.displayErrorOrThrow(ctx, be);
            return new AffineTransform();
        }
        return ViewBox.getPreserveAspectRatioTransform(vb, ph.align, ph.meet, w, h);
    }

    public static AffineTransform getPreserveAspectRatioTransform(Element e, float[] vb, float w, float h, BridgeContext ctx) throws BridgeException {
        String aspectRatio = e.getAttributeNS(null, "preserveAspectRatio");
        PreserveAspectRatioParser p = new PreserveAspectRatioParser();
        ViewHandler ph = new ViewHandler();
        p.setPreserveAspectRatioHandler((PreserveAspectRatioHandler)ph);
        try {
            p.parse(aspectRatio);
        }
        catch (ParseException pEx) {
            throw new BridgeException(ctx, e, (Exception)((Object)pEx), "attribute.malformed", new Object[]{"preserveAspectRatio", aspectRatio, pEx});
        }
        return ViewBox.getPreserveAspectRatioTransform(vb, ph.align, ph.meet, w, h);
    }

    public static AffineTransform getPreserveAspectRatioTransform(Element e, float[] vb, float w, float h, SVGAnimatedPreserveAspectRatio aPAR, BridgeContext ctx) throws BridgeException {
        try {
            SVGPreserveAspectRatio pAR = aPAR.getAnimVal();
            short align = pAR.getAlign();
            boolean meet = pAR.getMeetOrSlice() == 1;
            return ViewBox.getPreserveAspectRatioTransform(vb, align, meet, w, h);
        }
        catch (LiveAttributeException ex) {
            throw new BridgeException(ctx, ex);
        }
    }

    public static AffineTransform getPreserveAspectRatioTransform(Element e, SVGAnimatedRect aViewBox, SVGAnimatedPreserveAspectRatio aPAR, float w, float h, BridgeContext ctx) throws BridgeException {
        AffineTransform art;
        float[] vb;
        SVGOMAnimatedRect rectVB = (SVGOMAnimatedRect)aViewBox;
        if (!rectVB.isSpecified()) {
            return new AffineTransform();
        }
        try {
            vb = ((SVGOMRect)rectVB.getAnimVal()).toArray();
        }
        catch (LiveAttributeException ex) {
            if (ctx.userAgent == null) {
                throw new BridgeException(ctx, ex);
            }
            ctx.userAgent.displayError((Exception)((Object)ex));
            return new AffineTransform();
        }
        try {
            art = ViewBox.getPreserveAspectRatioTransform(e, vb, w, h, aPAR, ctx);
        }
        catch (BridgeException ex) {
            AbstractSVGBridge.displayErrorOrThrow(ctx, ex);
            art = new AffineTransform();
        }
        return art;
    }

    public static float[] parseViewBoxAttribute(Element e, String value, BridgeContext ctx) throws BridgeException {
        if (value.isEmpty()) {
            return null;
        }
        float[] vb = new float[4];
        ValueFactory factory = new ValueFactory();
        try {
            StyleValue sv = factory.parseProperty(value);
            if (!ViewBox.computeRectangle(sv, vb)) {
                throw new BridgeException(ctx, e, "attribute.malformed", new Object[]{"viewBox", value});
            }
        }
        catch (Exception ex) {
            throw new BridgeException(ctx, e, ex, "attribute.malformed", new Object[]{"viewBox", value, ex});
        }
        if (vb[2] < 0.0f || vb[3] < 0.0f) {
            throw new BridgeException(ctx, e, "attribute.malformed", new Object[]{"viewBox", value});
        }
        if (vb[2] == 0.0f || vb[3] == 0.0f) {
            return null;
        }
        return vb;
    }

    static boolean computeRectangle(StyleValue value, float[] numbers) throws DOMException {
        if (value.getCssValueType() != CSSValue.CssType.LIST) {
            return false;
        }
        ValueList list = (ValueList)value;
        if (list.getLength() != 4) {
            return false;
        }
        for (int i = 0; i < 4; ++i) {
            CSSTypedValue typed;
            StyleValue item = list.item(i);
            if (item.getCssValueType() != CSSValue.CssType.TYPED) {
                return false;
            }
            switch (item.getPrimitiveType()) {
                case NUMERIC: {
                    typed = (CSSTypedValue)item;
                    if (typed.getUnitType() == 0) break;
                    return false;
                }
                case EXPRESSION: {
                    Evaluator eval = new Evaluator(0);
                    typed = eval.evaluateExpression((CSSExpressionValue)item);
                    if (typed.getUnitType() == 0) break;
                    return false;
                }
                default: {
                    return false;
                }
            }
            numbers[i] = typed.getFloatValue((short)0);
        }
        return true;
    }

    public static AffineTransform getPreserveAspectRatioTransform(float[] vb, short align, boolean meet, float w, float h) {
        if (vb == null) {
            return null;
        }
        AffineTransform result = new AffineTransform();
        float vpar = vb[2] / vb[3];
        float svgar = w / h;
        if (align == 1) {
            result.scale(w / vb[2], h / vb[3]);
            result.translate(-vb[0], -vb[1]);
        } else if (vpar < svgar && meet || vpar >= svgar && !meet) {
            float sf = h / vb[3];
            result.scale(sf, sf);
            switch (align) {
                case 2: 
                case 5: 
                case 8: {
                    result.translate(-vb[0], -vb[1]);
                    break;
                }
                case 3: 
                case 6: 
                case 9: {
                    result.translate(-vb[0] - (vb[2] - w * vb[3] / h) / 2.0f, -vb[1]);
                    break;
                }
                default: {
                    result.translate(-vb[0] - (vb[2] - w * vb[3] / h), -vb[1]);
                    break;
                }
            }
        } else {
            float sf = w / vb[2];
            result.scale(sf, sf);
            switch (align) {
                case 2: 
                case 3: 
                case 4: {
                    result.translate(-vb[0], -vb[1]);
                    break;
                }
                case 5: 
                case 6: 
                case 7: {
                    result.translate(-vb[0], -vb[1] - (vb[3] - h * vb[2] / w) / 2.0f);
                    break;
                }
                default: {
                    result.translate(-vb[0], -vb[1] - (vb[3] - h * vb[2] / w));
                }
            }
        }
        return result;
    }

    protected static class ViewHandler
    extends AWTTransformProducer
    implements FragmentIdentifierHandler {
        public boolean hasTransform;
        public boolean hasId;
        public boolean hasViewBox;
        public boolean hasViewTargetParams;
        public boolean hasZoomAndPanParams;
        public String id;
        public float[] viewBox;
        public String viewTargetParams;
        public boolean isMagnify;
        public boolean hasPreserveAspectRatio;
        public short align;
        public boolean meet = true;

        protected ViewHandler() {
        }

        public void endTransformList() throws ParseException {
            super.endTransformList();
            this.hasTransform = true;
        }

        public void startFragmentIdentifier() throws ParseException {
        }

        public void idReference(String s) throws ParseException {
            this.id = s;
            this.hasId = true;
        }

        public void viewBox(float x, float y, float width, float height) throws ParseException {
            this.hasViewBox = true;
            this.viewBox = new float[4];
            this.viewBox[0] = x;
            this.viewBox[1] = y;
            this.viewBox[2] = width;
            this.viewBox[3] = height;
        }

        public void startViewTarget() throws ParseException {
        }

        public void viewTarget(String name) throws ParseException {
            this.viewTargetParams = name;
            this.hasViewTargetParams = true;
        }

        public void endViewTarget() throws ParseException {
        }

        public void zoomAndPan(boolean magnify) {
            this.isMagnify = magnify;
            this.hasZoomAndPanParams = true;
        }

        public void endFragmentIdentifier() throws ParseException {
        }

        public void startPreserveAspectRatio() throws ParseException {
        }

        public void none() throws ParseException {
            this.align = 1;
        }

        public void xMaxYMax() throws ParseException {
            this.align = (short)10;
        }

        public void xMaxYMid() throws ParseException {
            this.align = (short)7;
        }

        public void xMaxYMin() throws ParseException {
            this.align = (short)4;
        }

        public void xMidYMax() throws ParseException {
            this.align = (short)9;
        }

        public void xMidYMid() throws ParseException {
            this.align = (short)6;
        }

        public void xMidYMin() throws ParseException {
            this.align = (short)3;
        }

        public void xMinYMax() throws ParseException {
            this.align = (short)8;
        }

        public void xMinYMid() throws ParseException {
            this.align = (short)5;
        }

        public void xMinYMin() throws ParseException {
            this.align = (short)2;
        }

        public void meet() throws ParseException {
            this.meet = true;
        }

        public void slice() throws ParseException {
            this.meet = false;
        }

        public void endPreserveAspectRatio() throws ParseException {
            this.hasPreserveAspectRatio = true;
        }
    }
}

