/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.echosvg.bridge.svg12;

import io.sf.carte.echosvg.anim.dom.SVGOMDocument;
import io.sf.carte.echosvg.bridge.AnimatableGenericSVGBridge;
import io.sf.carte.echosvg.bridge.BridgeContext;
import io.sf.carte.echosvg.bridge.BridgeException;
import io.sf.carte.echosvg.bridge.CSSUtilities;
import io.sf.carte.echosvg.bridge.PaintBridge;
import io.sf.carte.echosvg.bridge.PaintServer;
import io.sf.carte.echosvg.css.engine.CSSEngine;
import io.sf.carte.echosvg.css.engine.CSSStylableElement;
import io.sf.carte.echosvg.css.engine.StyleMap;
import io.sf.carte.echosvg.css.engine.value.Value;
import io.sf.carte.echosvg.dom.util.XLinkSupport;
import io.sf.carte.echosvg.gvt.GraphicsNode;
import io.sf.carte.echosvg.util.ParsedURL;
import java.awt.Color;
import java.awt.Paint;
import java.util.HashMap;
import org.w3c.dom.Element;

public class SVGSolidColorElementBridge
extends AnimatableGenericSVGBridge
implements PaintBridge {
    @Override
    public String getNamespaceURI() {
        return "http://www.w3.org/2000/svg";
    }

    @Override
    public String getLocalName() {
        return "solidColor";
    }

    @Override
    public Paint createPaint(BridgeContext ctx, Element paintElement, Element paintedElement, GraphicsNode paintedNode, float opacity) {
        opacity = SVGSolidColorElementBridge.extractOpacity(paintElement, opacity, ctx);
        return SVGSolidColorElementBridge.extractColor(paintElement, opacity, ctx);
    }

    protected static float extractOpacity(Element paintElement, float opacity, BridgeContext ctx) {
        String uri;
        HashMap<ParsedURL, ParsedURL> refs = new HashMap<ParsedURL, ParsedURL>();
        CSSEngine eng = CSSUtilities.getCSSEngine(paintElement);
        int pidx = eng.getPropertyIndex("solid-opacity");
        do {
            Value opacityVal = CSSUtilities.getComputedStyle(paintElement, pidx);
            StyleMap sm = ((CSSStylableElement)paintElement).getComputedStyleMap(null);
            if (!sm.isNullCascaded(pidx)) {
                float attr = PaintServer.convertOpacity(opacityVal);
                return opacity * attr;
            }
            uri = XLinkSupport.getXLinkHref((Element)paintElement);
            if (uri.length() == 0) {
                return opacity;
            }
            SVGOMDocument doc = (SVGOMDocument)paintElement.getOwnerDocument();
            ParsedURL purl = new ParsedURL(doc.getURL(), uri);
            if (refs.containsKey(purl)) {
                throw new BridgeException(ctx, paintElement, "xlink.href.circularDependencies", new Object[]{uri});
            }
            refs.put(purl, purl);
        } while ((paintElement = ctx.getReferencedElement(paintElement, uri)) != null);
        return opacity;
    }

    protected static Color extractColor(Element paintElement, float opacity, BridgeContext ctx) {
        String uri;
        HashMap<ParsedURL, ParsedURL> refs = new HashMap<ParsedURL, ParsedURL>();
        CSSEngine eng = CSSUtilities.getCSSEngine(paintElement);
        int pidx = eng.getPropertyIndex("solid-color");
        do {
            Value colorDef = CSSUtilities.getComputedStyle(paintElement, pidx);
            StyleMap sm = ((CSSStylableElement)paintElement).getComputedStyleMap(null);
            if (!sm.isNullCascaded(pidx)) {
                if (colorDef.getCssValueType() == 1) {
                    return PaintServer.convertColor(colorDef, opacity);
                }
                return PaintServer.convertRGBICCColor(paintElement, colorDef.item(0), colorDef.item(1), opacity, ctx);
            }
            uri = XLinkSupport.getXLinkHref((Element)paintElement);
            if (uri.length() == 0) {
                return new Color(0.0f, 0.0f, 0.0f, opacity);
            }
            SVGOMDocument doc = (SVGOMDocument)paintElement.getOwnerDocument();
            ParsedURL purl = new ParsedURL(doc.getURL(), uri);
            if (refs.containsKey(purl)) {
                throw new BridgeException(ctx, paintElement, "xlink.href.circularDependencies", new Object[]{uri});
            }
            refs.put(purl, purl);
        } while ((paintElement = ctx.getReferencedElement(paintElement, uri)) != null);
        return new Color(0.0f, 0.0f, 0.0f, opacity);
    }
}

