/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.echosvg.bridge;

import io.sf.carte.doc.style.css.CSSValue;
import io.sf.carte.echosvg.bridge.Bridge;
import io.sf.carte.echosvg.bridge.BridgeContext;
import io.sf.carte.echosvg.bridge.BridgeException;
import io.sf.carte.echosvg.bridge.CSSUtilities;
import io.sf.carte.echosvg.bridge.ErrorConstants;
import io.sf.carte.echosvg.bridge.MarkerBridge;
import io.sf.carte.echosvg.bridge.PaintBridge;
import io.sf.carte.echosvg.bridge.UserAgent;
import io.sf.carte.echosvg.css.engine.value.ColorFunction;
import io.sf.carte.echosvg.css.engine.value.ColorValue;
import io.sf.carte.echosvg.css.engine.value.NumericValue;
import io.sf.carte.echosvg.css.engine.value.RGBColorValue;
import io.sf.carte.echosvg.css.engine.value.Value;
import io.sf.carte.echosvg.ext.awt.color.ColorContext;
import io.sf.carte.echosvg.ext.awt.color.StandardColorSpaces;
import io.sf.carte.echosvg.gvt.CompositeShapePainter;
import io.sf.carte.echosvg.gvt.FillShapePainter;
import io.sf.carte.echosvg.gvt.GraphicsNode;
import io.sf.carte.echosvg.gvt.Marker;
import io.sf.carte.echosvg.gvt.MarkerShapePainter;
import io.sf.carte.echosvg.gvt.ShapeNode;
import io.sf.carte.echosvg.gvt.ShapePainter;
import io.sf.carte.echosvg.gvt.StrokeShapePainter;
import io.sf.carte.echosvg.util.CSSConstants;
import io.sf.carte.echosvg.util.SVGConstants;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.color.ColorSpace;
import java.awt.color.ICC_ColorSpace;
import org.w3c.css.om.typed.CSSStyleValueList;
import org.w3c.dom.Element;

public abstract class PaintServer
implements SVGConstants,
CSSConstants,
ErrorConstants {
    protected PaintServer() {
    }

    public static ShapePainter convertMarkers(Element e, ShapeNode node, BridgeContext ctx) {
        Value v = CSSUtilities.getComputedStyle(e, 40);
        Marker startMarker = PaintServer.convertMarker(e, v, ctx);
        v = CSSUtilities.getComputedStyle(e, 39);
        Marker midMarker = PaintServer.convertMarker(e, v, ctx);
        v = CSSUtilities.getComputedStyle(e, 38);
        Marker endMarker = PaintServer.convertMarker(e, v, ctx);
        if (startMarker != null || midMarker != null || endMarker != null) {
            MarkerShapePainter p = new MarkerShapePainter(node.getShape());
            p.setStartMarker(startMarker);
            p.setMiddleMarker(midMarker);
            p.setEndMarker(endMarker);
            return p;
        }
        return null;
    }

    public static Marker convertMarker(Element e, Value v, BridgeContext ctx) {
        if (v.getPrimitiveType() == CSSValue.Type.IDENT) {
            return null;
        }
        String uri = v.getURIValue();
        Element markerElement = ctx.getReferencedElement(e, uri);
        if (markerElement == null) {
            return null;
        }
        Bridge bridge = ctx.getBridge(markerElement);
        if (bridge == null) {
            return null;
        }
        if (!(bridge instanceof MarkerBridge)) {
            BridgeException ex = new BridgeException(ctx, e, "css.uri.badTarget", new Object[]{uri});
            UserAgent userAgent = ctx.getUserAgent();
            if (userAgent == null) {
                throw ex;
            }
            userAgent.displayError(ex);
            return null;
        }
        return ((MarkerBridge)bridge).createMarker(ctx, markerElement, e);
    }

    public static ShapePainter convertFillAndStroke(Element e, ShapeNode node, BridgeContext ctx) throws UnsupportedOperationException, IllegalArgumentException {
        Shape shape = node.getShape();
        if (shape == null) {
            return null;
        }
        Paint fillPaint = PaintServer.convertFillPaint(e, (GraphicsNode)node, ctx);
        FillShapePainter fp = new FillShapePainter(shape, (ColorContext)ctx);
        fp.setPaint(fillPaint);
        Stroke stroke = PaintServer.convertStroke(e);
        if (stroke == null) {
            return fp;
        }
        Paint strokePaint = PaintServer.convertStrokePaint(e, (GraphicsNode)node, ctx);
        StrokeShapePainter sp = new StrokeShapePainter(shape, (ColorContext)ctx);
        sp.setStroke(stroke);
        sp.setPaint(strokePaint);
        CompositeShapePainter cp = new CompositeShapePainter(shape);
        cp.addShapePainter((ShapePainter)fp);
        cp.addShapePainter((ShapePainter)sp);
        return cp;
    }

    public static ShapePainter convertStrokePainter(Element e, ShapeNode node, BridgeContext ctx) throws UnsupportedOperationException, IllegalArgumentException {
        Shape shape = node.getShape();
        if (shape == null) {
            return null;
        }
        Stroke stroke = PaintServer.convertStroke(e);
        if (stroke == null) {
            return null;
        }
        Paint strokePaint = PaintServer.convertStrokePaint(e, (GraphicsNode)node, ctx);
        StrokeShapePainter sp = new StrokeShapePainter(shape, (ColorContext)ctx);
        sp.setStroke(stroke);
        sp.setPaint(strokePaint);
        return sp;
    }

    public static Paint convertStrokePaint(Element strokedElement, GraphicsNode strokedNode, BridgeContext ctx) throws UnsupportedOperationException, IllegalArgumentException {
        Value v = CSSUtilities.getComputedStyle(strokedElement, 55);
        float opacity = PaintServer.convertOpacity(v);
        v = CSSUtilities.getComputedStyle(strokedElement, 49);
        return PaintServer.convertPaint(strokedElement, strokedNode, v, opacity, ctx);
    }

    public static Paint convertFillPaint(Element filledElement, GraphicsNode filledNode, BridgeContext ctx) throws UnsupportedOperationException, IllegalArgumentException {
        Value v = CSSUtilities.getComputedStyle(filledElement, 15);
        float opacity = PaintServer.convertOpacity(v);
        v = CSSUtilities.getComputedStyle(filledElement, 14);
        return PaintServer.convertPaint(filledElement, filledNode, v, opacity, ctx);
    }

    public static Paint convertPaint(Element paintedElement, GraphicsNode paintedNode, Value paintDef, float opacity, BridgeContext ctx) throws UnsupportedOperationException, IllegalArgumentException {
        if (paintDef.getCssValueType() == CSSValue.CssType.TYPED) {
            switch (paintDef.getPrimitiveType()) {
                case IDENT: {
                    return null;
                }
                case COLOR: {
                    return PaintServer.convertColor(paintDef.getColorValue(), opacity, ctx);
                }
                case URI: {
                    return PaintServer.convertURIPaint(paintedElement, paintedNode, paintDef, opacity, ctx);
                }
            }
        } else {
            Value v = paintDef.item(0);
            switch (v.getPrimitiveType()) {
                case URI: {
                    Paint result = PaintServer.silentConvertURIPaint(paintedElement, paintedNode, v, opacity, ctx);
                    if (result != null) {
                        return result;
                    }
                    v = paintDef.item(1);
                    switch (v.getPrimitiveType()) {
                        case IDENT: {
                            return null;
                        }
                        case COLOR: {
                            ColorValue color = v.getColorValue();
                            return PaintServer.convertColor(color, opacity, ctx);
                        }
                    }
                }
            }
        }
        throw new IllegalArgumentException("Paint argument is not an appropriate CSS value (" + paintDef.getCssText() + ").");
    }

    public static Paint silentConvertURIPaint(Element paintedElement, GraphicsNode paintedNode, Value paintDef, float opacity, BridgeContext ctx) {
        Paint paint = null;
        try {
            paint = PaintServer.convertURIPaint(paintedElement, paintedNode, paintDef, opacity, ctx);
        }
        catch (BridgeException bridgeException) {
            // empty catch block
        }
        return paint;
    }

    public static Paint convertURIPaint(Element paintedElement, GraphicsNode paintedNode, Value paintDef, float opacity, BridgeContext ctx) throws BridgeException {
        String uri = paintDef.getURIValue();
        Element paintElement = ctx.getReferencedElement(paintedElement, uri);
        if (paintElement == null) {
            return null;
        }
        Bridge bridge = ctx.getBridge(paintElement);
        if (bridge == null) {
            return null;
        }
        if (!(bridge instanceof PaintBridge)) {
            BridgeException ex = new BridgeException(ctx, paintedElement, "css.uri.badTarget", new Object[]{uri});
            UserAgent userAgent = ctx.getUserAgent();
            if (userAgent == null) {
                throw ex;
            }
            userAgent.displayError(ex);
            return null;
        }
        return ((PaintBridge)bridge).createPaint(ctx, paintElement, paintedElement, paintedNode, opacity);
    }

    public static Color convertColor(ColorValue c, float opacity, BridgeContext ctx) throws UnsupportedOperationException, IllegalArgumentException {
        switch (c.getCSSColorSpace()) {
            case "rgb": {
                return PaintServer.convertColor((RGBColorValue)c, opacity);
            }
            case "lab": 
            case "lch": {
                throw new UnsupportedOperationException();
            }
        }
        return PaintServer.convertColor((ColorFunction)c, opacity, ctx);
    }

    public static Color convertColor(RGBColorValue c, float opacity) throws IllegalArgumentException {
        float r = PaintServer.resolveColorComponent(c.getR());
        float g = PaintServer.resolveColorComponent(c.getG());
        float b = PaintServer.resolveColorComponent(c.getB());
        float a = PaintServer.resolveAlphaComponent((Value)c.getAlpha());
        return new Color(r, g, b, a * opacity);
    }

    public static Color convertColor(ColorFunction c, float opacity, BridgeContext ctx) throws UnsupportedOperationException, IllegalArgumentException {
        switch (c.getCSSColorSpace()) {
            case "display-p3": {
                ICC_ColorSpace space = StandardColorSpaces.getDisplayP3();
                Color color = PaintServer.convert3Color(space, c, opacity);
                ctx.updateColorSpace(color, space);
                return color;
            }
            case "a98-rgb": {
                ICC_ColorSpace space = StandardColorSpaces.getA98RGB();
                Color color = PaintServer.convert3Color(space, c, opacity);
                ctx.updateColorSpace(color, space);
                return color;
            }
            case "prophoto-rgb": {
                ICC_ColorSpace space = StandardColorSpaces.getProphotoRGB();
                Color color = PaintServer.convert3Color(space, c, opacity);
                ctx.updateColorSpace(color, space);
                return color;
            }
            case "rec2020": {
                ICC_ColorSpace space = StandardColorSpaces.getRec2020();
                Color color = PaintServer.convert3Color(space, c, opacity);
                ctx.updateColorSpace(color, space);
                return color;
            }
            case "srgb-linear": {
                ColorSpace cs = ColorSpace.getInstance(1004);
                return PaintServer.convert3Color(cs, c, opacity);
            }
            case "srgb": {
                ColorSpace cs = ColorSpace.getInstance(1000);
                return PaintServer.convert3Color(cs, c, opacity);
            }
            case "xyz": 
            case "xyz-d65": {
                CSSStyleValueList chs = c.getChannels();
                float[] ch = new float[]{PaintServer.resolveColorComponent((NumericValue)chs.item(0)), PaintServer.resolveColorComponent((NumericValue)chs.item(1)), PaintServer.resolveColorComponent((NumericValue)chs.item(2))};
                float[] xyzd50 = PaintServer.d65xyzToD50(ch);
                float a = PaintServer.resolveAlphaComponent((Value)c.getAlpha());
                ColorSpace cs = ColorSpace.getInstance(1001);
                Color color = new Color(cs, xyzd50, a * opacity);
                cs = StandardColorSpaces.containerRGBSpace((Color)color, (ColorSpace)ctx.getColorSpace());
                if (cs != null) {
                    ctx.updateColorSpace(color, cs);
                }
                return color;
            }
            case "xyz-d50": {
                ColorSpace cs = ColorSpace.getInstance(1001);
                Color color = PaintServer.convert3Color(cs, c, opacity);
                cs = StandardColorSpaces.containerRGBSpace((Color)color, (ColorSpace)ctx.getColorSpace());
                if (cs != null) {
                    ctx.updateColorSpace(color, cs);
                }
                return color;
            }
        }
        throw new UnsupportedOperationException();
    }

    private static Color convert3Color(ColorSpace space, ColorFunction c, float opacity) throws IllegalArgumentException {
        CSSStyleValueList chs = c.getChannels();
        float[] ch = new float[]{PaintServer.resolveColorComponent((NumericValue)chs.item(0)), PaintServer.resolveColorComponent((NumericValue)chs.item(1)), PaintServer.resolveColorComponent((NumericValue)chs.item(2))};
        float a = PaintServer.resolveAlphaComponent((Value)c.getAlpha());
        return new Color(space, ch, a * opacity);
    }

    private static float resolveColorComponent(NumericValue item) throws IllegalArgumentException {
        switch (item.getUnitType()) {
            case 0: {
                float f = item.getFloatValue();
                if (f < 0.0f) {
                    f = 0.0f;
                } else if (f > 1.0f) {
                    f = 1.0f;
                }
                return f;
            }
            case 2: {
                float f = item.getFloatValue();
                if (f < 0.0f) {
                    f = 0.0f;
                } else if (f > 100.0f) {
                    f = 100.0f;
                }
                return f / 100.0f;
            }
        }
        throw new IllegalArgumentException("Invalid color component: " + item.getCssText());
    }

    private static float[] d65xyzToD50(float[] xyz) {
        float[] xyzadj = new float[]{(float)(1.0478112436606313 * (double)xyz[0] + 0.022886602481693052 * (double)xyz[1] - 0.05012697596852886 * (double)xyz[2]), (float)(0.029542398290574905 * (double)xyz[0] + 0.9904844034904394 * (double)xyz[1] - 0.017049095628961564 * (double)xyz[2]), (float)(-0.009234489723309473 * (double)xyz[0] + 0.015043616793498756 * (double)xyz[1] + 0.7521316354746059 * (double)xyz[2])};
        return xyzadj;
    }

    public static Stroke convertStroke(Element e) {
        Value v = CSSUtilities.getComputedStyle(e, 56);
        float width = v.getFloatValue();
        if (width == 0.0f) {
            return null;
        }
        v = CSSUtilities.getComputedStyle(e, 52);
        int linecap = PaintServer.convertStrokeLinecap(v);
        v = CSSUtilities.getComputedStyle(e, 53);
        int linejoin = PaintServer.convertStrokeLinejoin(v);
        v = CSSUtilities.getComputedStyle(e, 54);
        float miterlimit = PaintServer.convertStrokeMiterlimit(v);
        v = CSSUtilities.getComputedStyle(e, 50);
        float[] dasharray = PaintServer.convertStrokeDasharray(v);
        float dashoffset = 0.0f;
        if (dasharray != null && (dashoffset = (v = CSSUtilities.getComputedStyle(e, 51)).getFloatValue()) < 0.0f) {
            float dashpatternlength = 0.0f;
            for (float aDasharray : dasharray) {
                dashpatternlength += aDasharray;
            }
            if (dasharray.length % 2 != 0) {
                dashpatternlength *= 2.0f;
            }
            if (dashpatternlength == 0.0f) {
                dashoffset = 0.0f;
            } else {
                while (dashoffset < 0.0f) {
                    dashoffset += dashpatternlength;
                }
            }
        }
        return new BasicStroke(width, linecap, linejoin, miterlimit, dasharray, dashoffset);
    }

    public static float[] convertStrokeDasharray(Value v) {
        float[] dasharray = null;
        if (v.getCssValueType() == CSSValue.CssType.LIST) {
            int length = v.getLength();
            dasharray = new float[length];
            float sum = 0.0f;
            for (int i = 0; i < dasharray.length; ++i) {
                dasharray[i] = v.item(i).getFloatValue();
                sum += dasharray[i];
            }
            if (sum == 0.0f) {
                dasharray = null;
            }
        }
        return dasharray;
    }

    public static float convertStrokeMiterlimit(Value v) {
        float miterlimit = v.getFloatValue();
        return miterlimit < 1.0f ? 1.0f : miterlimit;
    }

    public static int convertStrokeLinecap(Value v) throws IllegalArgumentException {
        String s = v.getIdentifierValue();
        switch (s.charAt(0)) {
            case 'b': {
                return 0;
            }
            case 'r': {
                return 1;
            }
            case 's': {
                return 2;
            }
        }
        throw new IllegalArgumentException("Linecap argument is not an appropriate CSS value");
    }

    public static int convertStrokeLinejoin(Value v) throws IllegalArgumentException {
        String s = v.getIdentifierValue();
        switch (s.charAt(0)) {
            case 'm': {
                return 0;
            }
            case 'r': {
                return 1;
            }
            case 'b': {
                return 2;
            }
        }
        throw new IllegalArgumentException("Linejoin argument is not an appropriate CSS value");
    }

    private static float resolveAlphaComponent(Value v) throws IllegalArgumentException {
        switch (v.getUnitType()) {
            case 2: {
                float f = v.getFloatValue();
                f = f > 100.0f ? 100.0f : (f < 0.0f ? 0.0f : f);
                return f / 100.0f;
            }
            case 0: {
                float f = v.getFloatValue();
                f = f > 1.0f ? 1.0f : (f < 0.0f ? 0.0f : f);
                return f;
            }
        }
        throw new IllegalArgumentException("Color alpha argument is not an appropriate CSS value");
    }

    public static float convertOpacity(Value v) {
        float r = v.getFloatValue();
        return r < 0.0f ? 0.0f : (r > 1.0f ? 1.0f : r);
    }
}

