/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.echosvg.bridge;

import io.sf.carte.doc.style.css.CSSValue;
import io.sf.carte.echosvg.anim.dom.SVGOMDocument;
import io.sf.carte.echosvg.bridge.Bridge;
import io.sf.carte.echosvg.bridge.BridgeContext;
import io.sf.carte.echosvg.bridge.BridgeException;
import io.sf.carte.echosvg.bridge.ClipBridge;
import io.sf.carte.echosvg.bridge.ErrorConstants;
import io.sf.carte.echosvg.bridge.FilterBridge;
import io.sf.carte.echosvg.bridge.MaskBridge;
import io.sf.carte.echosvg.bridge.PaintServer;
import io.sf.carte.echosvg.bridge.UserAgent;
import io.sf.carte.echosvg.constants.XMLConstants;
import io.sf.carte.echosvg.css.CSSSecurityException;
import io.sf.carte.echosvg.css.engine.CSSEngine;
import io.sf.carte.echosvg.css.engine.CSSStylableElement;
import io.sf.carte.echosvg.css.engine.value.RectValue;
import io.sf.carte.echosvg.css.engine.value.Value;
import io.sf.carte.echosvg.ext.awt.MultipleGradientPaint;
import io.sf.carte.echosvg.ext.awt.image.renderable.ClipRable;
import io.sf.carte.echosvg.ext.awt.image.renderable.Filter;
import io.sf.carte.echosvg.gvt.CompositeGraphicsNode;
import io.sf.carte.echosvg.gvt.GraphicsNode;
import io.sf.carte.echosvg.gvt.filter.Mask;
import io.sf.carte.echosvg.util.CSSConstants;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Cursor;
import java.awt.RenderingHints;
import java.awt.geom.Rectangle2D;
import org.w3c.dom.Element;

public abstract class CSSUtilities
implements CSSConstants,
ErrorConstants,
XMLConstants {
    public static final Composite TRANSPARENT = AlphaComposite.getInstance(3, 0.0f);

    protected CSSUtilities() {
    }

    public static CSSEngine getCSSEngine(Element e) {
        return ((SVGOMDocument)e.getOwnerDocument()).getCSSEngine();
    }

    public static Value getComputedStyle(Element e, int property) throws CSSSecurityException {
        CSSEngine engine = CSSUtilities.getCSSEngine(e);
        if (engine == null) {
            return null;
        }
        return engine.getComputedStyle((CSSStylableElement)e, null, property);
    }

    public static int convertPointerEvents(Element e) {
        Value v = CSSUtilities.getComputedStyle(e, 44);
        String s = v.getIdentifierValue();
        switch (s.charAt(0)) {
            case 'v': {
                if (s.length() == 7) {
                    return 3;
                }
                switch (s.charAt(7)) {
                    case 'p': {
                        return 0;
                    }
                    case 'f': {
                        return 1;
                    }
                    case 's': {
                        return 2;
                    }
                }
                throw new IllegalStateException("unexpected event, must be one of (p,f,s) is:" + s.charAt(7));
            }
            case 'p': {
                return 4;
            }
            case 'f': {
                return 5;
            }
            case 's': {
                return 6;
            }
            case 'a': {
                return 7;
            }
            case 'n': {
                return 8;
            }
        }
        throw new IllegalStateException("unexpected event, must be one of (v,p,f,s,a,n) is:" + s.charAt(0));
    }

    public static Rectangle2D convertEnableBackground(Element e) {
        Value lv = CSSUtilities.getComputedStyle(e, 13);
        if (lv.getCssValueType() != CSSValue.CssType.LIST) {
            return null;
        }
        int length = lv.getLength();
        switch (length) {
            case 1: {
                return CompositeGraphicsNode.VIEWPORT;
            }
            case 5: {
                float x = lv.item(1).getFloatValue();
                float y = lv.item(2).getFloatValue();
                float w = lv.item(3).getFloatValue();
                float h = lv.item(4).getFloatValue();
                return new Rectangle2D.Float(x, y, w, h);
            }
        }
        throw new IllegalStateException("Unexpected length:" + length);
    }

    public static boolean convertColorInterpolationFilters(Element e) {
        Value v = CSSUtilities.getComputedStyle(e, 7);
        return "linearrgb" == v.getIdentifierValue();
    }

    public static MultipleGradientPaint.ColorSpaceEnum convertColorInterpolation(Element e) {
        Value v = CSSUtilities.getComputedStyle(e, 6);
        return "linearrgb" == v.getIdentifierValue() ? MultipleGradientPaint.LINEAR_RGB : MultipleGradientPaint.SRGB;
    }

    public static boolean isAutoCursor(Element e) {
        Value cursorValue = CSSUtilities.getComputedStyle(e, 9);
        boolean isAuto = false;
        if (cursorValue != null) {
            Value lValue;
            if (cursorValue.getPrimitiveType() == CSSValue.Type.IDENT && cursorValue.getIdentifierValue().charAt(0) == 'a') {
                isAuto = true;
            } else if (cursorValue.getCssValueType() == CSSValue.CssType.LIST && cursorValue.getLength() == 1 && (lValue = cursorValue.item(0)) != null && lValue.getPrimitiveType() == CSSValue.Type.IDENT && lValue.getIdentifierValue().charAt(0) == 'a') {
                isAuto = true;
            }
        }
        return isAuto;
    }

    public static Cursor convertCursor(Element e, BridgeContext ctx) {
        return ctx.getCursorManager().convertCursor(e);
    }

    public static RenderingHints convertShapeRendering(Element e, RenderingHints hints) {
        Value v = CSSUtilities.getComputedStyle(e, 46);
        String s = v.getIdentifierValue();
        int len = s.length();
        if (len == 4 && s.charAt(0) == 'a') {
            return hints;
        }
        if (len < 10) {
            return hints;
        }
        if (hints == null) {
            hints = new RenderingHints(null);
        }
        switch (s.charAt(0)) {
            case 'o': {
                hints.put(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_SPEED);
                hints.put(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
                break;
            }
            case 'c': {
                hints.put(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_DEFAULT);
                hints.put(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
                break;
            }
            case 'g': {
                hints.put(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
                hints.put(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                hints.put(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
            }
        }
        return hints;
    }

    public static RenderingHints convertTextRendering(Element e, RenderingHints hints) {
        Value v = CSSUtilities.getComputedStyle(e, 59);
        String s = v.getIdentifierValue();
        int len = s.length();
        if (len == 4 && s.charAt(0) == 'a') {
            return hints;
        }
        if (len < 13) {
            return hints;
        }
        if (hints == null) {
            hints = new RenderingHints(null);
        }
        switch (s.charAt(8)) {
            case 's': {
                hints.put(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_SPEED);
                hints.put(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
                hints.put(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
                break;
            }
            case 'l': {
                hints.put(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
                hints.put(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
                hints.put(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                break;
            }
            case 'c': {
                hints.put(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
                hints.put(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
                hints.put(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                hints.put(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
                hints.put(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
            }
        }
        return hints;
    }

    public static RenderingHints convertImageRendering(Element e, RenderingHints hints) {
        Value v = CSSUtilities.getComputedStyle(e, 29);
        String s = v.getIdentifierValue();
        int len = s.length();
        if (len == 4 && s.charAt(0) == 'a') {
            return hints;
        }
        if (len < 13) {
            return hints;
        }
        if (hints == null) {
            hints = new RenderingHints(null);
        }
        switch (s.charAt(8)) {
            case 's': {
                hints.put(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_SPEED);
                hints.put(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR);
                break;
            }
            case 'q': {
                hints.put(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
                hints.put(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
            }
        }
        return hints;
    }

    public static RenderingHints convertColorRendering(Element e, RenderingHints hints) {
        Value v = CSSUtilities.getComputedStyle(e, 8);
        String s = v.getIdentifierValue();
        int len = s.length();
        if (len == 4 && s.charAt(0) == 'a') {
            return hints;
        }
        if (len < 13) {
            return hints;
        }
        if (hints == null) {
            hints = new RenderingHints(null);
        }
        switch (s.charAt(8)) {
            case 's': {
                hints.put(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_SPEED);
                hints.put(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_SPEED);
                break;
            }
            case 'q': {
                hints.put(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_QUALITY);
                hints.put(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY);
            }
        }
        return hints;
    }

    public static boolean convertDisplay(Element e) {
        if (!(e instanceof CSSStylableElement)) {
            return true;
        }
        Value v = CSSUtilities.getComputedStyle(e, 11);
        return v.getIdentifierValue().charAt(0) != 'n';
    }

    public static boolean convertVisibility(Element e) {
        Value v = CSSUtilities.getComputedStyle(e, 61);
        return v.getIdentifierValue().charAt(0) == 'v';
    }

    public static Composite convertOpacity(Element e) {
        Value v = CSSUtilities.getComputedStyle(e, 42);
        float f = v.getFloatValue();
        if (f <= 0.0f) {
            return TRANSPARENT;
        }
        if (f >= 1.0f) {
            return AlphaComposite.SrcOver;
        }
        return AlphaComposite.getInstance(3, f);
    }

    public static boolean convertOverflow(Element e) {
        Value v = CSSUtilities.getComputedStyle(e, 43);
        String s = v.getIdentifierValue();
        return s.charAt(0) == 'h' || s.charAt(0) == 's';
    }

    public static float[] convertClip(Element e) {
        Value v = CSSUtilities.getComputedStyle(e, 2);
        switch (v.getPrimitiveType()) {
            case RECT: {
                float[] off = new float[4];
                RectValue rect = v.getRectValue();
                off[0] = rect.getTop().getFloatValue();
                off[1] = rect.getRight().getFloatValue();
                off[2] = rect.getBottom().getFloatValue();
                off[3] = rect.getLeft().getFloatValue();
                return off;
            }
            case IDENT: {
                return null;
            }
        }
        throw new IllegalStateException("Unexpected primitiveType: " + v.getPrimitiveType());
    }

    public static Filter convertFilter(Element filteredElement, GraphicsNode filteredNode, BridgeContext ctx) {
        Value v = CSSUtilities.getComputedStyle(filteredElement, 17);
        CSSValue.Type primitiveType = v.getPrimitiveType();
        switch (primitiveType) {
            case IDENT: {
                return null;
            }
            case URI: {
                String uri = v.getURIValue();
                Element filter = ctx.getReferencedElement(filteredElement, uri);
                if (filter == null) {
                    return null;
                }
                Bridge bridge = ctx.getBridge(filter);
                if (bridge == null) {
                    return null;
                }
                if (!(bridge instanceof FilterBridge)) {
                    BridgeException ex = new BridgeException(ctx, filteredElement, "css.uri.badTarget", new Object[]{uri});
                    UserAgent userAgent = ctx.getUserAgent();
                    if (userAgent == null) {
                        throw ex;
                    }
                    userAgent.displayError(ex);
                    return null;
                }
                return ((FilterBridge)bridge).createFilter(ctx, filter, filteredElement, filteredNode);
            }
        }
        throw new IllegalStateException("Unexpected primitive type:" + primitiveType);
    }

    public static ClipRable convertClipPath(Element clippedElement, GraphicsNode clippedNode, BridgeContext ctx) {
        Value v = CSSUtilities.getComputedStyle(clippedElement, 3);
        CSSValue.Type primitiveType = v.getPrimitiveType();
        switch (primitiveType) {
            case IDENT: {
                return null;
            }
            case URI: {
                String uri = v.getURIValue();
                Element cp = ctx.getReferencedElement(clippedElement, uri);
                if (cp == null) {
                    return null;
                }
                Bridge bridge = ctx.getBridge(cp);
                if (bridge == null) {
                    return null;
                }
                if (!(bridge instanceof ClipBridge)) {
                    BridgeException ex = new BridgeException(ctx, clippedElement, "css.uri.badTarget", new Object[]{uri});
                    UserAgent userAgent = ctx.getUserAgent();
                    if (userAgent == null) {
                        throw ex;
                    }
                    userAgent.displayError(ex);
                    return null;
                }
                return ((ClipBridge)bridge).createClip(ctx, cp, clippedElement, clippedNode);
            }
        }
        throw new IllegalStateException("Unexpected primitive type:" + primitiveType);
    }

    public static int convertClipRule(Element e) {
        Value v = CSSUtilities.getComputedStyle(e, 4);
        return v.getIdentifierValue().charAt(0) == 'n' ? 1 : 0;
    }

    public static Mask convertMask(Element maskedElement, GraphicsNode maskedNode, BridgeContext ctx) {
        Value v = CSSUtilities.getComputedStyle(maskedElement, 41);
        CSSValue.Type primitiveType = v.getPrimitiveType();
        switch (primitiveType) {
            case IDENT: {
                return null;
            }
            case URI: {
                String uri = v.getURIValue();
                Element m = ctx.getReferencedElement(maskedElement, uri);
                if (m == null) {
                    return null;
                }
                Bridge bridge = ctx.getBridge(m);
                if (bridge == null) {
                    return null;
                }
                if (!(bridge instanceof MaskBridge)) {
                    BridgeException ex = new BridgeException(ctx, maskedElement, "css.uri.badTarget", new Object[]{uri});
                    UserAgent userAgent = ctx.getUserAgent();
                    if (userAgent == null) {
                        throw ex;
                    }
                    userAgent.displayError(ex);
                    return null;
                }
                return ((MaskBridge)bridge).createMask(ctx, m, maskedElement, maskedNode);
            }
        }
        throw new IllegalStateException("Unexpected primitive type:" + primitiveType);
    }

    public static int convertFillRule(Element e) {
        Value v = CSSUtilities.getComputedStyle(e, 16);
        return v.getIdentifierValue().charAt(0) == 'n' ? 1 : 0;
    }

    public static Color convertLightingColor(Element e, BridgeContext ctx) {
        Value v = CSSUtilities.getComputedStyle(e, 32);
        return PaintServer.convertColor(v.getColorValue(), 1.0f, ctx);
    }

    public static Color convertFloodColor(Element e, BridgeContext ctx) {
        Value v = CSSUtilities.getComputedStyle(e, 18);
        Value o = CSSUtilities.getComputedStyle(e, 19);
        float f = PaintServer.convertOpacity(o);
        return PaintServer.convertColor(v.getColorValue(), f, ctx);
    }

    public static Color convertStopColor(Element e, float opacity, BridgeContext ctx) {
        Value v = CSSUtilities.getComputedStyle(e, 47);
        Value o = CSSUtilities.getComputedStyle(e, 48);
        return PaintServer.convertColor(v.getColorValue(), opacity *= PaintServer.convertOpacity(o), ctx);
    }

    public static void computeStyleAndURIs(Element refElement, Element localRefElement, String uri) {
        int idx = uri.indexOf(35);
        if (idx != -1) {
            uri = uri.substring(0, idx);
        }
        if (uri.length() != 0) {
            localRefElement.setAttributeNS("http://www.w3.org/XML/1998/namespace", "base", uri);
        }
        CSSEngine engine = CSSUtilities.getCSSEngine(localRefElement);
        CSSEngine refEngine = CSSUtilities.getCSSEngine(refElement);
        engine.importCascadedStyleMaps(refElement, refEngine, localRefElement);
    }

    protected static int rule(Value v) {
        return v.getIdentifierValue().charAt(0) == 'n' ? 1 : 0;
    }
}

