/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.echosvg.ext.awt.image.codec.imageio;

import io.sf.carte.echosvg.ext.awt.image.GraphicsUtil;
import io.sf.carte.echosvg.ext.awt.image.renderable.DeferRable;
import io.sf.carte.echosvg.ext.awt.image.renderable.Filter;
import io.sf.carte.echosvg.ext.awt.image.renderable.RedRable;
import io.sf.carte.echosvg.ext.awt.image.rendered.CachableRed;
import io.sf.carte.echosvg.ext.awt.image.rendered.FormatRed;
import io.sf.carte.echosvg.ext.awt.image.spi.MagicNumberRegistryEntry;
import io.sf.carte.echosvg.util.ParsedURL;
import java.awt.color.ColorSpace;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.DirectColorModel;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;

public abstract class AbstractImageIORegistryEntry
extends MagicNumberRegistryEntry {
    public AbstractImageIORegistryEntry(String name, String[] exts, String[] mimeTypes, MagicNumberRegistryEntry.MagicNumber[] magicNumbers) {
        super(name, 1100.0f, exts, mimeTypes, magicNumbers);
    }

    public AbstractImageIORegistryEntry(String name, String ext, String mimeType, int offset, byte[] magicNumber) {
        super(name, 1100.0f, ext, mimeType, offset, magicNumber);
    }

    public Filter handleStream(InputStream inIS, final ParsedURL origURL, final ColorSpace colorSpace) {
        final DeferRable dr = new DeferRable();
        final InputStream is = inIS;
        Thread t = new Thread(){

            @Override
            public void run() {
                Filter filt;
                try {
                    Iterator<ImageReader> iter = ImageIO.getImageReadersByMIMEType((String)AbstractImageIORegistryEntry.this.getMimeTypes().get(0));
                    if (!iter.hasNext()) {
                        throw new UnsupportedOperationException("No image reader for " + AbstractImageIORegistryEntry.this.getFormatName() + " available!");
                    }
                    ImageReader reader = iter.next();
                    ImageInputStream imageIn = ImageIO.createImageInputStream(is);
                    reader.setInput(imageIn, true);
                    int imageIndex = 0;
                    dr.setBounds((Rectangle2D)new Rectangle2D.Double(0.0, 0.0, reader.getWidth(imageIndex), reader.getHeight(imageIndex)));
                    BufferedImage bi = reader.read(imageIndex);
                    CachableRed cr = GraphicsUtil.wrap((RenderedImage)bi);
                    cr = GraphicsUtil.convertToRGB((CachableRed)cr, (ColorSpace)colorSpace);
                    ColorSpace cs = cr.getColorModel().getColorSpace();
                    ColorModel cm_Unpre = cs.isCS_sRGB() || cs.getType() != 5 ? GraphicsUtil.sRGB_Unpre : new DirectColorModel(cr.getColorModel().getColorSpace(), 32, 0xFF0000, 65280, 255, -16777216, false, 3);
                    cr = new FormatRed(cr, cm_Unpre);
                    WritableRaster wr = (WritableRaster)cr.getData();
                    ColorModel cm = cr.getColorModel();
                    BufferedImage image = new BufferedImage(cm, wr, cm.isAlphaPremultiplied(), null);
                    cr = GraphicsUtil.wrap((RenderedImage)image);
                    filt = new RedRable(cr);
                }
                catch (IOException ioe) {
                    filt = AbstractImageIORegistryEntry.this.getFormatBrokenLinkImage(origURL);
                }
                catch (ThreadDeath td) {
                    Filter filt2 = AbstractImageIORegistryEntry.this.getFormatBrokenLinkImage(origURL);
                    dr.setSource(filt2);
                    throw td;
                }
                catch (Throwable t) {
                    filt = AbstractImageIORegistryEntry.this.getFormatMsgBrokenLinkImage(origURL, t);
                }
                dr.setSource(filt);
            }
        };
        t.start();
        return dr;
    }
}

