/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.echosvg.ext.awt.image.codec.png;

import io.sf.carte.echosvg.ext.awt.image.GraphicsUtil;
import io.sf.carte.echosvg.ext.awt.image.codec.png.PNGDecodeParam;
import io.sf.carte.echosvg.ext.awt.image.codec.png.PNGRed;
import io.sf.carte.echosvg.ext.awt.image.renderable.DeferRable;
import io.sf.carte.echosvg.ext.awt.image.renderable.Filter;
import io.sf.carte.echosvg.ext.awt.image.renderable.RedRable;
import io.sf.carte.echosvg.ext.awt.image.rendered.CachableRed;
import io.sf.carte.echosvg.ext.awt.image.rendered.FormatRed;
import io.sf.carte.echosvg.ext.awt.image.spi.MagicNumberRegistryEntry;
import io.sf.carte.echosvg.util.ParsedURL;
import java.awt.color.ColorSpace;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.DirectColorModel;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.io.IOException;
import java.io.InputStream;

public class PNGRegistryEntry
extends MagicNumberRegistryEntry {
    static final byte[] signature = new byte[]{-119, 80, 78, 71, 13, 10, 26, 10};

    public PNGRegistryEntry() {
        super("PNG", "png", "image/png", 0, signature);
    }

    public Filter handleStream(InputStream inIS, final ParsedURL origURL, final ColorSpace colorSpace) {
        final DeferRable dr = new DeferRable();
        final InputStream is = inIS;
        Thread t = new Thread(){

            @Override
            public void run() {
                Filter filt;
                try {
                    PNGDecodeParam param = new PNGDecodeParam();
                    param.setExpandPalette(true);
                    PNGRed cr = new PNGRed(is, param);
                    dr.setBounds((Rectangle2D)new Rectangle2D.Double(0.0, 0.0, cr.getWidth(), cr.getHeight()));
                    cr = GraphicsUtil.convertToRGB((CachableRed)cr, (ColorSpace)colorSpace);
                    ColorSpace cs = cr.getColorModel().getColorSpace();
                    ColorModel cm_Unpre = cs.isCS_sRGB() || cs.getType() != 5 ? GraphicsUtil.sRGB_Unpre : new DirectColorModel(cs, 32, 0xFF0000, 65280, 255, -16777216, false, 3);
                    cr = new FormatRed((CachableRed)cr, cm_Unpre);
                    WritableRaster wr = (WritableRaster)cr.getData();
                    ColorModel cm = cr.getColorModel();
                    BufferedImage image = new BufferedImage(cm, wr, cm.isAlphaPremultiplied(), null);
                    cr = GraphicsUtil.wrap((RenderedImage)image);
                    filt = new RedRable((CachableRed)cr);
                }
                catch (IOException ioe) {
                    filt = PNGRegistryEntry.this.getFormatBrokenLinkImage(origURL);
                }
                catch (ThreadDeath td) {
                    Filter filt2 = PNGRegistryEntry.this.getFormatBrokenLinkImage(origURL);
                    dr.setSource(filt2);
                    throw td;
                }
                catch (Throwable t) {
                    filt = PNGRegistryEntry.this.getFormatMsgBrokenLinkImage(origURL, t);
                }
                dr.setSource(filt);
            }
        };
        t.start();
        return dr;
    }
}

