/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.echosvg.css.engine.value;

import io.sf.carte.doc.style.css.CSSColor;
import io.sf.carte.doc.style.css.CSSTypedValue;
import io.sf.carte.doc.style.css.CSSValue;
import io.sf.carte.doc.style.css.RGBAColor;
import io.sf.carte.doc.style.css.nsac.CSSParseException;
import io.sf.carte.doc.style.css.nsac.LexicalUnit;
import io.sf.carte.doc.style.css.parser.CSSParser;
import io.sf.carte.doc.style.css.property.NumberValue;
import io.sf.carte.doc.style.css.property.StyleValue;
import io.sf.carte.doc.style.css.property.ValueFactory;
import io.sf.carte.echosvg.css.engine.CSSEngine;
import io.sf.carte.echosvg.css.engine.CSSStylableElement;
import io.sf.carte.echosvg.css.engine.StyleMap;
import io.sf.carte.echosvg.css.engine.value.FloatValue;
import io.sf.carte.echosvg.css.engine.value.IdentifierManager;
import io.sf.carte.echosvg.css.engine.value.Messages;
import io.sf.carte.echosvg.css.engine.value.RGBColorValue;
import io.sf.carte.echosvg.css.engine.value.StringMap;
import io.sf.carte.echosvg.css.engine.value.Value;
import io.sf.carte.echosvg.css.engine.value.ValueConstants;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import org.w3c.dom.DOMException;

public abstract class AbstractColorManager
extends IdentifierManager {
    protected static final StringMap values = new StringMap();
    protected static final StringMap computedValues;

    @Override
    public Value createValue(LexicalUnit lunit, CSSEngine engine) throws DOMException {
        switch (lunit.getLexicalUnitType()) {
            case HSLCOLOR: 
            case HWBCOLOR: 
            case LABCOLOR: 
            case LCHCOLOR: 
            case OKLABCOLOR: 
            case OKLCHCOLOR: 
            case COLOR_FUNCTION: 
            case COLOR_MIX: {
                String rgbSerialization;
                ValueFactory vf = new ValueFactory();
                try {
                    StyleValue css4jValue = vf.createCSSValue(lunit);
                    if (css4jValue.getCssValueType() != CSSValue.CssType.TYPED) {
                        throw this.createInvalidLexicalUnitDOMException(lunit.getLexicalUnitType());
                    }
                    RGBAColor rgb = ((CSSTypedValue)css4jValue).toRGBColor();
                    AbstractColorManager.setComponentsMaximumFractionDigits((CSSColor)rgb, 6);
                    rgbSerialization = rgb.toString();
                }
                catch (DOMException e) {
                    throw this.createInvalidLexicalUnitDOMException(lunit.getLexicalUnitType());
                }
                CSSParser parser = new CSSParser();
                try {
                    lunit = parser.parsePropertyValue((Reader)new StringReader(rgbSerialization));
                }
                catch (CSSParseException | IOException e) {
                    throw this.createInvalidLexicalUnitDOMException(lunit.getLexicalUnitType());
                }
            }
            case RGBCOLOR: {
                Value alpha;
                LexicalUnit lu = lunit.getParameters();
                Value red = this.createColorComponent(lu);
                lu = lu.getNextLexicalUnit();
                if (lu.getLexicalUnitType() == LexicalUnit.LexicalType.OPERATOR_COMMA) {
                    lu = lu.getNextLexicalUnit();
                }
                Value green = this.createColorComponent(lu);
                if ((lu = lu.getNextLexicalUnit()).getLexicalUnitType() == LexicalUnit.LexicalType.OPERATOR_COMMA) {
                    lu = lu.getNextLexicalUnit();
                }
                Value blue = this.createColorComponent(lu);
                if ((lu = lu.getNextLexicalUnit()) != null) {
                    if ((lu.getLexicalUnitType() == LexicalUnit.LexicalType.OPERATOR_COMMA || lu.getLexicalUnitType() == LexicalUnit.LexicalType.OPERATOR_SLASH) && (lu = lu.getNextLexicalUnit()) == null) {
                        throw new DOMException(12, "Invalid color: " + lunit.getCssText());
                    }
                    alpha = this.createColorComponent(lu);
                } else {
                    alpha = null;
                }
                return this.createRGBColor(red, green, blue, alpha);
            }
        }
        return super.createValue(lunit, engine);
    }

    private static void setComponentsMaximumFractionDigits(CSSColor color, int maxFractionDigits) {
        ((NumberValue)color.item(1)).setMaximumFractionDigits(maxFractionDigits);
        ((NumberValue)color.item(2)).setMaximumFractionDigits(maxFractionDigits);
        ((NumberValue)color.item(3)).setMaximumFractionDigits(maxFractionDigits);
    }

    @Override
    public Value computeValue(CSSStylableElement elt, String pseudo, CSSEngine engine, int idx, StyleMap sm, Value value) {
        if (value.getPrimitiveType() == 21) {
            String ident = value.getStringValue();
            Value v = (Value)computedValues.get(ident);
            if (v != null) {
                return v;
            }
            if (values.get(ident) == null) {
                throw new IllegalStateException("Not a system-color:" + ident);
            }
            return engine.getCSSContext().getSystemColor(ident);
        }
        return super.computeValue(elt, pseudo, engine, idx, sm, value);
    }

    protected Value createRGBColor(Value r, Value g, Value b, Value a) {
        return a == null ? new RGBColorValue(r, g, b) : new RGBColorValue(r, g, b, a);
    }

    protected Value createColorComponent(LexicalUnit lu) throws DOMException {
        switch (lu.getLexicalUnitType()) {
            case INTEGER: {
                return new FloatValue(1, lu.getIntegerValue());
            }
            case REAL: {
                return new FloatValue(1, lu.getFloatValue());
            }
            case PERCENTAGE: {
                return new FloatValue(2, lu.getFloatValue());
            }
        }
        throw this.createInvalidRGBComponentUnitDOMException(lu.getLexicalUnitType());
    }

    @Override
    public StringMap getIdentifiers() {
        return values;
    }

    private DOMException createInvalidRGBComponentUnitDOMException(LexicalUnit.LexicalType lexicalType) {
        Object[] p = new Object[]{this.getPropertyName(), lexicalType.toString()};
        String s = Messages.formatMessage("invalid.rgb.component.unit", p);
        return new DOMException(9, s);
    }

    static {
        values.put("aqua", ValueConstants.AQUA_VALUE);
        values.put("black", ValueConstants.BLACK_VALUE);
        values.put("blue", ValueConstants.BLUE_VALUE);
        values.put("fuchsia", ValueConstants.FUCHSIA_VALUE);
        values.put("gray", ValueConstants.GRAY_VALUE);
        values.put("green", ValueConstants.GREEN_VALUE);
        values.put("lime", ValueConstants.LIME_VALUE);
        values.put("maroon", ValueConstants.MAROON_VALUE);
        values.put("navy", ValueConstants.NAVY_VALUE);
        values.put("olive", ValueConstants.OLIVE_VALUE);
        values.put("purple", ValueConstants.PURPLE_VALUE);
        values.put("red", ValueConstants.RED_VALUE);
        values.put("silver", ValueConstants.SILVER_VALUE);
        values.put("teal", ValueConstants.TEAL_VALUE);
        values.put("transparent", ValueConstants.TRANSPARENT_VALUE);
        values.put("white", ValueConstants.WHITE_VALUE);
        values.put("yellow", ValueConstants.YELLOW_VALUE);
        values.put("activeborder", ValueConstants.ACTIVEBORDER_VALUE);
        values.put("activecaption", ValueConstants.ACTIVECAPTION_VALUE);
        values.put("appworkspace", ValueConstants.APPWORKSPACE_VALUE);
        values.put("background", ValueConstants.BACKGROUND_VALUE);
        values.put("buttonface", ValueConstants.BUTTONFACE_VALUE);
        values.put("buttonhighlight", ValueConstants.BUTTONHIGHLIGHT_VALUE);
        values.put("buttonshadow", ValueConstants.BUTTONSHADOW_VALUE);
        values.put("buttontext", ValueConstants.BUTTONTEXT_VALUE);
        values.put("captiontext", ValueConstants.CAPTIONTEXT_VALUE);
        values.put("graytext", ValueConstants.GRAYTEXT_VALUE);
        values.put("highlight", ValueConstants.HIGHLIGHT_VALUE);
        values.put("highlighttext", ValueConstants.HIGHLIGHTTEXT_VALUE);
        values.put("inactiveborder", ValueConstants.INACTIVEBORDER_VALUE);
        values.put("inactivecaption", ValueConstants.INACTIVECAPTION_VALUE);
        values.put("inactivecaptiontext", ValueConstants.INACTIVECAPTIONTEXT_VALUE);
        values.put("infobackground", ValueConstants.INFOBACKGROUND_VALUE);
        values.put("infotext", ValueConstants.INFOTEXT_VALUE);
        values.put("menu", ValueConstants.MENU_VALUE);
        values.put("menutext", ValueConstants.MENUTEXT_VALUE);
        values.put("scrollbar", ValueConstants.SCROLLBAR_VALUE);
        values.put("threeddarkshadow", ValueConstants.THREEDDARKSHADOW_VALUE);
        values.put("threedface", ValueConstants.THREEDFACE_VALUE);
        values.put("threedhighlight", ValueConstants.THREEDHIGHLIGHT_VALUE);
        values.put("threedlightshadow", ValueConstants.THREEDLIGHTSHADOW_VALUE);
        values.put("threedshadow", ValueConstants.THREEDSHADOW_VALUE);
        values.put("window", ValueConstants.WINDOW_VALUE);
        values.put("windowframe", ValueConstants.WINDOWFRAME_VALUE);
        values.put("windowtext", ValueConstants.WINDOWTEXT_VALUE);
        computedValues = new StringMap();
        computedValues.put("black", ValueConstants.BLACK_RGB_VALUE);
        computedValues.put("silver", ValueConstants.SILVER_RGB_VALUE);
        computedValues.put("gray", ValueConstants.GRAY_RGB_VALUE);
        computedValues.put("white", ValueConstants.WHITE_RGB_VALUE);
        computedValues.put("maroon", ValueConstants.MAROON_RGB_VALUE);
        computedValues.put("red", ValueConstants.RED_RGB_VALUE);
        computedValues.put("purple", ValueConstants.PURPLE_RGB_VALUE);
        computedValues.put("fuchsia", ValueConstants.FUCHSIA_RGB_VALUE);
        computedValues.put("green", ValueConstants.GREEN_RGB_VALUE);
        computedValues.put("lime", ValueConstants.LIME_RGB_VALUE);
        computedValues.put("olive", ValueConstants.OLIVE_RGB_VALUE);
        computedValues.put("yellow", ValueConstants.YELLOW_RGB_VALUE);
        computedValues.put("navy", ValueConstants.NAVY_RGB_VALUE);
        computedValues.put("blue", ValueConstants.BLUE_RGB_VALUE);
        computedValues.put("teal", ValueConstants.TEAL_RGB_VALUE);
        computedValues.put("aqua", ValueConstants.AQUA_RGB_VALUE);
        computedValues.put("transparent", ValueConstants.TRANSPARENT_RGB_VALUE);
    }
}

