/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.echosvg.css.engine.value;

import io.sf.carte.echosvg.css.engine.value.AbstractValue;
import io.sf.carte.echosvg.css.engine.value.Value;
import io.sf.carte.echosvg.css.engine.value.svg.SVGValueConstants;
import org.w3c.dom.DOMException;

public class RGBColorValue
extends AbstractValue {
    protected Value red;
    protected Value green;
    protected Value blue;
    protected Value alpha;

    public RGBColorValue(Value r, Value g, Value b) {
        this(r, g, b, SVGValueConstants.NUMBER_1);
    }

    public RGBColorValue(Value r, Value g, Value b, Value a) {
        this.red = r;
        this.green = g;
        this.blue = b;
        this.alpha = a;
    }

    @Override
    public short getPrimitiveType() {
        return 25;
    }

    @Override
    public String getCssText() {
        return RGBColorValue.toString(this.red.getCssText(), this.green.getCssText(), this.blue.getCssText(), this.alpha.getCssText());
    }

    @Override
    public Value getRed() throws DOMException {
        return this.red;
    }

    @Override
    public Value getGreen() throws DOMException {
        return this.green;
    }

    @Override
    public Value getBlue() throws DOMException {
        return this.blue;
    }

    @Override
    public Value getAlpha() throws DOMException {
        return this.alpha;
    }

    public String toString() {
        return this.getCssText();
    }

    public static String toString(String red, String green, String blue, String alpha) {
        if ("1".equals(alpha)) {
            return "rgb(" + red + ", " + green + ", " + blue + ')';
        }
        return "rgba(" + red + ", " + green + ", " + blue + ", " + alpha + ')';
    }
}

