/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.echosvg.css.engine.value;

import io.sf.carte.doc.style.css.nsac.LexicalUnit;
import io.sf.carte.echosvg.css.engine.CSSEngine;
import io.sf.carte.echosvg.css.engine.CSSStylableElement;
import io.sf.carte.echosvg.css.engine.StyleMap;
import io.sf.carte.echosvg.css.engine.value.FloatValue;
import io.sf.carte.echosvg.css.engine.value.LengthManager;
import io.sf.carte.echosvg.css.engine.value.Messages;
import io.sf.carte.echosvg.css.engine.value.RectValue;
import io.sf.carte.echosvg.css.engine.value.Value;
import io.sf.carte.echosvg.css.engine.value.ValueConstants;
import org.w3c.dom.DOMException;

public abstract class RectManager
extends LengthManager {
    protected int orientation;

    @Override
    public Value createValue(LexicalUnit lu, CSSEngine engine) throws DOMException {
        switch (lu.getLexicalUnitType()) {
            case FUNCTION: {
                if (!lu.getFunctionName().equalsIgnoreCase("rect")) break;
            }
            case RECT_FUNCTION: {
                lu = lu.getParameters();
                Value top = this.createRectComponent(lu);
                lu = lu.getNextLexicalUnit();
                if (lu == null || lu.getLexicalUnitType() != LexicalUnit.LexicalType.OPERATOR_COMMA) {
                    throw this.createMalformedRectDOMException();
                }
                lu = lu.getNextLexicalUnit();
                Value right = this.createRectComponent(lu);
                if ((lu = lu.getNextLexicalUnit()) == null || lu.getLexicalUnitType() != LexicalUnit.LexicalType.OPERATOR_COMMA) {
                    throw this.createMalformedRectDOMException();
                }
                lu = lu.getNextLexicalUnit();
                Value bottom = this.createRectComponent(lu);
                if ((lu = lu.getNextLexicalUnit()) == null || lu.getLexicalUnitType() != LexicalUnit.LexicalType.OPERATOR_COMMA) {
                    throw this.createMalformedRectDOMException();
                }
                lu = lu.getNextLexicalUnit();
                Value left = this.createRectComponent(lu);
                return new RectValue(top, right, bottom, left);
            }
        }
        throw this.createMalformedRectDOMException();
    }

    private Value createRectComponent(LexicalUnit lu) throws DOMException {
        switch (lu.getLexicalUnitType()) {
            case IDENT: {
                if (!lu.getStringValue().equalsIgnoreCase("auto")) break;
                return ValueConstants.AUTO_VALUE;
            }
            case DIMENSION: {
                Value value = RectManager.createLength(lu);
                if (value == null) break;
                return value;
            }
            case INTEGER: {
                return new FloatValue(1, lu.getIntegerValue());
            }
            case REAL: {
                return new FloatValue(1, lu.getFloatValue());
            }
            case PERCENTAGE: {
                return new FloatValue(2, lu.getFloatValue());
            }
        }
        throw this.createMalformedRectDOMException();
    }

    @Override
    public Value computeValue(CSSStylableElement elt, String pseudo, CSSEngine engine, int idx, StyleMap sm, Value value) {
        if (value.getCssValueType() != 1) {
            return value;
        }
        if (value.getPrimitiveType() != 24) {
            return value;
        }
        RectValue rect = (RectValue)value;
        this.orientation = 1;
        Value top = super.computeValue(elt, pseudo, engine, idx, sm, rect.getTop());
        Value bottom = super.computeValue(elt, pseudo, engine, idx, sm, rect.getBottom());
        this.orientation = 0;
        Value left = super.computeValue(elt, pseudo, engine, idx, sm, rect.getLeft());
        Value right = super.computeValue(elt, pseudo, engine, idx, sm, rect.getRight());
        if (top != rect.getTop() || right != rect.getRight() || bottom != rect.getBottom() || left != rect.getLeft()) {
            return new RectValue(top, right, bottom, left);
        }
        return value;
    }

    @Override
    protected int getOrientation() {
        return this.orientation;
    }

    private DOMException createMalformedRectDOMException() {
        Object[] p = new Object[]{this.getPropertyName()};
        String s = Messages.formatMessage("malformed.rect", p);
        return new DOMException(12, s);
    }
}

