/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.echosvg.css.engine.value.css2;

import io.sf.carte.doc.style.css.CSSUnit;
import io.sf.carte.doc.style.css.nsac.CSSParseException;
import io.sf.carte.doc.style.css.nsac.LexicalUnit;
import io.sf.carte.doc.style.css.parser.CSSParser;
import io.sf.carte.echosvg.css.engine.CSSEngine;
import io.sf.carte.echosvg.css.engine.value.AbstractValueFactory;
import io.sf.carte.echosvg.css.engine.value.IdentifierManager;
import io.sf.carte.echosvg.css.engine.value.ShorthandManager;
import io.sf.carte.echosvg.css.engine.value.StringMap;
import io.sf.carte.echosvg.css.engine.value.ValueManager;
import io.sf.carte.echosvg.css.engine.value.css2.FontSizeManager;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.HashSet;
import java.util.Set;

public class FontShorthandManager
extends AbstractValueFactory
implements ShorthandManager {
    static LexicalUnit NORMAL_LU;
    static LexicalUnit BOLD_LU;
    static LexicalUnit MEDIUM_LU;
    static LexicalUnit SZ_10PT_LU;
    static LexicalUnit SZ_8PT_LU;
    static LexicalUnit FONT_FAMILY_LU;
    protected static final Set<String> values;

    @Override
    public String getPropertyName() {
        return "font";
    }

    @Override
    public boolean isAnimatableProperty() {
        return true;
    }

    @Override
    public boolean isAdditiveProperty() {
        return false;
    }

    public void handleSystemFont(CSSEngine eng, ShorthandManager.PropertyHandler ph, String s, boolean imp) {
        LexicalUnit fontStyle = NORMAL_LU;
        LexicalUnit fontVariant = NORMAL_LU;
        LexicalUnit fontWeight = NORMAL_LU;
        LexicalUnit lineHeight = NORMAL_LU;
        LexicalUnit fontFamily = FONT_FAMILY_LU;
        LexicalUnit fontSize = s.equals("small-caption") ? SZ_8PT_LU : SZ_10PT_LU;
        ph.property("font-family", fontFamily, imp);
        ph.property("font-style", fontStyle, imp);
        ph.property("font-variant", fontVariant, imp);
        ph.property("font-weight", fontWeight, imp);
        ph.property("font-size", fontSize, imp);
        ph.property("line-height", lineHeight, imp);
    }

    @Override
    public void setValues(CSSEngine eng, ShorthandManager.PropertyHandler ph, LexicalUnit lu, boolean imp) {
        String s;
        switch (lu.getLexicalUnitType()) {
            case INHERIT: {
                return;
            }
            case IDENT: {
                String s2 = lu.getStringValue().toLowerCase();
                if (!values.contains(s2)) break;
                this.handleSystemFont(eng, ph, s2, imp);
                return;
            }
        }
        LexicalUnit fontStyle = null;
        LexicalUnit fontVariant = null;
        LexicalUnit fontWeight = null;
        LexicalUnit fontSize = null;
        LexicalUnit lineHeight = null;
        LexicalUnit fontFamily = null;
        ValueManager[] vMgrs = eng.getValueManagers();
        int fst = eng.getPropertyIndex("font-style");
        int fv = eng.getPropertyIndex("font-variant");
        int fw = eng.getPropertyIndex("font-weight");
        int fsz = eng.getPropertyIndex("font-size");
        int lh = eng.getPropertyIndex("line-height");
        IdentifierManager fstVM = (IdentifierManager)vMgrs[fst];
        IdentifierManager fvVM = (IdentifierManager)vMgrs[fv];
        IdentifierManager fwVM = (IdentifierManager)vMgrs[fw];
        FontSizeManager fszVM = (FontSizeManager)vMgrs[fsz];
        StringMap fstSM = fstVM.getIdentifiers();
        StringMap fvSM = fvVM.getIdentifiers();
        StringMap fwSM = fwVM.getIdentifiers();
        StringMap fszSM = fszVM.getIdentifiers();
        boolean svwDone = false;
        LexicalUnit intLU = null;
        while (!svwDone && lu != null) {
            switch (lu.getLexicalUnitType()) {
                case IDENT: {
                    s = lu.getStringValue().toLowerCase().intern();
                    if (fontStyle == null && fstSM.get(s) != null) {
                        fontStyle = lu;
                        if (intLU == null) break;
                        if (fontWeight == null) {
                            fontWeight = intLU;
                            intLU = null;
                            break;
                        }
                        throw this.createInvalidLexicalUnitDOMException(intLU.getLexicalUnitType());
                    }
                    if (fontVariant == null && fvSM.get(s) != null) {
                        fontVariant = lu;
                        if (intLU == null) break;
                        if (fontWeight == null) {
                            fontWeight = intLU;
                            intLU = null;
                            break;
                        }
                        throw this.createInvalidLexicalUnitDOMException(intLU.getLexicalUnitType());
                    }
                    if (intLU == null && fontWeight == null && fwSM.get(s) != null) {
                        fontWeight = lu;
                        break;
                    }
                    svwDone = true;
                    break;
                }
                case INTEGER: {
                    if (intLU == null && fontWeight == null) {
                        intLU = lu;
                        break;
                    }
                    svwDone = true;
                    break;
                }
                default: {
                    svwDone = true;
                }
            }
            if (svwDone) continue;
            lu = lu.getNextLexicalUnit();
        }
        if (lu == null) {
            throw this.createMalformedLexicalUnitDOMException();
        }
        switch (lu.getLexicalUnitType()) {
            case IDENT: {
                s = lu.getStringValue().toLowerCase().intern();
                if (fszSM.get(s) == null) break;
                fontSize = lu;
                lu = lu.getNextLexicalUnit();
                break;
            }
            case DIMENSION: {
                if (!CSSUnit.isLengthUnitType((short)lu.getCssUnit())) {
                    throw this.createInvalidLexicalUnitDOMException(lu.getLexicalUnitType());
                }
            }
            case INTEGER: 
            case REAL: 
            case PERCENTAGE: {
                fontSize = lu;
                lu = lu.getNextLexicalUnit();
                break;
            }
        }
        if (fontSize == null) {
            if (intLU != null) {
                fontSize = intLU;
                intLU = null;
            } else {
                throw this.createInvalidLexicalUnitDOMException(lu.getLexicalUnitType());
            }
        }
        if (intLU != null) {
            if (fontWeight == null) {
                fontWeight = intLU;
            } else {
                throw this.createInvalidLexicalUnitDOMException(intLU.getLexicalUnitType());
            }
        }
        if (lu == null) {
            throw this.createMalformedLexicalUnitDOMException();
        }
        switch (lu.getLexicalUnitType()) {
            case OPERATOR_SLASH: {
                lu = lu.getNextLexicalUnit();
                if (lu == null) {
                    throw this.createMalformedLexicalUnitDOMException();
                }
                lineHeight = lu;
                lu = lu.getNextLexicalUnit();
                break;
            }
        }
        if (lu == null) {
            throw this.createMalformedLexicalUnitDOMException();
        }
        fontFamily = lu;
        if (fontStyle == null) {
            fontStyle = NORMAL_LU;
        }
        if (fontVariant == null) {
            fontVariant = NORMAL_LU;
        }
        if (fontWeight == null) {
            fontWeight = NORMAL_LU;
        }
        if (lineHeight == null) {
            lineHeight = NORMAL_LU;
        }
        ph.property("font-family", fontFamily, imp);
        ph.property("font-style", fontStyle, imp);
        ph.property("font-variant", fontVariant, imp);
        ph.property("font-weight", fontWeight, imp);
        ph.property("font-size", fontSize, imp);
        if (lh != -1) {
            ph.property("line-height", lineHeight, imp);
        }
    }

    static {
        CSSParser parser = new CSSParser();
        try {
            NORMAL_LU = parser.parsePropertyValue((Reader)new StringReader("normal"));
            BOLD_LU = parser.parsePropertyValue((Reader)new StringReader("bold"));
            MEDIUM_LU = parser.parsePropertyValue((Reader)new StringReader("medium"));
            SZ_10PT_LU = parser.parsePropertyValue((Reader)new StringReader("10pt"));
            SZ_8PT_LU = parser.parsePropertyValue((Reader)new StringReader("8pt"));
            FONT_FAMILY_LU = parser.parsePropertyValue((Reader)new StringReader("\"Dialog\",\"Helvetica\",sans-serif"));
        }
        catch (CSSParseException | IOException throwable) {
            // empty catch block
        }
        values = new HashSet<String>();
        values.add("caption");
        values.add("icon");
        values.add("menu");
        values.add("message-box");
        values.add("small-caption");
        values.add("status-bar");
    }
}

