/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.echosvg.css.engine.value.css2;

import io.sf.carte.doc.style.css.nsac.LexicalUnit;
import io.sf.carte.echosvg.css.engine.CSSEngine;
import io.sf.carte.echosvg.css.engine.value.IdentifierManager;
import io.sf.carte.echosvg.css.engine.value.ListValue;
import io.sf.carte.echosvg.css.engine.value.StringMap;
import io.sf.carte.echosvg.css.engine.value.StringValue;
import io.sf.carte.echosvg.css.engine.value.URIValue;
import io.sf.carte.echosvg.css.engine.value.Value;
import io.sf.carte.echosvg.css.engine.value.ValueConstants;
import org.w3c.dom.DOMException;

public class SrcManager
extends IdentifierManager {
    protected static final StringMap values = new StringMap();

    @Override
    public boolean isInheritedProperty() {
        return false;
    }

    @Override
    public boolean isAnimatableProperty() {
        return false;
    }

    @Override
    public boolean isAdditiveProperty() {
        return false;
    }

    @Override
    public int getPropertyType() {
        return 38;
    }

    @Override
    public String getPropertyName() {
        return "src";
    }

    @Override
    public Value getDefaultValue() {
        return ValueConstants.NONE_VALUE;
    }

    @Override
    public Value createValue(LexicalUnit lu, CSSEngine engine) throws DOMException {
        switch (lu.getLexicalUnitType()) {
            case INHERIT: {
                return ValueConstants.INHERIT_VALUE;
            }
            default: {
                throw this.createInvalidLexicalUnitDOMException(lu.getLexicalUnitType());
            }
            case IDENT: 
            case STRING: 
            case URI: 
        }
        ListValue result = new ListValue();
        do {
            switch (lu.getLexicalUnitType()) {
                case STRING: {
                    result.append(new StringValue(19, lu.getStringValue()));
                    lu = lu.getNextLexicalUnit();
                    break;
                }
                case URI: {
                    String uri = SrcManager.resolveURI(engine.getCSSBaseURI(), lu.getStringValue());
                    result.append(new URIValue(lu.getStringValue(), uri));
                    lu = lu.getNextLexicalUnit();
                    if (lu == null || lu.getLexicalUnitType() != LexicalUnit.LexicalType.FUNCTION || !lu.getFunctionName().equalsIgnoreCase("format")) break;
                    lu = lu.getNextLexicalUnit();
                    break;
                }
                case IDENT: {
                    StringBuilder sb = new StringBuilder(lu.getStringValue());
                    lu = lu.getNextLexicalUnit();
                    if (lu != null && lu.getLexicalUnitType() == LexicalUnit.LexicalType.IDENT) {
                        do {
                            sb.append(' ');
                            sb.append(lu.getStringValue());
                        } while ((lu = lu.getNextLexicalUnit()) != null && lu.getLexicalUnitType() == LexicalUnit.LexicalType.IDENT);
                        result.append(new StringValue(19, sb.toString()));
                        break;
                    }
                    String id = sb.toString();
                    String s = id.toLowerCase().intern();
                    Value v = (Value)values.get(s);
                    result.append(v != null ? v : new StringValue(19, id));
                    break;
                }
            }
            if (lu == null) {
                return result;
            }
            if (lu.getLexicalUnitType() == LexicalUnit.LexicalType.OPERATOR_COMMA) continue;
            throw this.createInvalidLexicalUnitDOMException(lu.getLexicalUnitType());
        } while ((lu = lu.getNextLexicalUnit()) != null);
        throw this.createMalformedLexicalUnitDOMException();
    }

    @Override
    public StringMap getIdentifiers() {
        return values;
    }

    static {
        values.put("none", ValueConstants.NONE_VALUE);
    }
}

