/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.echosvg.css.engine.value.svg;

import io.sf.carte.doc.style.css.nsac.LexicalUnit;
import io.sf.carte.echosvg.css.engine.CSSEngine;
import io.sf.carte.echosvg.css.engine.value.AbstractValueManager;
import io.sf.carte.echosvg.css.engine.value.StringValue;
import io.sf.carte.echosvg.css.engine.value.URIValue;
import io.sf.carte.echosvg.css.engine.value.Value;
import io.sf.carte.echosvg.css.engine.value.ValueConstants;
import io.sf.carte.echosvg.css.engine.value.svg.SVGValueConstants;
import org.w3c.dom.DOMException;

public class ColorProfileManager
extends AbstractValueManager {
    @Override
    public boolean isInheritedProperty() {
        return true;
    }

    @Override
    public String getPropertyName() {
        return "color-profile";
    }

    @Override
    public boolean isAnimatableProperty() {
        return true;
    }

    @Override
    public boolean isAdditiveProperty() {
        return false;
    }

    @Override
    public int getPropertyType() {
        return 20;
    }

    @Override
    public Value getDefaultValue() {
        return ValueConstants.AUTO_VALUE;
    }

    @Override
    public Value createValue(LexicalUnit lu, CSSEngine engine) throws DOMException {
        switch (lu.getLexicalUnitType()) {
            case INHERIT: {
                return ValueConstants.INHERIT_VALUE;
            }
            case IDENT: {
                String s = lu.getStringValue().toLowerCase();
                if (s.equals("auto")) {
                    return ValueConstants.AUTO_VALUE;
                }
                if (s.equals("srgb")) {
                    return SVGValueConstants.SRGB_VALUE;
                }
                return new StringValue(21, s);
            }
            case URI: {
                return new URIValue(lu.getStringValue(), ColorProfileManager.resolveURI(engine.getCSSBaseURI(), lu.getStringValue()));
            }
        }
        throw this.createInvalidLexicalUnitDOMException(lu.getLexicalUnitType());
    }

    @Override
    public Value createStringValue(short type, String value, CSSEngine engine) throws DOMException {
        switch (type) {
            case 21: {
                String s = value.toLowerCase();
                if (s.equals("auto")) {
                    return ValueConstants.AUTO_VALUE;
                }
                if (s.equals("srgb")) {
                    return SVGValueConstants.SRGB_VALUE;
                }
                return new StringValue(21, s);
            }
            case 20: {
                return new URIValue(value, ColorProfileManager.resolveURI(engine.getCSSBaseURI(), value));
            }
        }
        throw this.createInvalidStringTypeDOMException(type);
    }
}

