/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.echosvg.css.engine.value.svg;

import io.sf.carte.doc.style.css.nsac.LexicalUnit;
import io.sf.carte.echosvg.css.engine.CSSEngine;
import io.sf.carte.echosvg.css.engine.value.AbstractValueManager;
import io.sf.carte.echosvg.css.engine.value.FloatValue;
import io.sf.carte.echosvg.css.engine.value.Value;
import io.sf.carte.echosvg.css.engine.value.ValueConstants;
import org.w3c.dom.DOMException;

public abstract class GlyphOrientationManager
extends AbstractValueManager {
    @Override
    public boolean isInheritedProperty() {
        return true;
    }

    @Override
    public boolean isAnimatableProperty() {
        return false;
    }

    @Override
    public boolean isAdditiveProperty() {
        return false;
    }

    @Override
    public int getPropertyType() {
        return 5;
    }

    @Override
    public Value createValue(LexicalUnit lu, CSSEngine engine) throws DOMException {
        switch (lu.getLexicalUnitType()) {
            case INHERIT: {
                return ValueConstants.INHERIT_VALUE;
            }
            case DIMENSION: {
                switch (lu.getCssUnit()) {
                    case 80: {
                        return new FloatValue(11, lu.getFloatValue());
                    }
                    case 81: {
                        return new FloatValue(12, lu.getFloatValue());
                    }
                    case 82: {
                        return new FloatValue(13, lu.getFloatValue());
                    }
                    case 83: {
                        return new FloatValue(11, lu.getFloatValue() * 360.0f);
                    }
                }
            }
            case INTEGER: {
                int n = lu.getIntegerValue();
                return new FloatValue(11, n);
            }
            case REAL: {
                float n = lu.getFloatValue();
                return new FloatValue(11, n);
            }
        }
        throw this.createInvalidLexicalUnitDOMException(lu.getLexicalUnitType());
    }

    @Override
    public Value createFloatValue(short type, float floatValue) throws DOMException {
        switch (type) {
            case 11: 
            case 12: 
            case 13: {
                return new FloatValue(type, floatValue);
            }
        }
        throw this.createInvalidFloatValueDOMException(floatValue);
    }
}

