/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.echosvg.css.engine.value;

import io.sf.carte.doc.style.css.CSSColor;
import io.sf.carte.doc.style.css.CSSColorValue;
import io.sf.carte.doc.style.css.CSSNumberValue;
import io.sf.carte.doc.style.css.CSSPrimitiveValue;
import io.sf.carte.doc.style.css.CSSTypedValue;
import io.sf.carte.doc.style.css.CSSValue;
import io.sf.carte.doc.style.css.RGBAColor;
import io.sf.carte.doc.style.css.nsac.CSSParseException;
import io.sf.carte.doc.style.css.nsac.LexicalUnit;
import io.sf.carte.doc.style.css.parser.CSSParser;
import io.sf.carte.doc.style.css.property.CSSLexicalProcessingException;
import io.sf.carte.doc.style.css.property.Evaluator;
import io.sf.carte.doc.style.css.property.PercentageEvaluator;
import io.sf.carte.doc.style.css.property.PrimitiveValue;
import io.sf.carte.doc.style.css.property.StyleValue;
import io.sf.carte.doc.style.css.property.ValueFactory;
import io.sf.carte.echosvg.css.engine.CSSEngine;
import io.sf.carte.echosvg.css.engine.CSSStylableElement;
import io.sf.carte.echosvg.css.engine.StyleMap;
import io.sf.carte.echosvg.css.engine.value.AbstractValueList;
import io.sf.carte.echosvg.css.engine.value.CSSProxyValueException;
import io.sf.carte.echosvg.css.engine.value.CalcValue;
import io.sf.carte.echosvg.css.engine.value.ColorFunction;
import io.sf.carte.echosvg.css.engine.value.ColorValue;
import io.sf.carte.echosvg.css.engine.value.FloatValue;
import io.sf.carte.echosvg.css.engine.value.IdentifierManager;
import io.sf.carte.echosvg.css.engine.value.MathFunctionValue;
import io.sf.carte.echosvg.css.engine.value.Messages;
import io.sf.carte.echosvg.css.engine.value.NumericDelegateValue;
import io.sf.carte.echosvg.css.engine.value.NumericValue;
import io.sf.carte.echosvg.css.engine.value.PendingStyleValue;
import io.sf.carte.echosvg.css.engine.value.RGBColorValue;
import io.sf.carte.echosvg.css.engine.value.StringMap;
import io.sf.carte.echosvg.css.engine.value.Value;
import io.sf.carte.echosvg.css.engine.value.ValueConstants;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.Locale;
import org.w3c.dom.DOMException;

public abstract class AbstractColorManager
extends IdentifierManager {
    protected static final StringMap<Value> values = new StringMap(50);
    protected static final StringMap<ColorValue> computedValues;

    @Override
    public Value createValue(LexicalUnit lunit, CSSEngine engine) throws DOMException {
        return this.createValue(lunit, null, null, engine, -1, null);
    }

    private Value createValue(LexicalUnit lunit, CSSStylableElement elt, String pseudo, CSSEngine engine, int idx, StyleMap sm) throws DOMException {
        switch (lunit.getLexicalUnitType()) {
            case LABCOLOR: 
            case LCHCOLOR: 
            case OKLABCOLOR: 
            case OKLCHCOLOR: 
            case COLOR_MIX: {
                double[] comps;
                PrimitiveValue css4jValue;
                ValueFactory vf = new ValueFactory();
                try {
                    css4jValue = vf.createCSSPrimitiveValue(lunit);
                }
                catch (DOMException e) {
                    String msg = e.getMessage();
                    if (msg == null || !msg.contains("currentColor")) {
                        throw e;
                    }
                    if (sm == null) {
                        return new PendingStyleValue(lunit);
                    }
                    LexicalUnit replUnit = this.replaceCurrentColor(lunit.shallowClone(), elt, pseudo, engine, idx, sm);
                    css4jValue = vf.createCSSPrimitiveValue(replUnit);
                }
                CSSValue.CssType cssType = css4jValue.getCssValueType();
                if (cssType != CSSValue.CssType.TYPED) {
                    if (cssType == CSSValue.CssType.PROXY) {
                        return this.createLexicalValue(lunit);
                    }
                    throw this.createInvalidLexicalUnitDOMException(lunit.getLexicalUnitType());
                }
                CSSColor color = ((CSSColorValue)css4jValue).getColor();
                if (color.isInGamut("srgb")) {
                    color = color.toColorSpace("srgb");
                    comps = color.toNumberArray();
                    float[] fcomps = new float[]{(float)comps[0], (float)comps[1], (float)comps[2], AbstractColorManager.normalizedComponent(color.getAlpha())};
                    return new RGBColorValue(fcomps);
                }
                color = color.isInGamut("display-p3") ? color.toColorSpace("display-p3") : (color.isInGamut("a98-rgb") ? color.toColorSpace("a98-rgb") : (color.isInGamut("rec2020") ? color.toColorSpace("rec2020") : color.toColorSpace("prophoto-rgb")));
                comps = color.toNumberArray();
                int len = comps.length;
                AbstractValueList<NumericValue> components = new AbstractValueList<NumericValue>(' ', len);
                for (int i = 0; i < len; ++i) {
                    components.add(new FloatValue(0, (float)comps[i]));
                }
                ColorFunction cfunc = new ColorFunction(color.getColorSpace(), components);
                float fAlpha = AbstractColorManager.normalizedComponent(color.getAlpha());
                cfunc.setAlpha(fAlpha);
                return cfunc;
            }
            case COLOR_FUNCTION: {
                return this.createColorFunction(lunit, elt, pseudo, engine, idx, sm);
            }
            case HSLCOLOR: 
            case HWBCOLOR: {
                ValueFactory vf = new ValueFactory();
                StyleValue css4jValue = vf.createCSSValue(lunit);
                CSSValue.CssType cssType = css4jValue.getCssValueType();
                if (cssType != CSSValue.CssType.TYPED) {
                    if (cssType == CSSValue.CssType.PROXY) {
                        return this.createLexicalValue(lunit);
                    }
                    throw this.createInvalidLexicalUnitDOMException(lunit.getLexicalUnitType());
                }
                RGBAColor rgb = ((CSSTypedValue)css4jValue).toRGBColor();
                double[] drgb = rgb.toNumberArray();
                float[] frgb = new float[]{(float)drgb[0], (float)drgb[1], (float)drgb[2], AbstractColorManager.normalizedComponent(rgb.getAlpha())};
                return new RGBColorValue(frgb);
            }
            case RGBCOLOR: {
                return this.createRGBColor(lunit, elt, pseudo, engine, idx, sm);
            }
            case IDENT: {
                String sv = lunit.getStringValue();
                sv = sv.toLowerCase(Locale.ROOT).intern();
                try {
                    return this.createIdentValue(sv, engine).clone();
                }
                catch (DOMException e) {
                    if ("currentcolor" == sv) {
                        if (sm == null) {
                            return new PendingStyleValue(lunit);
                        }
                        return AbstractColorManager.computeCurrentColor(elt, pseudo, engine, idx, sm);
                    }
                    throw e;
                }
            }
        }
        return super.createValue(lunit, engine);
    }

    private LexicalUnit replaceCurrentColor(LexicalUnit lunit, CSSStylableElement elt, String pseudo, CSSEngine engine, int idx, StyleMap sm) throws DOMException {
        CSSParser parser = new CSSParser();
        switch (lunit.getLexicalUnitType()) {
            case IDENT: {
                LexicalUnit replUnit;
                if (!"currentcolor".equalsIgnoreCase(lunit.getStringValue())) break;
                Value cc = AbstractColorManager.computeCurrentColor(elt, pseudo, engine, idx, sm);
                String text = cc.getCssText();
                try {
                    replUnit = parser.parsePropertyValue((Reader)new StringReader(text));
                }
                catch (CSSParseException | IOException e) {
                    DOMException ex = new DOMException(12, "Invalid color: " + text);
                    ex.initCause(e);
                    throw ex;
                }
                if (lunit.isParameter()) {
                    lunit.countReplaceBy(replUnit);
                }
                lunit = replUnit;
                break;
            }
            case VAR: 
            case ATTR: {
                throw new CSSLexicalProcessingException();
            }
            default: {
                LexicalUnit param = lunit.getParameters();
                if (param != null) {
                    do {
                        this.replaceCurrentColor(param, elt, pseudo, engine, idx, sm);
                    } while ((param = param.getNextLexicalUnit()) != null);
                    break;
                }
                throw new DOMException(12, "Invalid color: " + lunit.getCssText());
            }
        }
        return lunit;
    }

    private static Value computeCurrentColor(CSSStylableElement elt, String pseudo, CSSEngine engine, int idx, StyleMap sm) {
        sm.putColorRelative(idx, true);
        int colorIdx = engine.getColorIndex();
        Value ccv = sm.getValue(colorIdx);
        if (ccv == null) {
            ccv = engine.getComputedStyle(elt, pseudo, colorIdx);
        }
        return ccv;
    }

    @Override
    public Value computeValue(CSSStylableElement elt, String pseudo, CSSEngine engine, int idx, StyleMap sm, Value value) {
        switch (value.getPrimitiveType()) {
            case IDENT: {
                String ident = value.getIdentifierValue();
                Value v = computedValues.get(ident);
                if (v != null) {
                    return v;
                }
                if (values.get(ident) == null) {
                    throw new IllegalStateException("Not a system-color:" + ident);
                }
                return engine.getCSSContext().getSystemColor(ident);
            }
            case UNKNOWN: {
                LexicalUnit lunit = ((PendingStyleValue)value).getLexicalUnit();
                return this.createValue(lunit, elt, pseudo, engine, idx, sm);
            }
        }
        return super.computeValue(elt, pseudo, engine, idx, sm, value);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Value createRGBColor(LexicalUnit lunit, CSSStylableElement elt, String pseudo, CSSEngine engine, int idx, StyleMap sm) {
        LexicalUnit lu = lunit.getParameters();
        ColorValue from = null;
        boolean alphaPcntSpecified = false;
        try {
            NumericValue alpha;
            if (lu.getLexicalUnitType() == LexicalUnit.LexicalType.IDENT && "from".equalsIgnoreCase(lu.getStringValue())) {
                LexicalUnit colorUnit = (lu = AbstractColorManager.nextLexicalUnitNonNull(lu, lunit)).shallowClone();
                Value fromval = this.createValue(colorUnit, elt, pseudo, engine, idx, sm);
                CSSValue.Type pType = fromval.getPrimitiveType();
                if (pType != CSSValue.Type.COLOR) {
                    if (pType == CSSValue.Type.LEXICAL) {
                        return this.createLexicalValue(lunit);
                    }
                    if (pType == CSSValue.Type.IDENT) {
                        String name = fromval.getStringValue().toLowerCase(Locale.ROOT);
                        ColorValue v = computedValues.get(name);
                        if (v != null) {
                            fromval = v;
                        } else {
                            fromval = values.get(name);
                            if (fromval == null) {
                                if (!"currentcolor".equals(name)) throw AbstractColorManager.createDOMSyntaxException(lunit);
                                if (sm == null) {
                                    return new PendingStyleValue(lunit);
                                }
                                fromval = AbstractColorManager.computeCurrentColor(elt, pseudo, engine, idx, sm);
                            } else {
                                name = fromval.getStringValue();
                                fromval = engine.getCSSContext().getSystemColor(name);
                            }
                        }
                    } else {
                        if (pType != CSSValue.Type.UNKNOWN) throw AbstractColorManager.createDOMSyntaxException(lunit);
                        assert (sm == null);
                        return new PendingStyleValue(lunit);
                    }
                }
                if (!"rgb".equalsIgnoreCase((from = (ColorValue)fromval).getCSSColorSpace())) {
                    from = colorUnit.getLexicalUnitType() != LexicalUnit.LexicalType.IDENT && !"currentcolor".equalsIgnoreCase(colorUnit.getStringValue()) ? this.toRGBColor(colorUnit) : AbstractColorManager.toRGBColor(from);
                }
                lu = AbstractColorManager.nextLexicalUnitNonNull(lu, lunit);
            }
            boolean pcntSpecified = lu.getLexicalUnitType() == LexicalUnit.LexicalType.PERCENTAGE;
            NumericValue red = this.createRGBColorComponent(lu, from);
            if ((lu = lu.getNextLexicalUnit()).getLexicalUnitType() == LexicalUnit.LexicalType.OPERATOR_COMMA) {
                lu = lu.getNextLexicalUnit();
            }
            pcntSpecified = pcntSpecified || lu.getLexicalUnitType() == LexicalUnit.LexicalType.PERCENTAGE;
            NumericValue green = this.createRGBColorComponent(lu, from);
            if ((lu = lu.getNextLexicalUnit()).getLexicalUnitType() == LexicalUnit.LexicalType.OPERATOR_COMMA) {
                lu = lu.getNextLexicalUnit();
            }
            pcntSpecified = pcntSpecified || lu.getLexicalUnitType() == LexicalUnit.LexicalType.PERCENTAGE;
            NumericValue blue = this.createRGBColorComponent(lu, from);
            if ((lu = lu.getNextLexicalUnit()) != null) {
                if ((lu.getLexicalUnitType() == LexicalUnit.LexicalType.OPERATOR_COMMA || lu.getLexicalUnitType() == LexicalUnit.LexicalType.OPERATOR_SLASH) && (lu = lu.getNextLexicalUnit()) == null) {
                    throw new DOMException(12, "Invalid color: " + lunit.getCssText());
                }
                alphaPcntSpecified = lu.getLexicalUnitType() == LexicalUnit.LexicalType.PERCENTAGE;
                alpha = this.createColorComponent(lu, from);
                return this.createRGBColor(red, green, blue, pcntSpecified, alpha, alphaPcntSpecified);
            } else {
                alpha = null;
            }
            return this.createRGBColor(red, green, blue, pcntSpecified, alpha, alphaPcntSpecified);
        }
        catch (CSSProxyValueException e) {
            return this.createLexicalValue(lunit);
        }
    }

    private RGBColorValue toRGBColor(LexicalUnit lunit) throws DOMException {
        RGBAColor color;
        ValueFactory vf = new ValueFactory();
        try {
            StyleValue css4jValue = vf.createCSSValue(lunit);
            if (css4jValue.getCssValueType() != CSSValue.CssType.TYPED) {
                throw this.createInvalidLexicalUnitDOMException(lunit.getLexicalUnitType());
            }
            color = ((CSSTypedValue)css4jValue).toRGBColor();
        }
        catch (DOMException e) {
            throw this.createInvalidLexicalUnitDOMException(lunit.getLexicalUnitType());
        }
        return AbstractColorManager.toNativeRGBColor(color);
    }

    private static RGBColorValue toNativeRGBColor(RGBAColor color) throws DOMException {
        double[] comps = color.toNumberArray();
        FloatValue r = new FloatValue(0, (float)comps[0]);
        FloatValue g = new FloatValue(0, (float)comps[1]);
        FloatValue b = new FloatValue(0, (float)comps[2]);
        FloatValue a = AbstractColorManager.normalizedComponentValue(color.getAlpha());
        RGBColorValue rgb = new RGBColorValue(r, g, b, a);
        return rgb;
    }

    private static RGBColorValue toRGBColor(ColorValue from) throws DOMException {
        String text = from.getCssText();
        ValueFactory vf = new ValueFactory();
        StyleValue css4jValue = vf.parseProperty(text);
        RGBAColor color = ((CSSTypedValue)css4jValue).toRGBColor();
        return AbstractColorManager.toNativeRGBColor(color);
    }

    private static FloatValue normalizedComponentValue(CSSPrimitiveValue c) throws DOMException {
        float f = AbstractColorManager.normalizedComponent(c);
        return new FloatValue(0, f);
    }

    private static float normalizedComponent(CSSPrimitiveValue c) throws DOMException {
        short unit = c.getUnitType();
        float f = ((CSSTypedValue)c).getFloatValue();
        switch (unit) {
            case 2: {
                f /= 100.0f;
            }
            case 0: {
                break;
            }
            default: {
                throw new DOMException(12, "Invalid color alpha: " + c.getCssText());
            }
        }
        return f;
    }

    protected ColorValue createRGBColor(NumericValue r, NumericValue g, NumericValue b, boolean pcntSpecified, NumericValue a, boolean alphaPcntSpecified) {
        if (pcntSpecified) {
            this.checkPercentageRGBComponent(r);
            this.checkPercentageRGBComponent(g);
            this.checkPercentageRGBComponent(b);
        }
        RGBColorValue c = a == null ? new RGBColorValue(r, g, b) : new RGBColorValue(r, g, b, a);
        c.setSpecifiedAsPercentage(pcntSpecified);
        c.setAlphaSpecifiedAsPercentage(alphaPcntSpecified);
        return c;
    }

    private void checkPercentageRGBComponent(NumericValue c) {
        if (c.getUnitType() == 0) {
            c.setFloatValue((short)2, c.getFloatValue() * 100.0f);
        }
    }

    /*
     * Exception decompiling
     */
    private Value createColorFunction(LexicalUnit lunit, CSSStylableElement elt, String pseudo, CSSEngine engine, int idx, StyleMap sm) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [8[DOLOOP]], but top level block is 19[SIMPLE_IF_TAKEN]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private ColorFunction toColorSpace(LexicalUnit lunit, String colorSpace) {
        CSSColor color;
        ValueFactory vf = new ValueFactory();
        try {
            StyleValue css4jValue = vf.createCSSValue(lunit);
            if (!(css4jValue instanceof CSSColorValue)) {
                if (css4jValue.getPrimitiveType() != CSSValue.Type.IDENT) {
                    throw this.createInvalidLexicalUnitDOMException(lunit.getLexicalUnitType());
                }
                color = ((CSSTypedValue)css4jValue).toRGBColor();
            } else {
                color = ((CSSColorValue)css4jValue).getColor();
                if (color == null) {
                    throw AbstractColorManager.createDOMSyntaxException(lunit);
                }
            }
            color = color.toColorSpace(colorSpace);
        }
        catch (DOMException e) {
            throw this.createInvalidLexicalUnitDOMException(lunit.getLexicalUnitType());
        }
        return AbstractColorManager.toNativeColorFunction(color, colorSpace);
    }

    private static ColorFunction toNativeColorFunction(CSSColor color, String colorSpace) {
        double[] comps = color.toNumberArray();
        AbstractValueList<NumericValue> components = new AbstractValueList<NumericValue>(' ', 4);
        for (int i = 0; i < comps.length; ++i) {
            FloatValue num = new FloatValue(0, (float)comps[i]);
            components.add(num);
        }
        ColorFunction colorFunction = new ColorFunction(colorSpace, components);
        FloatValue a = AbstractColorManager.normalizedComponentValue(color.getAlpha());
        colorFunction.setAlpha(a);
        return colorFunction;
    }

    private static ColorFunction toColorSpace(ColorValue from, String colorSpace) {
        String text = from.getCssText();
        ValueFactory vf = new ValueFactory();
        StyleValue css4jValue = vf.parseProperty(text);
        assert (css4jValue.getCssValueType() == CSSValue.CssType.TYPED);
        CSSColor color = ((CSSColorValue)css4jValue).getColor();
        color = color.toColorSpace(colorSpace);
        return AbstractColorManager.toNativeColorFunction(color, colorSpace);
    }

    protected NumericValue createRGBColorComponent(LexicalUnit lu, ColorValue from) throws DOMException {
        switch (lu.getLexicalUnitType()) {
            case INTEGER: {
                return new FloatValue(0, (float)lu.getIntegerValue() / 255.0f);
            }
            case REAL: {
                return new FloatValue(0, lu.getFloatValue() / 255.0f);
            }
            case PERCENTAGE: {
                return new FloatValue(2, lu.getFloatValue());
            }
            case VAR: 
            case ATTR: {
                throw new CSSProxyValueException();
            }
            case CALC: {
                Value calc = this.createCalc(lu);
                if (calc.getCssValueType() == CSSValue.CssType.PROXY) {
                    throw new CSSProxyValueException();
                }
                if (calc.getPrimitiveType() != CSSValue.Type.EXPRESSION) break;
                return AbstractColorManager.fromLegacyRange(this.evaluateComponent((CalcValue)calc, from));
            }
            case MATH_FUNCTION: {
                Value v;
                try {
                    v = this.createMathFunction(lu, "<number|percentage>");
                }
                catch (Exception e) {
                    DOMException ife = this.createInvalidLexicalUnitDOMException(lu.getLexicalUnitType());
                    ife.initCause(e);
                    throw ife;
                }
                if (v.getCssValueType() == CSSValue.CssType.PROXY) {
                    throw new CSSProxyValueException();
                }
                if (v.getPrimitiveType() != CSSValue.Type.MATH_FUNCTION) break;
                return AbstractColorManager.fromLegacyRange(this.evaluateComponent((MathFunctionValue)v, from));
            }
            case IDENT: {
                String ident = lu.getStringValue().toLowerCase(Locale.ROOT);
                if ("none".equals(ident)) {
                    return new FloatValue(0, 0.0f);
                }
                if (from == null) break;
                CSSNumberValue num = from.componentValue(ident);
                float f = num.getFloatValue();
                switch (num.getUnitType()) {
                    case 0: {
                        f /= 255.0f;
                        break;
                    }
                    case 2: {
                        f /= 100.0f;
                    }
                }
                return new FloatValue(0, f);
            }
        }
        throw this.createInvalidRGBComponentUnitDOMException(lu.getLexicalUnitType());
    }

    private static NumericValue fromLegacyRange(NumericValue ch) {
        float f = ch.getFloatValue();
        if (ch.getUnitType() == 0) {
            if (f > 255.0f) {
                f = 255.0f;
            } else if (f < 0.0f) {
                f = 0.0f;
            }
            ch = new FloatValue(0, f / 255.0f);
        }
        return ch;
    }

    private static NumericValue componentRange(NumericValue ch) {
        float f = ch.getFloatValue();
        if (ch.getUnitType() == 0) {
            if (f > 1.0f) {
                f = 1.0f;
            } else if (f < 0.0f) {
                f = 0.0f;
            }
            ch = new FloatValue(0, f);
        }
        return ch;
    }

    protected NumericValue createColorComponent(LexicalUnit lu, ColorValue from) throws DOMException {
        switch (lu.getLexicalUnitType()) {
            case INTEGER: {
                return new FloatValue(0, lu.getIntegerValue());
            }
            case REAL: {
                return new FloatValue(0, lu.getFloatValue());
            }
            case PERCENTAGE: {
                return new FloatValue(2, lu.getFloatValue());
            }
            case VAR: 
            case ATTR: {
                throw new CSSProxyValueException();
            }
            case CALC: {
                Value calc = this.createCalc(lu);
                if (calc.getCssValueType() == CSSValue.CssType.PROXY) {
                    throw new CSSProxyValueException();
                }
                if (calc.getPrimitiveType() != CSSValue.Type.EXPRESSION) break;
                return AbstractColorManager.componentRange(this.evaluateComponent((CalcValue)calc, from));
            }
            case MATH_FUNCTION: {
                Value v;
                try {
                    v = this.createMathFunction(lu, "<number|percentage>");
                }
                catch (Exception e) {
                    DOMException ife = this.createInvalidLexicalUnitDOMException(lu.getLexicalUnitType());
                    ife.initCause(e);
                    throw ife;
                }
                if (v.getCssValueType() == CSSValue.CssType.PROXY) {
                    throw new CSSProxyValueException();
                }
                if (v.getPrimitiveType() != CSSValue.Type.MATH_FUNCTION) break;
                return this.evaluateComponent((MathFunctionValue)v, from);
            }
            case IDENT: {
                String ident = lu.getStringValue().toLowerCase(Locale.ROOT);
                if ("none".equals(ident)) {
                    return new FloatValue(0, 0.0f);
                }
                if (from == null) break;
                CSSNumberValue num = from.componentValue(ident);
                float f = num.getFloatValue();
                if (num.getUnitType() == 2) {
                    f /= 100.0f;
                }
                return new FloatValue(0, f);
            }
        }
        throw this.createInvalidComponentUnitDOMException(lu.getLexicalUnitType());
    }

    private FloatValue evaluateComponent(NumericDelegateValue<?> calc, ColorValue from) throws DOMException {
        Evaluator eval = this.createEvaluator(from);
        CSSTypedValue result = calc.evaluate(eval);
        float f = result.getFloatValue((short)0);
        return new FloatValue(0, f);
    }

    private Evaluator createEvaluator(final ColorValue from) {
        return new PercentageEvaluator(){

            protected CSSTypedValue replaceParameter(String identifier) throws DOMException {
                identifier = identifier.toLowerCase(Locale.ROOT);
                if (from != null) {
                    return from.componentValue(identifier);
                }
                return super.replaceParameter(identifier);
            }
        };
    }

    @Override
    public StringMap<Value> getIdentifiers() {
        return values;
    }

    private DOMException createInvalidRGBComponentUnitDOMException(LexicalUnit.LexicalType lexicalType) {
        Object[] p = new Object[]{this.getPropertyName(), lexicalType.toString()};
        String s = Messages.formatMessage("invalid.rgb.component.unit", p);
        return new DOMException(9, s);
    }

    private DOMException createInvalidComponentUnitDOMException(LexicalUnit.LexicalType lexicalType) {
        Object[] p = new Object[]{this.getPropertyName(), lexicalType.toString()};
        String s = Messages.formatMessage("invalid.color.component.unit", p);
        return new DOMException(9, s);
    }

    static {
        values.put("aqua", ValueConstants.AQUA_VALUE);
        values.put("black", ValueConstants.BLACK_VALUE);
        values.put("blue", ValueConstants.BLUE_VALUE);
        values.put("fuchsia", ValueConstants.FUCHSIA_VALUE);
        values.put("gray", ValueConstants.GRAY_VALUE);
        values.put("green", ValueConstants.GREEN_VALUE);
        values.put("lime", ValueConstants.LIME_VALUE);
        values.put("maroon", ValueConstants.MAROON_VALUE);
        values.put("navy", ValueConstants.NAVY_VALUE);
        values.put("olive", ValueConstants.OLIVE_VALUE);
        values.put("purple", ValueConstants.PURPLE_VALUE);
        values.put("red", ValueConstants.RED_VALUE);
        values.put("silver", ValueConstants.SILVER_VALUE);
        values.put("teal", ValueConstants.TEAL_VALUE);
        values.put("transparent", ValueConstants.TRANSPARENT_VALUE);
        values.put("white", ValueConstants.WHITE_VALUE);
        values.put("yellow", ValueConstants.YELLOW_VALUE);
        values.put("activeborder", ValueConstants.ACTIVEBORDER_VALUE);
        values.put("activecaption", ValueConstants.ACTIVECAPTION_VALUE);
        values.put("appworkspace", ValueConstants.APPWORKSPACE_VALUE);
        values.put("background", ValueConstants.BACKGROUND_VALUE);
        values.put("buttonface", ValueConstants.BUTTONFACE_VALUE);
        values.put("buttonhighlight", ValueConstants.BUTTONHIGHLIGHT_VALUE);
        values.put("buttonshadow", ValueConstants.BUTTONSHADOW_VALUE);
        values.put("buttontext", ValueConstants.BUTTONTEXT_VALUE);
        values.put("captiontext", ValueConstants.CAPTIONTEXT_VALUE);
        values.put("graytext", ValueConstants.GRAYTEXT_VALUE);
        values.put("highlight", ValueConstants.HIGHLIGHT_VALUE);
        values.put("highlighttext", ValueConstants.HIGHLIGHTTEXT_VALUE);
        values.put("inactiveborder", ValueConstants.INACTIVEBORDER_VALUE);
        values.put("inactivecaption", ValueConstants.INACTIVECAPTION_VALUE);
        values.put("inactivecaptiontext", ValueConstants.INACTIVECAPTIONTEXT_VALUE);
        values.put("infobackground", ValueConstants.INFOBACKGROUND_VALUE);
        values.put("infotext", ValueConstants.INFOTEXT_VALUE);
        values.put("menu", ValueConstants.MENU_VALUE);
        values.put("menutext", ValueConstants.MENUTEXT_VALUE);
        values.put("scrollbar", ValueConstants.SCROLLBAR_VALUE);
        values.put("threeddarkshadow", ValueConstants.THREEDDARKSHADOW_VALUE);
        values.put("threedface", ValueConstants.THREEDFACE_VALUE);
        values.put("threedhighlight", ValueConstants.THREEDHIGHLIGHT_VALUE);
        values.put("threedlightshadow", ValueConstants.THREEDLIGHTSHADOW_VALUE);
        values.put("threedshadow", ValueConstants.THREEDSHADOW_VALUE);
        values.put("window", ValueConstants.WINDOW_VALUE);
        values.put("windowframe", ValueConstants.WINDOWFRAME_VALUE);
        values.put("windowtext", ValueConstants.WINDOWTEXT_VALUE);
        computedValues = new StringMap(18);
        computedValues.put("black", ValueConstants.BLACK_RGB_VALUE);
        computedValues.put("silver", ValueConstants.SILVER_RGB_VALUE);
        computedValues.put("gray", ValueConstants.GRAY_RGB_VALUE);
        computedValues.put("white", ValueConstants.WHITE_RGB_VALUE);
        computedValues.put("maroon", ValueConstants.MAROON_RGB_VALUE);
        computedValues.put("red", ValueConstants.RED_RGB_VALUE);
        computedValues.put("purple", ValueConstants.PURPLE_RGB_VALUE);
        computedValues.put("fuchsia", ValueConstants.FUCHSIA_RGB_VALUE);
        computedValues.put("green", ValueConstants.GREEN_RGB_VALUE);
        computedValues.put("lime", ValueConstants.LIME_RGB_VALUE);
        computedValues.put("olive", ValueConstants.OLIVE_RGB_VALUE);
        computedValues.put("yellow", ValueConstants.YELLOW_RGB_VALUE);
        computedValues.put("navy", ValueConstants.NAVY_RGB_VALUE);
        computedValues.put("blue", ValueConstants.BLUE_RGB_VALUE);
        computedValues.put("teal", ValueConstants.TEAL_RGB_VALUE);
        computedValues.put("aqua", ValueConstants.AQUA_RGB_VALUE);
        computedValues.put("transparent", ValueConstants.TRANSPARENT_RGB_VALUE);
    }
}

