/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.echosvg.css.engine.value.svg;

import io.sf.carte.doc.style.css.nsac.LexicalUnit;
import io.sf.carte.echosvg.css.engine.CSSEngine;
import io.sf.carte.echosvg.css.engine.CSSEngineUserAgent;
import io.sf.carte.echosvg.css.engine.CSSStylableElement;
import io.sf.carte.echosvg.css.engine.StyleMap;
import io.sf.carte.echosvg.css.engine.value.CSSProxyValueException;
import io.sf.carte.echosvg.css.engine.value.LengthManager;
import io.sf.carte.echosvg.css.engine.value.ListValue;
import io.sf.carte.echosvg.css.engine.value.RevertValue;
import io.sf.carte.echosvg.css.engine.value.UnsetValue;
import io.sf.carte.echosvg.css.engine.value.Value;
import io.sf.carte.echosvg.css.engine.value.ValueConstants;
import org.w3c.dom.DOMException;

public class StrokeDasharrayManager
extends LengthManager {
    @Override
    public boolean isInheritedProperty() {
        return true;
    }

    @Override
    public boolean isAnimatableProperty() {
        return true;
    }

    @Override
    public boolean isAdditiveProperty() {
        return false;
    }

    @Override
    public int getPropertyType() {
        return 34;
    }

    @Override
    public String getPropertyName() {
        return "stroke-dasharray";
    }

    @Override
    public Value getDefaultValue() {
        return ValueConstants.NONE_VALUE;
    }

    @Override
    public Value createValue(LexicalUnit lunit, CSSEngine engine) throws DOMException {
        switch (lunit.getLexicalUnitType()) {
            case IDENT: {
                if (lunit.getStringValue().equalsIgnoreCase("none")) {
                    return ValueConstants.NONE_VALUE;
                }
                throw this.createInvalidIdentifierDOMException(lunit.getStringValue());
            }
            case INHERIT: {
                return ValueConstants.INHERIT_VALUE;
            }
            case UNSET: {
                return UnsetValue.getInstance();
            }
            case REVERT: {
                return RevertValue.getInstance();
            }
            case INITIAL: {
                return this.getDefaultValue();
            }
            case VAR: 
            case ATTR: {
                return this.createLexicalValue(lunit);
            }
        }
        ListValue lv = new ListValue(' ');
        LexicalUnit lu = lunit;
        try {
            do {
                Value v = super.createValue(lu, engine);
                lv.append(v);
                lu = lu.getNextLexicalUnit();
                if (lu == null || lu.getLexicalUnitType() != LexicalUnit.LexicalType.OPERATOR_COMMA) continue;
                lu = lu.getNextLexicalUnit();
            } while (lu != null);
        }
        catch (CSSProxyValueException e) {
            return this.createLexicalValue(lunit);
        }
        return lv;
    }

    @Override
    public Value computeValue(CSSStylableElement elt, String pseudo, CSSEngine engine, int idx, StyleMap sm, Value value) {
        switch (value.getCssValueType()) {
            case TYPED: {
                return value;
            }
            case LIST: {
                ListValue result = new ListValue(' ');
                for (int i = 0; i < value.getLength(); ++i) {
                    Value v = this.computeTypedValue(elt, pseudo, engine, idx, sm, value.item(i));
                    if (v == null || v.getFloatValue() < 0.0f) {
                        CSSEngineUserAgent ua = engine.getCSSEngineUserAgent();
                        if (ua != null) {
                            ua.displayMessage("Invalid " + this.getPropertyName() + " value: " + value.getCssText());
                        }
                        return null;
                    }
                    result.append(v);
                }
                int len = result.getLength();
                if ((len & 1) != 0) {
                    for (int i = 0; i < len; ++i) {
                        result.add(result.item(i).clone());
                    }
                }
                return result;
            }
        }
        throw this.createDOMException();
    }

    @Override
    public Value computeTypedValue(CSSStylableElement elt, String pseudo, CSSEngine engine, int idx, StyleMap sm, Value value) {
        return super.computeValue(elt, pseudo, engine, idx, sm, value);
    }

    @Override
    protected int getOrientation() {
        return 2;
    }
}

