/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.echosvg.css.engine.value;

import io.sf.carte.doc.style.css.CSSValue;
import io.sf.carte.doc.style.css.nsac.LexicalUnit;
import io.sf.carte.doc.style.css.property.NumberValue;
import io.sf.carte.echosvg.css.Viewport;
import io.sf.carte.echosvg.css.engine.CSSContext;
import io.sf.carte.echosvg.css.engine.CSSEngine;
import io.sf.carte.echosvg.css.engine.CSSStylableElement;
import io.sf.carte.echosvg.css.engine.StyleMap;
import io.sf.carte.echosvg.css.engine.value.AbstractValueManager;
import io.sf.carte.echosvg.css.engine.value.FloatValue;
import io.sf.carte.echosvg.css.engine.value.NumericDelegateValue;
import io.sf.carte.echosvg.css.engine.value.RevertValue;
import io.sf.carte.echosvg.css.engine.value.UnsetValue;
import io.sf.carte.echosvg.css.engine.value.Value;
import org.w3c.css.om.unit.CSSUnit;
import org.w3c.dom.DOMException;

public abstract class LengthManager
extends AbstractValueManager {
    public static final float DEFAULT_LINE_HEIGHT = 1.1f;
    static final double SQRT2 = Math.sqrt(2.0);
    protected static final int HORIZONTAL_ORIENTATION = 0;
    protected static final int VERTICAL_ORIENTATION = 1;
    protected static final int BOTH_ORIENTATION = 2;

    @Override
    public Value createValue(LexicalUnit lu, CSSEngine engine) throws DOMException {
        switch (lu.getLexicalUnitType()) {
            case DIMENSION: {
                return this.createLength(lu);
            }
            case INTEGER: {
                return new FloatValue(0, lu.getIntegerValue());
            }
            case REAL: {
                return new FloatValue(0, lu.getFloatValue());
            }
            case PERCENTAGE: {
                return new FloatValue(2, lu.getFloatValue());
            }
            case UNSET: {
                return UnsetValue.getInstance();
            }
            case REVERT: {
                return RevertValue.getInstance();
            }
            case INITIAL: {
                return this.getDefaultValue();
            }
            case VAR: 
            case ATTR: {
                return this.createLexicalValue(lu);
            }
            case CALC: {
                return this.createCalc(lu);
            }
            case MATH_FUNCTION: {
                Value v;
                try {
                    v = this.createMathFunction(lu, "<length-percentage>");
                }
                catch (Exception e) {
                    DOMException ife = this.createInvalidLexicalUnitDOMException(lu.getLexicalUnitType());
                    ife.initCause(e);
                    throw ife;
                }
                return v;
            }
        }
        throw this.createInvalidLexicalUnitDOMException(lu.getLexicalUnitType());
    }

    FloatValue createLength(LexicalUnit lu) throws DOMException {
        if (CSSUnit.isLengthUnitType((short)lu.getCssUnit())) {
            return new FloatValue(lu.getCssUnit(), lu.getFloatValue());
        }
        throw this.createInvalidLexicalUnitDOMException(lu.getLexicalUnitType());
    }

    @Override
    public Value computeValue(CSSStylableElement elt, String pseudo, CSSEngine engine, int idx, StyleMap sm, Value value) {
        CSSValue.Type pType = value.getPrimitiveType();
        if (pType != CSSValue.Type.NUMERIC) {
            if (pType != CSSValue.Type.EXPRESSION && pType != CSSValue.Type.MATH_FUNCTION) {
                return value;
            }
            try {
                return this.evaluateMath((NumericDelegateValue)value, elt, pseudo, engine, idx, sm, (short)3);
            }
            catch (Exception e) {
                return this.isInheritedProperty() ? null : this.getDefaultValue();
            }
        }
        switch (value.getUnitType()) {
            case 0: 
            case 3: {
                break;
            }
            case 8: {
                float v = value.getFloatValue();
                value = new FloatValue(3, v * 3.7795277f);
                break;
            }
            case 7: {
                float v = value.getFloatValue();
                value = new FloatValue(3, v * 37.795277f);
                break;
            }
            case 4: {
                float v = value.getFloatValue();
                value = new FloatValue(3, v * 96.0f);
                break;
            }
            case 6: {
                float v = value.getFloatValue();
                value = new FloatValue(3, v / 0.75f);
                break;
            }
            case 5: {
                float v = value.getFloatValue();
                value = new FloatValue(3, v * 16.0f);
                break;
            }
            case 20: {
                sm.putFontSizeRelative(idx, true);
                float v = value.getFloatValue();
                int fsidx = engine.getFontSizeIndex();
                Value cv = engine.getComputedStyle(elt, pseudo, fsidx);
                float fs = this.lengthValue(cv);
                value = new FloatValue(3, v * fs);
                break;
            }
            case 21: {
                sm.putFontSizeRelative(idx, true);
                float v = value.getFloatValue();
                int fsidx = engine.getFontSizeIndex();
                Value cv = engine.getComputedStyle(elt, pseudo, fsidx);
                float fs = cv.getFloatValue();
                value = new FloatValue(3, v * fs * 0.5f);
                break;
            }
            case 2: {
                float fs;
                CSSContext ctx = engine.getCSSContext();
                switch (this.getOrientation()) {
                    case 0: {
                        sm.putBlockWidthRelative(idx, true);
                        fs = value.getFloatValue() * ctx.getBlockWidth(elt) / 100.0f;
                        break;
                    }
                    case 1: {
                        sm.putBlockHeightRelative(idx, true);
                        fs = value.getFloatValue() * ctx.getBlockHeight(elt) / 100.0f;
                        break;
                    }
                    default: {
                        sm.putBlockWidthRelative(idx, true);
                        sm.putBlockHeightRelative(idx, true);
                        double w = ctx.getBlockWidth(elt);
                        double h = ctx.getBlockHeight(elt);
                        fs = (float)((double)value.getFloatValue() * (Math.sqrt(w * w + h * h) / SQRT2) / 100.0);
                    }
                }
                value = new FloatValue(3, fs);
                break;
            }
            case 25: {
                sm.putLineHeightRelative(idx, true);
                float v = value.getFloatValue();
                int lhidx = engine.getLineHeightIndex();
                Value cv = engine.getComputedStyle(elt, pseudo, lhidx);
                float lh = this.lineHeightValue(elt, pseudo, engine, cv);
                value = new FloatValue(3, v * lh);
                break;
            }
            case 26: {
                sm.putRootFontSizeRelative(idx, true);
                float v = value.getFloatValue();
                int fsidx = engine.getFontSizeIndex();
                CSSStylableElement root = (CSSStylableElement)elt.getOwnerDocument().getDocumentElement();
                Value cv = engine.getComputedStyle(root, null, fsidx);
                float fs = cv.getFloatValue();
                value = new FloatValue(3, v * fs);
                break;
            }
            case 28: {
                sm.putRootFontSizeRelative(idx, true);
                float v = value.getFloatValue();
                int fsidx = engine.getFontSizeIndex();
                CSSStylableElement root = (CSSStylableElement)elt.getOwnerDocument().getDocumentElement();
                Value cv = engine.getComputedStyle(root, null, fsidx);
                float fs = cv.getFloatValue();
                value = new FloatValue(3, v * fs * 0.5f);
                break;
            }
            case 27: {
                sm.putRootLineHeightRelative(idx, true);
                float v = value.getFloatValue();
                int lhidx = engine.getLineHeightIndex();
                CSSStylableElement root = (CSSStylableElement)elt.getOwnerDocument().getDocumentElement();
                Value cv = engine.getComputedStyle(root, null, lhidx);
                float lh = this.lineHeightValue(root, null, engine, cv);
                value = new FloatValue(3, v * lh);
                break;
            }
            case 45: {
                sm.putViewportRelative(idx, true);
                float v = value.getFloatValue();
                value = new FloatValue(3, v * engine.getCSSContext().getViewport(elt).getWidth() / 100.0f);
                break;
            }
            case 41: {
                sm.putViewportRelative(idx, true);
                float v = value.getFloatValue();
                value = new FloatValue(3, v * engine.getCSSContext().getViewport(elt).getHeight() / 100.0f);
                break;
            }
            case 44: {
                sm.putViewportRelative(idx, true);
                float v = value.getFloatValue();
                Viewport vp = engine.getCSSContext().getViewport(elt);
                float w = vp.getWidth();
                float h = vp.getHeight();
                float min = Math.min(w, h);
                value = new FloatValue(3, v * min / 100.0f);
                break;
            }
            case 43: {
                sm.putViewportRelative(idx, true);
                float v = value.getFloatValue();
                Viewport vp = engine.getCSSContext().getViewport(elt);
                float w = vp.getWidth();
                float h = vp.getHeight();
                float max = Math.max(w, h);
                value = new FloatValue(3, v * max / 100.0f);
                break;
            }
            case 1: 
            case 255: {
                value = null;
                break;
            }
            default: {
                try {
                    value = new FloatValue(3, NumberValue.floatValueConversion((float)value.getFloatValue(), (short)value.getUnitType(), (short)3));
                    break;
                }
                catch (DOMException e) {
                    value = null;
                }
            }
        }
        return value;
    }

    protected float lineHeightValue(CSSStylableElement elt, String pseudo, CSSEngine engine, Value v) throws DOMException {
        short unit = v.getUnitType();
        if (unit == 0) {
            int fsidx = engine.getFontSizeIndex();
            Value cv = engine.getComputedStyle(elt, pseudo, fsidx);
            float fs = cv.getFloatValue();
            return fs * v.getFloatValue();
        }
        if (unit == 3) {
            return v.getFloatValue();
        }
        return NumberValue.floatValueConversion((float)v.getFloatValue(), (short)unit, (short)3);
    }

    protected abstract int getOrientation();
}

