/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.echosvg.dom;

import io.sf.carte.doc.style.css.nsac.Parser;
import io.sf.carte.doc.style.css.parser.CSSParser;
import io.sf.carte.echosvg.css.engine.CSSContext;
import io.sf.carte.echosvg.css.engine.CSSEngine;
import io.sf.carte.echosvg.css.engine.value.ShorthandManager;
import io.sf.carte.echosvg.css.engine.value.ValueManager;
import io.sf.carte.echosvg.dom.AbstractAttr;
import io.sf.carte.echosvg.dom.AbstractDOMImplementation;
import io.sf.carte.echosvg.dom.AbstractDocument;
import io.sf.carte.echosvg.dom.AbstractStylableDocument;
import io.sf.carte.echosvg.dom.DomExtension;
import io.sf.carte.echosvg.dom.GenericDocumentType;
import io.sf.carte.echosvg.dom.GenericElement;
import io.sf.carte.echosvg.dom.GenericElementNS;
import io.sf.carte.echosvg.dom.StyleSheetFactory;
import io.sf.carte.echosvg.dom.util.DOMUtilities;
import io.sf.carte.echosvg.util.DoublyIndexedTable;
import io.sf.carte.echosvg.xml.XMLUtilities;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.ServiceLoader;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.css.DOMImplementationCSS;
import org.w3c.dom.css.ViewCSS;

public abstract class ExtensibleDOMImplementation
extends AbstractDOMImplementation
implements DOMImplementationCSS,
StyleSheetFactory {
    private static final long serialVersionUID = 1L;
    protected DoublyIndexedTable<String, String> customFactories;
    protected List<ValueManager> customValueManagers;
    protected List<ShorthandManager> customShorthandManagers;
    protected static List<DomExtension> extensions = null;

    public ExtensibleDOMImplementation() {
        for (DomExtension de : ExtensibleDOMImplementation.getDomExtensions()) {
            de.registerTags(this);
        }
    }

    public void registerCustomElementFactory(String namespaceURI, String localName, ElementFactory factory) {
        if (this.customFactories == null) {
            this.customFactories = new DoublyIndexedTable();
        }
        this.customFactories.put((Object)namespaceURI, (Object)localName, (Object)factory);
    }

    public void registerCustomCSSValueManager(ValueManager vm) {
        if (this.customValueManagers == null) {
            this.customValueManagers = new LinkedList<ValueManager>();
        }
        this.customValueManagers.add(vm);
    }

    public void registerCustomCSSShorthandManager(ShorthandManager sm) {
        if (this.customShorthandManagers == null) {
            this.customShorthandManagers = new LinkedList<ShorthandManager>();
        }
        this.customShorthandManagers.add(sm);
    }

    public CSSEngine createCSSEngine(AbstractStylableDocument doc, CSSContext ctx) {
        ShorthandManager[] sms;
        ValueManager[] vms;
        CSSParser p = new CSSParser();
        if (this.customValueManagers == null) {
            vms = new ValueManager[]{};
        } else {
            vms = new ValueManager[this.customValueManagers.size()];
            Iterator<ValueManager> it = this.customValueManagers.iterator();
            int i = 0;
            while (it.hasNext()) {
                vms[i++] = it.next();
            }
        }
        if (this.customShorthandManagers == null) {
            sms = new ShorthandManager[]{};
        } else {
            sms = new ShorthandManager[this.customShorthandManagers.size()];
            Iterator<ShorthandManager> it = this.customShorthandManagers.iterator();
            int i = 0;
            while (it.hasNext()) {
                sms[i++] = it.next();
            }
        }
        CSSEngine result = this.createCSSEngine(doc, ctx, (Parser)p, vms, sms);
        doc.setCSSEngine(result);
        return result;
    }

    public abstract CSSEngine createCSSEngine(AbstractStylableDocument var1, CSSContext var2, Parser var3, ValueManager[] var4, ShorthandManager[] var5);

    public abstract ViewCSS createViewCSS(AbstractStylableDocument var1);

    public Element createElementNS(AbstractDocument document, String namespaceURI, String qualifiedName) {
        String name;
        ElementFactory cef;
        if (namespaceURI != null && namespaceURI.length() == 0) {
            namespaceURI = null;
        }
        if (namespaceURI == null) {
            return new GenericElement(qualifiedName.intern(), document);
        }
        if (this.customFactories != null && (cef = (ElementFactory)this.customFactories.get((Object)namespaceURI, (Object)(name = DOMUtilities.getLocalName(qualifiedName)))) != null) {
            return cef.create(DOMUtilities.getPrefix(qualifiedName), document);
        }
        return new GenericElementNS(namespaceURI.intern(), qualifiedName.intern(), document);
    }

    @Override
    public DocumentType createDocumentType(String qualifiedName, String publicId, String systemId) {
        int test;
        if (qualifiedName == null) {
            qualifiedName = "";
        }
        if (((test = XMLUtilities.testXMLQName((String)qualifiedName)) & 1) == 0) {
            throw new DOMException(5, this.formatMessage("xml.name", new Object[]{qualifiedName}));
        }
        if ((test & 2) == 0) {
            throw new DOMException(5, this.formatMessage("invalid.qname", new Object[]{qualifiedName}));
        }
        return new GenericDocumentType(qualifiedName, publicId, systemId);
    }

    protected static synchronized List<DomExtension> getDomExtensions() {
        if (extensions != null) {
            return extensions;
        }
        extensions = new LinkedList<DomExtension>();
        ServiceLoader<DomExtension> loader = ServiceLoader.load(DomExtension.class);
        block0: for (DomExtension de : loader) {
            DomExtension lde;
            float priority = de.getPriority();
            ListIterator<DomExtension> li = extensions.listIterator();
            do {
                if (li.hasNext()) continue;
                li.add(de);
                continue block0;
            } while (!((lde = li.next()).getPriority() > priority));
            li.previous();
            li.add(de);
        }
        return extensions;
    }

    public static interface ElementFactory {
        public Element create(String var1, Document var2);

        default public void importAttributes(Element imported, Node toImport, boolean trimId) {
            if (toImport.hasAttributes()) {
                NamedNodeMap attr = toImport.getAttributes();
                int len = attr.getLength();
                for (int i = 0; i < len; ++i) {
                    Attr a = (Attr)attr.item(i);
                    if (!a.getSpecified()) continue;
                    AbstractAttr aa = (AbstractAttr)imported.getOwnerDocument().createAttributeNS(a.getNamespaceURI(), a.getNodeName());
                    aa.setNodeValue(a.getNodeValue());
                    if (trimId && aa.isId()) {
                        aa.setIsId(false);
                    }
                    imported.setAttributeNodeNS(aa);
                }
            }
        }
    }
}

