/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.echosvg.extension.svg;

import io.sf.carte.echosvg.bridge.Bridge;
import io.sf.carte.echosvg.bridge.BridgeContext;
import io.sf.carte.echosvg.bridge.BridgeException;
import io.sf.carte.echosvg.bridge.SVGDecoratedShapeElementBridge;
import io.sf.carte.echosvg.bridge.SVGUtilities;
import io.sf.carte.echosvg.bridge.UnitProcessor;
import io.sf.carte.echosvg.extension.svg.EchoSVGExtConstants;
import io.sf.carte.echosvg.gvt.ShapeNode;
import io.sf.carte.echosvg.parser.UnitProcessor;
import java.awt.Shape;
import java.awt.geom.GeneralPath;
import org.w3c.dom.Element;

public class EchoSVGRegularPolygonElementBridge
extends SVGDecoratedShapeElementBridge
implements EchoSVGExtConstants {
    public String getNamespaceURI() {
        return "http://xml.apache.org/batik/ext";
    }

    public String getLocalName() {
        return "regularPolygon";
    }

    public Bridge getInstance() {
        return new EchoSVGRegularPolygonElementBridge();
    }

    protected void buildShape(BridgeContext ctx, Element e, ShapeNode shapeNode) {
        UnitProcessor.Context uctx = UnitProcessor.createContext((BridgeContext)ctx, (Element)e);
        String s = e.getAttributeNS(null, "cx");
        float cx = 0.0f;
        if (s.length() != 0) {
            cx = UnitProcessor.svgHorizontalCoordinateToUserSpace((String)s, (String)"cx", (UnitProcessor.Context)uctx);
        }
        s = e.getAttributeNS(null, "cy");
        float cy = 0.0f;
        if (s.length() != 0) {
            cy = UnitProcessor.svgVerticalCoordinateToUserSpace((String)s, (String)"cy", (UnitProcessor.Context)uctx);
        }
        if ((s = e.getAttributeNS(null, "r")).length() == 0) {
            throw new BridgeException(ctx, e, "attribute.missing", new Object[]{"r", s});
        }
        float r = UnitProcessor.svgOtherLengthToUserSpace((String)s, (String)"r", (UnitProcessor.Context)uctx);
        int sides = EchoSVGRegularPolygonElementBridge.convertSides(e, "sides", 3, ctx);
        GeneralPath gp = new GeneralPath();
        for (int i = 0; i < sides; ++i) {
            double angle = ((double)i + 0.5) * (Math.PI * 2 / (double)sides) - 1.5707963267948966;
            double x = (double)cx + (double)r * Math.cos(angle);
            double y = (double)cy - (double)r * Math.sin(angle);
            if (i == 0) {
                gp.moveTo((float)x, (float)y);
                continue;
            }
            gp.lineTo((float)x, (float)y);
        }
        gp.closePath();
        shapeNode.setShape((Shape)gp);
    }

    protected static int convertSides(Element filterElement, String attrName, int defaultValue, BridgeContext ctx) {
        String s = filterElement.getAttributeNS(null, attrName);
        if (s.length() == 0) {
            return defaultValue;
        }
        int ret = 0;
        try {
            ret = SVGUtilities.convertSVGInteger((String)s);
        }
        catch (NumberFormatException nfEx) {
            throw new BridgeException(ctx, filterElement, (Exception)nfEx, "attribute.malformed", new Object[]{attrName, s});
        }
        if (ret < 3) {
            throw new BridgeException(ctx, filterElement, "attribute.malformed", new Object[]{attrName, s});
        }
        return ret;
    }
}

