/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.echosvg.extension;

import io.sf.carte.echosvg.css.engine.CSSStylableElement;
import io.sf.carte.echosvg.css.engine.StyleDeclarationProvider;
import io.sf.carte.echosvg.css.engine.StyleMap;
import io.sf.carte.echosvg.dom.AbstractDocument;
import io.sf.carte.echosvg.dom.AbstractStylableDocument;
import io.sf.carte.echosvg.extension.ExtensionElement;
import io.sf.carte.echosvg.util.ParsedURL;
import org.w3c.css.om.CSSStyleDeclaration;
import org.w3c.css.om.typed.CSSStyleValue;
import org.w3c.dom.Node;
import org.w3c.dom.svg.SVGAnimatedString;
import org.w3c.dom.svg.SVGStylable;

public abstract class StylableExtensionElement
extends ExtensionElement
implements CSSStylableElement,
SVGStylable {
    private static final long serialVersionUID = 1L;
    protected ParsedURL cssBase;
    protected StyleMap computedStyleMap;

    protected StylableExtensionElement() {
    }

    protected StylableExtensionElement(String name, AbstractDocument owner) {
        super(name, owner);
    }

    public StyleMap getComputedStyleMap(String pseudoElement) {
        return this.computedStyleMap;
    }

    public void setComputedStyleMap(String pseudoElement, StyleMap sm) {
        this.computedStyleMap = sm;
    }

    public String getXMLId() {
        return this.getAttributeNS(null, "id");
    }

    public String getCSSClass() {
        return this.getAttributeNS(null, "class");
    }

    public ParsedURL getCSSBase() {
        if (this.cssBase == null) {
            String bu = this.getBaseURI();
            if (bu == null) {
                return null;
            }
            this.cssBase = new ParsedURL(bu);
        }
        return this.cssBase;
    }

    public boolean isPseudoInstanceOf(String pseudoClass) {
        if (pseudoClass.equals("first-child")) {
            Node n;
            for (n = this.getPreviousSibling(); n != null && n.getNodeType() != 1; n = n.getPreviousSibling()) {
            }
            return n == null;
        }
        return false;
    }

    public StyleDeclarationProvider getOverrideStyleDeclarationProvider() {
        return null;
    }

    public CSSStyleDeclaration getStyle() {
        throw new UnsupportedOperationException("Not implemented");
    }

    public CSSStyleValue getPresentationAttributeValue(String name) {
        AbstractStylableDocument doc = (AbstractStylableDocument)this.getCurrentDocument();
        return this.computedStyleMap.getValue(doc.getCSSEngine().getPropertyIndex(name));
    }

    public SVGAnimatedString getClassName() {
        throw new UnsupportedOperationException("Not implemented");
    }
}

