/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.echosvg.extension.svg;

import io.sf.carte.echosvg.bridge.AbstractSVGBridge;
import io.sf.carte.echosvg.bridge.Bridge;
import io.sf.carte.echosvg.bridge.BridgeContext;
import io.sf.carte.echosvg.bridge.PaintBridge;
import io.sf.carte.echosvg.bridge.SVGUtilities;
import io.sf.carte.echosvg.bridge.UserAgent;
import io.sf.carte.echosvg.extension.svg.EchoSVGExtConstants;
import io.sf.carte.echosvg.gvt.GraphicsNode;
import java.awt.Color;
import java.awt.Paint;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ColorSwitchBridge
extends AbstractSVGBridge
implements PaintBridge,
EchoSVGExtConstants {
    public String getNamespaceURI() {
        return "http://xml.apache.org/batik/ext";
    }

    public String getLocalName() {
        return "colorSwitch";
    }

    public Paint createPaint(BridgeContext ctx, Element paintElement, Element paintedElement, GraphicsNode paintedNode, float opacity) {
        Element clrDef = null;
        for (Node n = paintElement.getFirstChild(); n != null; n = n.getNextSibling()) {
            Element ref;
            if (n.getNodeType() != 1 || !SVGUtilities.matchUserAgent((Element)(ref = (Element)n), (UserAgent)ctx.getUserAgent())) continue;
            clrDef = ref;
            break;
        }
        if (clrDef == null) {
            return Color.black;
        }
        Bridge bridge = ctx.getBridge(clrDef);
        if (!(bridge instanceof PaintBridge)) {
            return Color.black;
        }
        return ((PaintBridge)bridge).createPaint(ctx, clrDef, paintedElement, paintedNode, opacity);
    }
}

