/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.echosvg.extension.svg;

import io.sf.carte.echosvg.bridge.AbstractSVGFilterPrimitiveElementBridge;
import io.sf.carte.echosvg.bridge.Bridge;
import io.sf.carte.echosvg.bridge.BridgeContext;
import io.sf.carte.echosvg.bridge.BridgeException;
import io.sf.carte.echosvg.bridge.SVGUtilities;
import io.sf.carte.echosvg.ext.awt.image.PadMode;
import io.sf.carte.echosvg.ext.awt.image.renderable.Filter;
import io.sf.carte.echosvg.ext.awt.image.renderable.PadRable8Bit;
import io.sf.carte.echosvg.extension.svg.EchoSVGExtConstants;
import io.sf.carte.echosvg.extension.svg.EchoSVGHistogramNormalizationFilter8Bit;
import io.sf.carte.echosvg.gvt.GraphicsNode;
import java.awt.geom.Rectangle2D;
import java.util.Map;
import org.w3c.dom.Element;

public class EchoSVGHistogramNormalizationElementBridge
extends AbstractSVGFilterPrimitiveElementBridge
implements EchoSVGExtConstants {
    public String getNamespaceURI() {
        return "http://xml.apache.org/batik/ext";
    }

    public String getLocalName() {
        return "histogramNormalization";
    }

    public Bridge getInstance() {
        return new EchoSVGHistogramNormalizationElementBridge();
    }

    public Filter createFilter(BridgeContext ctx, Element filterElement, Element filteredElement, GraphicsNode filteredNode, Filter inputFilter, Rectangle2D filterRegion, Map<String, Filter> filterMap) {
        Filter in = EchoSVGHistogramNormalizationElementBridge.getIn((Element)filterElement, (Element)filteredElement, (GraphicsNode)filteredNode, (Filter)inputFilter, filterMap, (BridgeContext)ctx);
        if (in == null) {
            return null;
        }
        Filter sourceGraphics = filterMap.get("SourceGraphic");
        Rectangle2D defaultRegion = in == sourceGraphics ? filterRegion : in.getBounds2D();
        Rectangle2D primitiveRegion = SVGUtilities.convertFilterPrimitiveRegion((Element)filterElement, (Element)filteredElement, (GraphicsNode)filteredNode, (Rectangle2D)defaultRegion, (Rectangle2D)filterRegion, (BridgeContext)ctx);
        float trim = 1.0f;
        String s = filterElement.getAttributeNS(null, "trim");
        if (s.length() != 0) {
            try {
                trim = SVGUtilities.convertSVGNumber((String)s);
            }
            catch (NumberFormatException nfEx) {
                throw new BridgeException(ctx, filterElement, (Exception)nfEx, "attribute.malformed", new Object[]{"trim", s});
            }
        }
        if (trim < 0.0f) {
            trim = 0.0f;
        } else if (trim > 100.0f) {
            trim = 100.0f;
        }
        Object filter = in;
        filter = new EchoSVGHistogramNormalizationFilter8Bit((Filter)filter, trim / 100.0f);
        filter = new PadRable8Bit(filter, primitiveRegion, PadMode.ZERO_PAD);
        EchoSVGHistogramNormalizationElementBridge.updateFilterMap((Element)filterElement, (Filter)filter, filterMap);
        EchoSVGHistogramNormalizationElementBridge.handleColorInterpolationFilters((Filter)filter, (Element)filterElement);
        return filter;
    }

    protected static int convertSides(Element filterElement, String attrName, int defaultValue, BridgeContext ctx) {
        String s = filterElement.getAttributeNS(null, attrName);
        if (s.length() == 0) {
            return defaultValue;
        }
        int ret = 0;
        try {
            ret = SVGUtilities.convertSVGInteger((String)s);
        }
        catch (NumberFormatException nfEx) {
            throw new BridgeException(ctx, filterElement, (Exception)nfEx, "attribute.malformed", new Object[]{attrName, s});
        }
        if (ret < 3) {
            throw new BridgeException(ctx, filterElement, "attribute.malformed", new Object[]{attrName, s});
        }
        return ret;
    }
}

