/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.echosvg.util.gui.xmleditor;

import io.sf.carte.echosvg.util.gui.xmleditor.XMLContext;
import io.sf.carte.echosvg.util.gui.xmleditor.XMLDocument;
import io.sf.carte.echosvg.util.gui.xmleditor.XMLView;
import java.awt.Font;
import javax.swing.JEditorPane;
import javax.swing.text.DefaultEditorKit;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;

public class XMLEditorKit
extends DefaultEditorKit {
    private static final long serialVersionUID = 1L;
    public static final String XML_MIME_TYPE = "text/xml";
    protected XMLContext context;
    protected ViewFactory factory = new XMLViewFactory();

    public XMLEditorKit() {
        this(null);
    }

    public XMLEditorKit(XMLContext context) {
        this.context = context == null ? new XMLContext() : context;
    }

    public XMLContext getStylePreferences() {
        return this.context;
    }

    @Override
    public void install(JEditorPane c) {
        super.install(c);
        Font obj = this.context.getSyntaxFont("default");
        if (obj != null) {
            c.setFont(obj);
        }
    }

    @Override
    public String getContentType() {
        return XML_MIME_TYPE;
    }

    @Override
    public Object clone() {
        XMLEditorKit kit = new XMLEditorKit();
        kit.context = this.context;
        return kit;
    }

    @Override
    public Document createDefaultDocument() {
        XMLDocument doc = new XMLDocument(this.context);
        return doc;
    }

    @Override
    public ViewFactory getViewFactory() {
        return this.factory;
    }

    protected class XMLViewFactory
    implements ViewFactory {
        protected XMLViewFactory() {
        }

        @Override
        public View create(Element elem) {
            return new XMLView(XMLEditorKit.this.context, elem);
        }
    }
}

