/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.echosvg.util.gui.xmleditor;

import java.awt.Color;
import java.awt.Font;
import java.util.HashMap;
import java.util.Map;
import javax.swing.text.StyleContext;

public class XMLContext
extends StyleContext {
    private static final long serialVersionUID = 1L;
    public static final String XML_DECLARATION_STYLE = "xml_declaration";
    public static final String DOCTYPE_STYLE = "doctype";
    public static final String COMMENT_STYLE = "comment";
    public static final String ELEMENT_STYLE = "element";
    public static final String CHARACTER_DATA_STYLE = "character_data";
    public static final String ATTRIBUTE_NAME_STYLE = "attribute_name";
    public static final String ATTRIBUTE_VALUE_STYLE = "attribute_value";
    public static final String CDATA_STYLE = "cdata";
    protected Map<String, Color> syntaxForegroundMap = null;
    protected Map<String, Font> syntaxFontMap = null;

    public XMLContext() {
        this.syntaxFontMap = new HashMap<String, Font>();
        this.syntaxForegroundMap = new HashMap<String, Color>();
        Font defaultFont = new Font("Monospaced", 0, 12);
        String syntaxName = "default";
        Font font = defaultFont;
        Color fontForeground = Color.black;
        this.syntaxFontMap.put(syntaxName, font);
        this.syntaxForegroundMap.put(syntaxName, fontForeground);
        syntaxName = XML_DECLARATION_STYLE;
        font = defaultFont.deriveFont(1);
        fontForeground = new Color(0, 0, 124);
        this.syntaxFontMap.put(syntaxName, font);
        this.syntaxForegroundMap.put(syntaxName, fontForeground);
        syntaxName = DOCTYPE_STYLE;
        font = defaultFont.deriveFont(1);
        fontForeground = new Color(0, 0, 124);
        this.syntaxFontMap.put(syntaxName, font);
        this.syntaxForegroundMap.put(syntaxName, fontForeground);
        syntaxName = COMMENT_STYLE;
        font = defaultFont;
        fontForeground = new Color(128, 128, 128);
        this.syntaxFontMap.put(syntaxName, font);
        this.syntaxForegroundMap.put(syntaxName, fontForeground);
        syntaxName = ELEMENT_STYLE;
        font = defaultFont;
        fontForeground = new Color(0, 0, 255);
        this.syntaxFontMap.put(syntaxName, font);
        this.syntaxForegroundMap.put(syntaxName, fontForeground);
        syntaxName = CHARACTER_DATA_STYLE;
        font = defaultFont;
        fontForeground = Color.black;
        this.syntaxFontMap.put(syntaxName, font);
        this.syntaxForegroundMap.put(syntaxName, fontForeground);
        syntaxName = ATTRIBUTE_NAME_STYLE;
        font = defaultFont;
        fontForeground = new Color(0, 124, 0);
        this.syntaxFontMap.put(syntaxName, font);
        this.syntaxForegroundMap.put(syntaxName, fontForeground);
        syntaxName = ATTRIBUTE_VALUE_STYLE;
        font = defaultFont;
        fontForeground = new Color(153, 0, 107);
        this.syntaxFontMap.put(syntaxName, font);
        this.syntaxForegroundMap.put(syntaxName, fontForeground);
        syntaxName = CDATA_STYLE;
        font = defaultFont;
        fontForeground = new Color(124, 98, 0);
        this.syntaxFontMap.put(syntaxName, font);
        this.syntaxForegroundMap.put(syntaxName, fontForeground);
    }

    public XMLContext(Map<String, Font> syntaxFontMap, Map<String, Color> syntaxForegroundMap) {
        this.setSyntaxFont(syntaxFontMap);
        this.setSyntaxForeground(syntaxForegroundMap);
    }

    public void setSyntaxForeground(Map<String, Color> syntaxForegroundMap) {
        if (syntaxForegroundMap == null) {
            throw new IllegalArgumentException("syntaxForegroundMap can not be null");
        }
        this.syntaxForegroundMap = syntaxForegroundMap;
    }

    public void setSyntaxFont(Map<String, Font> syntaxFontMap) {
        if (syntaxFontMap == null) {
            throw new IllegalArgumentException("syntaxFontMap can not be null");
        }
        this.syntaxFontMap = syntaxFontMap;
    }

    public Color getSyntaxForeground(int ctx) {
        String name = this.getSyntaxName(ctx);
        return this.getSyntaxForeground(name);
    }

    public Color getSyntaxForeground(String name) {
        return this.syntaxForegroundMap.get(name);
    }

    public Font getSyntaxFont(int ctx) {
        String name = this.getSyntaxName(ctx);
        return this.getSyntaxFont(name);
    }

    public Font getSyntaxFont(String name) {
        return this.syntaxFontMap.get(name);
    }

    public String getSyntaxName(int ctx) {
        String name = CHARACTER_DATA_STYLE;
        switch (ctx) {
            case 6: {
                name = XML_DECLARATION_STYLE;
                break;
            }
            case 7: {
                name = DOCTYPE_STYLE;
                break;
            }
            case 1: {
                name = COMMENT_STYLE;
                break;
            }
            case 2: {
                name = ELEMENT_STYLE;
                break;
            }
            case 4: {
                name = ATTRIBUTE_NAME_STYLE;
                break;
            }
            case 5: {
                name = ATTRIBUTE_VALUE_STYLE;
                break;
            }
            case 10: {
                name = CDATA_STYLE;
                break;
            }
            default: {
                name = "default";
            }
        }
        return name;
    }
}

