/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.echosvg.gvt.font;

import java.awt.Shape;
import java.awt.geom.Rectangle2D;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantLock;

public class AWTGlyphGeometryCache {
    private static final int INITIAL_CAPACITY = 71;
    private Entry[] table;
    private AtomicInteger count = new AtomicInteger();
    private ReferenceQueue<Object> referenceQueue = new ReferenceQueue();
    private final ReentrantLock tableLock = new ReentrantLock();

    public AWTGlyphGeometryCache() {
        this.table = new Entry[71];
    }

    public AWTGlyphGeometryCache(int c) {
        this.table = new Entry[c];
    }

    public int size() {
        return this.count.get();
    }

    public Value get(char c) {
        int hash = this.hashCode(c) & Integer.MAX_VALUE;
        int index = hash % this.table.length;
        Entry e = this.table[index];
        while (e != null) {
            if (e.hash == hash && e.match(c)) {
                return (Value)e.get();
            }
            e = e.next;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Value put(char c, Value value) {
        int hash = this.hashCode(c) & Integer.MAX_VALUE;
        this.tableLock.lock();
        try {
            this.removeClearedEntries();
            int index = hash % this.table.length;
            Entry e = this.table[index];
            if (e != null) {
                if (e.hash == hash && e.match(c)) {
                    Value old = (Value)e.get();
                    this.table[index] = new Entry(hash, c, value, e.next);
                    Value value2 = old;
                    return value2;
                }
                Entry o = e;
                e = e.next;
                while (e != null) {
                    if (e.hash == hash && e.match(c)) {
                        Value old = (Value)e.get();
                        e = new Entry(hash, c, value, e.next);
                        o.next = e;
                        Value value3 = old;
                        return value3;
                    }
                    o = e;
                    e = e.next;
                }
            }
            int len = this.table.length;
            if (this.count.getAndIncrement() >= len - (len >> 2)) {
                this.rehash();
                index = hash % this.table.length;
            }
            this.table[index] = new Entry(hash, c, value, this.table[index]);
        }
        finally {
            this.tableLock.unlock();
        }
        return null;
    }

    public void clear() {
        this.tableLock.lock();
        try {
            this.table = new Entry[71];
        }
        finally {
            this.tableLock.unlock();
        }
        this.count.lazySet(0);
        this.referenceQueue = new ReferenceQueue();
    }

    protected void rehash() {
        Entry[] oldTable = this.table;
        int olen = oldTable.length;
        int rehlen = olen * 2 + 1;
        Entry[] rehTable = new Entry[rehlen];
        for (int i = olen - 1; i >= 0; --i) {
            Entry old = oldTable[i];
            while (old != null) {
                Entry e = old;
                old = old.next;
                int index = e.hash % rehlen;
                e.next = rehTable[index];
                rehTable[index] = e;
            }
        }
        this.table = rehTable;
    }

    protected int hashCode(char c) {
        return c;
    }

    protected void removeClearedEntries() {
        Entry e;
        while ((e = (Entry)this.referenceQueue.poll()) != null) {
            int index = e.hash % this.table.length;
            Entry t = this.table[index];
            if (t == e) {
                this.table[index] = e.next;
            } else {
                while (t != null) {
                    Entry c = t.next;
                    if (c == e) {
                        t.next = e.next;
                        break;
                    }
                    t = c;
                }
            }
            this.count.decrementAndGet();
        }
    }

    protected class Entry
    extends SoftReference<Value> {
        private final int hash;
        private final char c;
        private Entry next;

        public Entry(int hash, char c, Value value, Entry next) {
            super(value, AWTGlyphGeometryCache.this.referenceQueue);
            this.hash = hash;
            this.c = c;
            this.next = next;
        }

        public boolean match(char o2) {
            return this.c == o2;
        }
    }

    public static class Value {
        private final Shape outline;
        private final Rectangle2D gmB;
        private final Rectangle2D outlineBounds;

        public Value(Shape outline, Rectangle2D gmB) {
            this.outline = outline;
            this.outlineBounds = outline.getBounds2D();
            this.gmB = gmB;
        }

        public Shape getOutline() {
            return this.outline;
        }

        public Rectangle2D getBounds2D() {
            return this.gmB;
        }

        public Rectangle2D getOutlineBounds2D() {
            return this.outlineBounds;
        }
    }
}

