/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.echosvg.parser;

import io.sf.carte.echosvg.parser.AbstractParser;
import io.sf.carte.echosvg.parser.ParseException;
import java.io.IOException;

public abstract class NumberParser
extends AbstractParser {
    private static final double[] pow10 = new double[128];

    protected float parseFloat() throws ParseException, IOException {
        int mant = 0;
        int mantDig = 0;
        boolean mantPos = true;
        boolean mantRead = false;
        int exp = 0;
        int expDig = 0;
        int expAdj = 0;
        boolean expPos = true;
        switch (this.current) {
            case 67: 
            case 99: {
                return this.handleCalc();
            }
            case 45: {
                mantPos = false;
            }
            case 43: {
                this.current = this.reader.read();
            }
        }
        block5 : switch (this.current) {
            default: {
                this.reportUnexpectedCharacterError(this.current);
                return 0.0f;
            }
            case 46: {
                break;
            }
            case 48: {
                mantRead = true;
                block51: while (true) {
                    this.current = this.reader.read();
                    switch (this.current) {
                        case 49: 
                        case 50: 
                        case 51: 
                        case 52: 
                        case 53: 
                        case 54: 
                        case 55: 
                        case 56: 
                        case 57: {
                            break block51;
                        }
                        case 46: 
                        case 69: 
                        case 101: {
                            break block5;
                        }
                        default: {
                            return 0.0f;
                        }
                        case 48: {
                            continue block51;
                        }
                    }
                    break;
                }
            }
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: {
                mantRead = true;
                while (true) {
                    if (mantDig < 9) {
                        ++mantDig;
                        mant = mant * 10 + (this.current - 48);
                    } else {
                        ++expAdj;
                    }
                    this.current = this.reader.read();
                    switch (this.current) {
                        default: {
                            break block5;
                        }
                        case 48: 
                        case 49: 
                        case 50: 
                        case 51: 
                        case 52: 
                        case 53: 
                        case 54: 
                        case 55: 
                        case 56: 
                        case 57: 
                    }
                }
            }
        }
        if (this.current == 46) {
            this.current = this.reader.read();
            block18 : switch (this.current) {
                default: {
                    if (mantRead) break;
                    this.reportUnexpectedCharacterError(this.current);
                    return 0.0f;
                }
                case 48: {
                    if (mantDig == 0) {
                        block53: while (true) {
                            this.current = this.reader.read();
                            --expAdj;
                            switch (this.current) {
                                case 49: 
                                case 50: 
                                case 51: 
                                case 52: 
                                case 53: 
                                case 54: 
                                case 55: 
                                case 56: 
                                case 57: {
                                    break block53;
                                }
                                default: {
                                    if (mantRead) break block18;
                                    return 0.0f;
                                }
                                case 48: {
                                    continue block53;
                                }
                            }
                            break;
                        }
                    }
                }
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: {
                    while (true) {
                        if (mantDig < 9) {
                            ++mantDig;
                            mant = mant * 10 + (this.current - 48);
                            --expAdj;
                        }
                        this.current = this.reader.read();
                        switch (this.current) {
                            default: {
                                break block18;
                            }
                            case 48: 
                            case 49: 
                            case 50: 
                            case 51: 
                            case 52: 
                            case 53: 
                            case 54: 
                            case 55: 
                            case 56: 
                            case 57: 
                        }
                    }
                }
            }
        }
        block29 : switch (this.current) {
            case 69: 
            case 101: {
                this.current = this.reader.read();
                switch (this.current) {
                    default: {
                        this.reportUnexpectedCharacterError(this.current);
                        return 0.0f;
                    }
                    case 45: {
                        expPos = false;
                    }
                    case 43: {
                        this.current = this.reader.read();
                        switch (this.current) {
                            default: {
                                this.reportUnexpectedCharacterError(this.current);
                                return 0.0f;
                            }
                            case 48: 
                            case 49: 
                            case 50: 
                            case 51: 
                            case 52: 
                            case 53: 
                            case 54: 
                            case 55: 
                            case 56: 
                            case 57: 
                        }
                    }
                    case 48: 
                    case 49: 
                    case 50: 
                    case 51: 
                    case 52: 
                    case 53: 
                    case 54: 
                    case 55: 
                    case 56: 
                    case 57: 
                }
                switch (this.current) {
                    case 48: {
                        block55: while (true) {
                            this.current = this.reader.read();
                            switch (this.current) {
                                case 49: 
                                case 50: 
                                case 51: 
                                case 52: 
                                case 53: 
                                case 54: 
                                case 55: 
                                case 56: 
                                case 57: {
                                    break block55;
                                }
                                default: {
                                    break block29;
                                }
                                case 48: {
                                    continue block55;
                                }
                            }
                            break;
                        }
                    }
                    case 49: 
                    case 50: 
                    case 51: 
                    case 52: 
                    case 53: 
                    case 54: 
                    case 55: 
                    case 56: 
                    case 57: {
                        while (true) {
                            if (expDig < 3) {
                                ++expDig;
                                exp = exp * 10 + (this.current - 48);
                            }
                            this.current = this.reader.read();
                            switch (this.current) {
                                default: {
                                    break block29;
                                }
                                case 48: 
                                case 49: 
                                case 50: 
                                case 51: 
                                case 52: 
                                case 53: 
                                case 54: 
                                case 55: 
                                case 56: 
                                case 57: 
                            }
                        }
                    }
                }
            }
        }
        if (!expPos) {
            exp = -exp;
        }
        exp += expAdj;
        if (!mantPos) {
            mant = -mant;
        }
        return NumberParser.buildFloat(mant, exp);
    }

    public static float buildFloat(int mant, int exp) {
        if (exp < -125 || mant == 0) {
            return 0.0f;
        }
        if (exp >= 128) {
            return mant > 0 ? Float.POSITIVE_INFINITY : Float.NEGATIVE_INFINITY;
        }
        if (exp == 0) {
            return mant;
        }
        if (mant >= 0x4000000) {
            ++mant;
        }
        return (float)(exp > 0 ? (double)mant * pow10[exp] : (double)mant / pow10[-exp]);
    }

    private float handleCalc() throws IOException {
        int line = this.reader.getLine();
        int column = this.reader.getColumn();
        char[] calcLCRef = new char[]{'a', 'l', 'c', '('};
        char[] calcUCRef = new char[]{'A', 'L', 'C', '('};
        char[] calcBuf = new char[4];
        this.reader.read(calcBuf);
        if (NumberParser.equalsAny(calcLCRef, calcUCRef, calcBuf)) {
            this.handleCalc(line, column);
        } else {
            this.reportError("character.unexpected", new Object[]{this.current}, line, column);
        }
        return 0.0f;
    }

    private static boolean equalsAny(char[] lcRef, char[] ucRef, char[] buf) {
        assert (lcRef.length == buf.length);
        for (int i = 0; i < lcRef.length; ++i) {
            char c = buf[i];
            if (c == lcRef[i] || c == ucRef[i]) continue;
            return false;
        }
        return true;
    }

    protected void handleCalc(int line, int column) {
        this.reportError("character.unexpected", new Object[]{Character.valueOf('c')}, line, column);
    }

    private void reportError(String key, Object[] args, int line, int column) {
        this.errorHandler.error(new ParseException(this.createErrorMessage(key, args), line, column));
    }

    static {
        for (int i = 0; i < pow10.length; ++i) {
            NumberParser.pow10[i] = Math.pow(10.0, i);
        }
    }
}

