/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.echosvg.dom.svg;

import io.sf.carte.echosvg.dom.AbstractDocument;
import io.sf.carte.echosvg.dom.AbstractElement;
import io.sf.carte.echosvg.dom.svg.AbstractSVGItem;
import io.sf.carte.echosvg.dom.svg.ListBuilder;
import io.sf.carte.echosvg.dom.svg.ListHandler;
import io.sf.carte.echosvg.dom.svg.SVGItem;
import io.sf.carte.echosvg.parser.ParseException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.w3c.dom.DOMException;
import org.w3c.dom.svg.SVGException;

public abstract class AbstractSVGList {
    protected boolean valid;
    protected List<SVGItem> itemList;

    protected abstract String getItemSeparator();

    protected abstract SVGItem createSVGItem(Object var1);

    protected abstract void doParse(String var1, ListHandler var2) throws ParseException;

    protected abstract void checkItemType(Object var1) throws SVGException;

    protected abstract String getValueAsString();

    protected abstract void setAttributeValue(String var1);

    protected abstract AbstractElement getElement();

    protected String getErrorMessage(String key, Object[] args) {
        String m;
        try {
            m = ((AbstractDocument)this.getElement().getOwnerDocument()).formatMessage(key, args);
        }
        catch (Exception e) {
            m = key;
        }
        return m;
    }

    public int getNumberOfItems() {
        this.revalidate();
        if (this.itemList != null) {
            return this.itemList.size();
        }
        return 0;
    }

    public void clear() throws DOMException {
        this.revalidate();
        if (this.itemList != null) {
            this.clear(this.itemList);
            this.resetAttribute();
        }
    }

    protected SVGItem initializeImpl(Object newItem) throws DOMException, SVGException {
        this.checkItemType(newItem);
        if (this.itemList == null) {
            this.itemList = new ArrayList<SVGItem>(1);
        } else {
            this.clear(this.itemList);
        }
        SVGItem item = this.removeIfNeeded(newItem);
        this.itemList.add(item);
        item.setParent(this);
        this.resetAttribute();
        return item;
    }

    protected SVGItem getItemImpl(int index) throws DOMException {
        this.revalidate();
        if (index < 0 || this.itemList == null || index >= this.itemList.size()) {
            throw this.createDOMException((short)1, "index.out.of.bounds", new Object[]{index});
        }
        return this.itemList.get(index);
    }

    private DOMException createDOMException(short type, String key, Object[] args) {
        return this.getElement().createDOMException(type, key, args);
    }

    protected SVGItem insertItemBeforeImpl(Object newItem, int index) throws DOMException, SVGException {
        this.checkItemType(newItem);
        this.revalidate();
        if (index < 0) {
            throw this.createDOMException((short)1, "index.out.of.bounds", new Object[]{index});
        }
        if (index > this.itemList.size()) {
            index = this.itemList.size();
        }
        SVGItem item = this.removeIfNeeded(newItem);
        this.itemList.add(index, item);
        item.setParent(this);
        this.resetAttribute();
        return item;
    }

    protected SVGItem replaceItemImpl(Object newItem, int index) throws DOMException, SVGException {
        this.checkItemType(newItem);
        this.revalidate();
        if (index < 0 || index >= this.itemList.size()) {
            throw this.createDOMException((short)1, "index.out.of.bounds", new Object[]{index});
        }
        SVGItem item = this.removeIfNeeded(newItem);
        this.itemList.set(index, item);
        item.setParent(this);
        this.resetAttribute();
        return item;
    }

    protected SVGItem removeItemImpl(int index) throws DOMException {
        this.revalidate();
        if (index < 0 || index >= this.itemList.size()) {
            throw this.createDOMException((short)1, "index.out.of.bounds", new Object[]{index});
        }
        SVGItem item = this.itemList.remove(index);
        item.setParent(null);
        this.resetAttribute();
        return item;
    }

    protected SVGItem appendItemImpl(Object newItem) throws DOMException, SVGException {
        this.checkItemType(newItem);
        this.revalidate();
        SVGItem item = this.removeIfNeeded(newItem);
        this.itemList.add(item);
        item.setParent(this);
        if (this.itemList.size() <= 1) {
            this.resetAttribute();
        } else {
            this.resetAttribute(item);
        }
        return item;
    }

    protected SVGItem removeIfNeeded(Object newItem) {
        SVGItem item;
        if (newItem instanceof SVGItem) {
            item = (SVGItem)newItem;
            if (item.getParent() != null) {
                item.getParent().removeItem(item);
            }
        } else {
            item = this.createSVGItem(newItem);
        }
        return item;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void revalidate() {
        if (this.valid) {
            return;
        }
        this.valid = true;
        String s = this.getValueAsString();
        if (s == null || (s = s.trim()).isEmpty()) {
            this.clear(this.itemList);
            this.itemList = new ArrayList<SVGItem>(1);
            return;
        }
        ListBuilder builder = new ListBuilder(this);
        try {
            this.doParse(s, builder);
        }
        catch (ParseException parsedList) {
        }
        finally {
            List<SVGItem> parsedList = builder.getList();
            this.clear(this.itemList);
            this.itemList = parsedList != null ? parsedList : new ArrayList<SVGItem>(1);
        }
    }

    protected void setValueAsString(List<SVGItem> value) throws DOMException {
        String finalValue = null;
        Iterator<SVGItem> it = value.iterator();
        if (it.hasNext()) {
            SVGItem item = it.next();
            StringBuilder buf = new StringBuilder(value.size() * 8);
            buf.append(item.getValueAsString());
            while (it.hasNext()) {
                item = it.next();
                buf.append(this.getItemSeparator());
                buf.append(item.getValueAsString());
            }
            finalValue = buf.toString();
        }
        this.setAttributeValue(finalValue);
        this.valid = true;
    }

    public void itemChanged() {
        this.resetAttribute();
    }

    protected void resetAttribute() {
        this.setValueAsString(this.itemList);
    }

    protected void resetAttribute(SVGItem item) {
        String newValue = this.getValueAsString() + this.getItemSeparator() + item.getValueAsString();
        this.setAttributeValue(newValue);
        this.valid = true;
    }

    public void invalidate() {
        this.valid = false;
    }

    protected void removeItem(SVGItem item) {
        if (this.itemList.contains(item)) {
            this.itemList.remove(item);
            item.setParent(null);
            this.resetAttribute();
        }
    }

    protected void clear(List<SVGItem> list) {
        if (list == null) {
            return;
        }
        for (SVGItem item : list) {
            item.setParent(null);
        }
        list.clear();
    }

    public void copyTo(AbstractSVGList list) {
        list.valid = this.valid;
        if (this.itemList != null) {
            list.itemList = new ArrayList<SVGItem>(this.itemList.size());
            for (SVGItem item : this.itemList) {
                item = ((AbstractSVGItem)item).clone();
                item.setParent(list);
                list.itemList.add(item);
            }
        }
    }

    public String toString() {
        return this.getValueAsString();
    }
}

