/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.echosvg.svggen;

import io.sf.carte.echosvg.ext.awt.image.spi.ImageWriter;
import io.sf.carte.echosvg.ext.awt.image.spi.ImageWriterRegistry;
import io.sf.carte.echosvg.svggen.AbstractImageHandlerEncoder;
import io.sf.carte.echosvg.svggen.SVGGraphics2DIOException;
import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class ImageHandlerPNGEncoder
extends AbstractImageHandlerEncoder {
    public ImageHandlerPNGEncoder(String imageDir, String urlRoot) throws SVGGraphics2DIOException {
        super(imageDir, urlRoot);
    }

    @Override
    public final String getSuffix() {
        return ".png";
    }

    @Override
    public final String getPrefix() {
        return "pngImage";
    }

    @Override
    public void encodeImage(BufferedImage buf, File imageFile) throws SVGGraphics2DIOException {
        try (FileOutputStream os = new FileOutputStream(imageFile);){
            ImageWriter writer = ImageWriterRegistry.getInstance().getWriterFor("image/png");
            writer.writeImage((RenderedImage)buf, (OutputStream)os);
        }
        catch (IOException e) {
            throw new SVGGraphics2DIOException("could not write image File " + imageFile.getName());
        }
    }

    @Override
    public BufferedImage buildBufferedImage(Dimension size, ColorModel cm) {
        BufferedImage image;
        if (cm == null || cm.getColorSpace().isCS_sRGB()) {
            image = new BufferedImage(size.width, size.height, 2);
        } else {
            WritableRaster raster = cm.createCompatibleWritableRaster(size.width, size.height);
            image = new BufferedImage(cm, raster, false, null);
        }
        return image;
    }
}

