/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.echosvg.svggen;

import io.sf.carte.echosvg.ext.awt.g2d.GraphicContext;
import io.sf.carte.echosvg.ext.awt.g2d.TransformStackElement;
import io.sf.carte.echosvg.svggen.SVGBasicStroke;
import io.sf.carte.echosvg.svggen.SVGClip;
import io.sf.carte.echosvg.svggen.SVGComposite;
import io.sf.carte.echosvg.svggen.SVGConverter;
import io.sf.carte.echosvg.svggen.SVGDescriptor;
import io.sf.carte.echosvg.svggen.SVGFont;
import io.sf.carte.echosvg.svggen.SVGGeneratorContext;
import io.sf.carte.echosvg.svggen.SVGGraphicContext;
import io.sf.carte.echosvg.svggen.SVGGraphics2DRuntimeException;
import io.sf.carte.echosvg.svggen.SVGPaint;
import io.sf.carte.echosvg.svggen.SVGRenderingHints;
import io.sf.carte.echosvg.svggen.SVGTransform;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import org.w3c.dom.Element;

public class SVGGraphicContextConverter {
    private static final int GRAPHIC_CONTEXT_CONVERTER_COUNT = 6;
    private SVGTransform transformConverter;
    private SVGPaint paintConverter;
    private SVGBasicStroke strokeConverter;
    private SVGComposite compositeConverter;
    private SVGClip clipConverter;
    private SVGRenderingHints hintsConverter;
    private SVGFont fontConverter;
    private SVGConverter[] converters = new SVGConverter[6];

    public SVGTransform getTransformConverter() {
        return this.transformConverter;
    }

    public SVGPaint getPaintConverter() {
        return this.paintConverter;
    }

    public SVGBasicStroke getStrokeConverter() {
        return this.strokeConverter;
    }

    public SVGComposite getCompositeConverter() {
        return this.compositeConverter;
    }

    public SVGClip getClipConverter() {
        return this.clipConverter;
    }

    public SVGRenderingHints getHintsConverter() {
        return this.hintsConverter;
    }

    public SVGFont getFontConverter() {
        return this.fontConverter;
    }

    public SVGGraphicContextConverter(SVGGeneratorContext generatorContext) {
        if (generatorContext == null) {
            throw new SVGGraphics2DRuntimeException("generatorContext should not be null");
        }
        this.transformConverter = new SVGTransform(generatorContext);
        this.paintConverter = new SVGPaint(generatorContext);
        this.strokeConverter = new SVGBasicStroke(generatorContext);
        this.compositeConverter = new SVGComposite(generatorContext);
        this.clipConverter = new SVGClip(generatorContext);
        this.hintsConverter = new SVGRenderingHints(generatorContext);
        this.fontConverter = new SVGFont(generatorContext);
        int i = 0;
        this.converters[i++] = this.paintConverter;
        this.converters[i++] = this.strokeConverter;
        this.converters[i++] = this.compositeConverter;
        this.converters[i++] = this.clipConverter;
        this.converters[i++] = this.hintsConverter;
        this.converters[i++] = this.fontConverter;
    }

    public String toSVG(TransformStackElement[] transformStack) {
        return this.transformConverter.toSVGTransform(transformStack);
    }

    public SVGGraphicContext toSVG(GraphicContext gc) {
        HashMap<String, String> groupAttrMap = new HashMap<String, String>();
        for (SVGConverter converter : this.converters) {
            SVGDescriptor desc = converter.toSVG(gc);
            if (desc == null) continue;
            desc.getAttributeMap(groupAttrMap);
        }
        return new SVGGraphicContext(groupAttrMap, gc.getTransformStack());
    }

    public List<Element> getDefinitionSet() {
        LinkedList<Element> defSet = new LinkedList<Element>();
        for (SVGConverter converter : this.converters) {
            defSet.addAll(converter.getDefinitionSet());
        }
        return defSet;
    }
}

