/*

   See the NOTICE file distributed with this work for additional
   information regarding copyright ownership.

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.

 */
package io.sf.carte.echosvg.svggen.font.table;

import java.io.IOException;
import java.io.RandomAccessFile;

/**
 *
 * @author <a href="mailto:david@steadystate.co.uk">David Schweinsberg</a>
 * @author For later modifications, see Git history.
 * @version $Id$
 */
public class GposTable implements Table {

	protected GposTable(DirectoryEntry de, RandomAccessFile raf) throws IOException {
		raf.seek(de.getOffset());

		// GPOS Header
		/* int version = */ raf.readInt();
		/* int scriptList = */ raf.readInt();
		/* int featureList = */ raf.readInt();
		/* int lookupList = */ raf.readInt();
		/*
		 * for (int i = 0; i < t_maxp.getNumGlyphs(); i++) { raf.seek(tde.getOffset() +
		 * t_loca.getOffset(i)); int len = t_loca.getOffset((short)(i + 1)) -
		 * t_loca.getOffset(i); if (len > 0) { short numberOfContours = raf.readShort();
		 * if (numberOfContours < 0) { // descript[i] = new
		 * TableGlyfCompositeDescript(this, raf); } else { descript[i] = new
		 * TableGlyfSimpleDescript(this, numberOfContours, raf); } } else { descript[i]
		 * = null; } }
		 * 
		 * for (int i = 0; i < t_maxp.getNumGlyphs(); i++) { raf.seek(tde.getOffset() +
		 * t_loca.getOffset(i)); int len = t_loca.getOffset((short)(i + 1)) -
		 * t_loca.getOffset(i); if (len > 0) { short numberOfContours = raf.readShort();
		 * if (numberOfContours < 0) { descript[i] = new
		 * TableGlyfCompositeDescript(this, raf); } } }
		 */
	}

	/**
	 * Get the table type, as a table directory value.
	 * 
	 * @return The table type
	 */
	@Override
	public int getType() {
		return GPOS;
	}

	@Override
	public String toString() {
		return "GPOS";
	}

}
