/*

   See the NOTICE file distributed with this work for additional
   information regarding copyright ownership.

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.

 */
package io.sf.carte.echosvg.svggen;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

import org.w3c.dom.Element;

/**
 * Used to represent an SVG Paint. This can be achieved with to values: an SVG
 * paint value and an SVG opacity value
 *
 * @author <a href="mailto:vincent.hardy@eng.sun.com">Vincent Hardy</a>
 * @author For later modifications, see Git history.
 * @version $Id$
 */
public class SVGStrokeDescriptor implements SVGDescriptor, SVGSyntax {

	private String strokeWidth;
	private String capStyle;
	private String joinStyle;
	private String miterLimit;
	private String dashArray;
	private String dashOffset;

	public SVGStrokeDescriptor(String strokeWidth, String capStyle, String joinStyle, String miterLimit,
			String dashArray, String dashOffset) {
		if (strokeWidth == null || capStyle == null || joinStyle == null || miterLimit == null || dashArray == null
				|| dashOffset == null)
			throw new SVGGraphics2DRuntimeException(ErrorConstants.ERR_STROKE_NULL);

		this.strokeWidth = strokeWidth;
		this.capStyle = capStyle;
		this.joinStyle = joinStyle;
		this.miterLimit = miterLimit;
		this.dashArray = dashArray;
		this.dashOffset = dashOffset;
	}

	String getStrokeWidth() {
		return strokeWidth;
	}

	String getCapStyle() {
		return capStyle;
	}

	String getJoinStyle() {
		return joinStyle;
	}

	String getMiterLimit() {
		return miterLimit;
	}

	String getDashArray() {
		return dashArray;
	}

	String getDashOffset() {
		return dashOffset;
	}

	@Override
	public Map<String, String> getAttributeMap(Map<String, String> attrMap) {
		if (attrMap == null)
			attrMap = new HashMap<>();

		attrMap.put(SVG_STROKE_WIDTH_ATTRIBUTE, strokeWidth);
		attrMap.put(SVG_STROKE_LINECAP_ATTRIBUTE, capStyle);
		attrMap.put(SVG_STROKE_LINEJOIN_ATTRIBUTE, joinStyle);
		attrMap.put(SVG_STROKE_MITERLIMIT_ATTRIBUTE, miterLimit);
		attrMap.put(SVG_STROKE_DASHARRAY_ATTRIBUTE, dashArray);
		attrMap.put(SVG_STROKE_DASHOFFSET_ATTRIBUTE, dashOffset);

		return attrMap;
	}

	@Override
	public List<Element> getDefinitionSet(List<Element> defSet) {
		if (defSet == null)
			defSet = new LinkedList<>();

		return defSet;
	}

}
