/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.echosvg.svggen;

import io.sf.carte.echosvg.svggen.AbstractSVGConverter;
import io.sf.carte.echosvg.svggen.SVGColor;
import io.sf.carte.echosvg.svggen.SVGGeneratorContext;
import io.sf.carte.echosvg.svggen.SVGPaintDescriptor;
import java.awt.Color;
import java.awt.MultipleGradientPaint;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public abstract class AbstractSVGGradient
extends AbstractSVGConverter {
    public AbstractSVGGradient(SVGGeneratorContext generatorContext) {
        super(generatorContext);
    }

    protected static String getSpreadMethod(MultipleGradientPaint gradient) {
        switch (gradient.getCycleMethod()) {
            case REFLECT: {
                return "reflect";
            }
            case REPEAT: {
                return "repeat";
            }
        }
        return "pad";
    }

    protected Element getGradientStop(Document domFactory, float[] gradientFractions, int i, Color[] gradientColors) {
        Element gradientStop = domFactory.createElementNS("http://www.w3.org/2000/svg", "stop");
        gradientStop.setAttribute("offset", this.doubleString(gradientFractions[i] * 100.0f) + "%");
        SVGPaintDescriptor colorDesc = SVGColor.toSVG(gradientColors[i], this.getGeneratorContext());
        gradientStop.setAttribute("stop-color", colorDesc.getPaintValue());
        gradientStop.setAttribute("stop-opacity", colorDesc.getOpacityValue());
        return gradientStop;
    }

    protected void addGradientStops(MultipleGradientPaint gradient, Element gradientDef, Document domFactory) {
        Color[] gradientColors = gradient.getColors();
        float[] gradientFractions = gradient.getFractions();
        for (int i = 0; i < gradientColors.length; ++i) {
            gradientDef.appendChild(this.getGradientStop(domFactory, gradientFractions, i, gradientColors));
        }
    }
}

