/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.echosvg.svggen;

import io.sf.carte.echosvg.ext.awt.image.spi.ImageWriter;
import io.sf.carte.echosvg.ext.awt.image.spi.ImageWriterParams;
import io.sf.carte.echosvg.ext.awt.image.spi.ImageWriterRegistry;
import io.sf.carte.echosvg.svggen.DefaultCachedImageHandler;
import io.sf.carte.echosvg.svggen.ImageCacher;
import io.sf.carte.echosvg.svggen.SVGGraphics2DIOException;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.OutputStream;

public class CachedImageHandlerJPEGEncoder
extends DefaultCachedImageHandler {
    public static final String CACHED_JPEG_PREFIX = "jpegImage";
    public static final String CACHED_JPEG_SUFFIX = ".jpg";
    protected String refPrefix = "";

    public CachedImageHandlerJPEGEncoder(String imageDir, String urlRoot) throws SVGGraphics2DIOException {
        this.refPrefix = urlRoot + "/";
        this.setImageCacher(new ImageCacher.External(imageDir, CACHED_JPEG_PREFIX, CACHED_JPEG_SUFFIX));
    }

    @Override
    public void encodeImage(BufferedImage buf, OutputStream os) throws IOException {
        ImageWriter writer = ImageWriterRegistry.getInstance().getWriterFor("image/jpeg");
        ImageWriterParams params = new ImageWriterParams();
        params.setJPEGQuality(1.0f, false);
        writer.writeImage((RenderedImage)buf, os, params);
    }

    @Override
    protected int getDefaultBufferedImageType() {
        return 1;
    }

    @Override
    public String getRefPrefix() {
        return this.refPrefix;
    }
}

