/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.echosvg.svggen;

import io.sf.carte.echosvg.ext.awt.image.spi.ImageWriter;
import io.sf.carte.echosvg.ext.awt.image.spi.ImageWriterRegistry;
import io.sf.carte.echosvg.svggen.DefaultCachedImageHandler;
import io.sf.carte.echosvg.svggen.ImageCacher;
import io.sf.carte.echosvg.svggen.SVGGraphics2DIOException;
import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.io.IOException;
import java.io.OutputStream;

public class CachedImageHandlerPNGEncoder
extends DefaultCachedImageHandler {
    public static final String CACHED_PNG_PREFIX = "pngImage";
    public static final String CACHED_PNG_SUFFIX = ".png";
    protected String refPrefix = "";

    public CachedImageHandlerPNGEncoder(String imageDir, String urlRoot) throws SVGGraphics2DIOException {
        this.refPrefix = urlRoot + "/";
        this.setImageCacher(new ImageCacher.External(imageDir, CACHED_PNG_PREFIX, CACHED_PNG_SUFFIX));
    }

    @Override
    public void encodeImage(BufferedImage buf, OutputStream os) throws IOException {
        ImageWriter writer = ImageWriterRegistry.getInstance().getWriterFor("image/png");
        writer.writeImage((RenderedImage)buf, os);
    }

    @Override
    public BufferedImage buildBufferedImage(Dimension size, ColorModel cm) {
        BufferedImage image;
        if (cm == null || cm.getColorSpace().isCS_sRGB()) {
            image = new BufferedImage(size.width, size.height, this.getDefaultBufferedImageType());
        } else {
            WritableRaster raster = cm.createCompatibleWritableRaster(size.width, size.height);
            image = new BufferedImage(cm, raster, false, null);
        }
        return image;
    }

    @Override
    protected int getDefaultBufferedImageType() {
        return 2;
    }

    @Override
    public String getRefPrefix() {
        return this.refPrefix;
    }
}

