/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.echosvg.svggen;

import io.sf.carte.echosvg.ext.awt.image.spi.ImageWriter;
import io.sf.carte.echosvg.ext.awt.image.spi.ImageWriterParams;
import io.sf.carte.echosvg.ext.awt.image.spi.ImageWriterRegistry;
import io.sf.carte.echosvg.ext.awt.image.spi.PNGImageWriterParams;
import io.sf.carte.echosvg.svggen.DefaultImageHandler;
import io.sf.carte.echosvg.svggen.SVGGeneratorContext;
import io.sf.carte.echosvg.svggen.SVGGraphics2DIOException;
import io.sf.carte.echosvg.svggen.SVGGraphics2DRuntimeException;
import io.sf.carte.echosvg.util.Base64EncoderStream;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.awt.image.renderable.RenderableImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.w3c.dom.Element;

public class ImageHandlerBase64Encoder
extends DefaultImageHandler {
    @Override
    public void handleHREF(Image image, Element imageElement, SVGGeneratorContext generatorContext) throws SVGGraphics2DIOException {
        if (image == null) {
            throw new SVGGraphics2DRuntimeException("image should not be null");
        }
        int width = image.getWidth(null);
        int height = image.getHeight(null);
        if (width == 0 || height == 0) {
            this.handleEmptyImage(imageElement);
        } else if (image instanceof RenderedImage) {
            this.handleHREF((RenderedImage)((Object)image), imageElement, generatorContext);
        } else {
            BufferedImage buf = new BufferedImage(width, height, 2);
            Graphics2D g = buf.createGraphics();
            g.drawImage(image, 0, 0, null);
            g.dispose();
            this.handleHREF(buf, imageElement, generatorContext);
        }
    }

    @Override
    public void handleHREF(RenderableImage image, Element imageElement, SVGGeneratorContext generatorContext) throws SVGGraphics2DIOException {
        if (image == null) {
            throw new SVGGraphics2DRuntimeException("image should not be null");
        }
        RenderedImage r = image.createDefaultRendering();
        if (r == null) {
            this.handleEmptyImage(imageElement);
        } else {
            this.handleHREF(r, imageElement, generatorContext);
        }
    }

    protected void handleEmptyImage(Element imageElement) {
        imageElement.setAttributeNS("http://www.w3.org/1999/xlink", "xlink:href", "data:image/png;base64,");
        imageElement.setAttributeNS(null, "width", "0");
        imageElement.setAttributeNS(null, "height", "0");
    }

    @Override
    public void handleHREF(RenderedImage image, Element imageElement, SVGGeneratorContext generatorContext) throws SVGGraphics2DIOException {
        ByteArrayOutputStream os = new ByteArrayOutputStream(2048);
        Base64EncoderStream b64Encoder = new Base64EncoderStream((OutputStream)os);
        try {
            this.encodeImage(image, (OutputStream)b64Encoder, generatorContext.getCompressionLevel());
            b64Encoder.close();
        }
        catch (IOException e) {
            throw new SVGGraphics2DIOException("unexpected exception", e);
        }
        imageElement.setAttributeNS("http://www.w3.org/1999/xlink", "xlink:href", "data:image/png;base64," + os.toString());
    }

    public void encodeImage(RenderedImage buf, OutputStream os) throws SVGGraphics2DIOException {
        this.encodeImage(buf, os, null);
    }

    public void encodeImage(RenderedImage buf, OutputStream os, Integer compressionLevel) throws SVGGraphics2DIOException {
        try {
            PNGImageWriterParams params = null;
            if (compressionLevel != null) {
                params = new PNGImageWriterParams();
                params.setCompressionLevel(compressionLevel.intValue());
            }
            ImageWriter writer = ImageWriterRegistry.getInstance().getWriterFor("image/png");
            writer.writeImage(buf, os, (ImageWriterParams)params);
        }
        catch (IOException e) {
            throw new SVGGraphics2DIOException("unexpected exception");
        }
    }

    public BufferedImage buildBufferedImage(Dimension size, ColorModel cm) {
        BufferedImage image;
        if (cm == null || cm.getColorSpace().isCS_sRGB()) {
            image = new BufferedImage(size.width, size.height, 2);
        } else {
            WritableRaster raster = cm.createCompatibleWritableRaster(size.width, size.height);
            image = new BufferedImage(cm, raster, false, null);
        }
        return image;
    }
}

